/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;

public class ClientUtils {
    public static List<InetSocketAddress> parseAndValidateAddresses(List<String> urls) {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (String url : urls) {
            if (url == null || url.length() <= 0) continue;
            String host = Utils.getHost(url);
            Integer port = Utils.getPort(url);
            if (host == null || port == null) {
                throw new ConfigException("Invalid url in bootstrap.servers: " + url);
            }
            try {
                InetSocketAddress address = new InetSocketAddress(host, (int)port);
                if (address.isUnresolved()) {
                    throw new ConfigException("DNS resolution failed for url in bootstrap.servers: " + url);
                }
                addresses.add(address);
            }
            catch (NumberFormatException e) {
                throw new ConfigException("Invalid port in bootstrap.servers: " + url);
            }
        }
        if (addresses.size() < 1) {
            throw new ConfigException("No bootstrap urls given in bootstrap.servers");
        }
        return addresses;
    }
}

