/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAction
extends SAMLObject
implements Cloneable {
    public static final String SAML_ACTION_NAMESPACE_RWEDC = "urn:oasis:names:tc:SAML:1.0:action:rwedc";
    public static final String SAML_ACTION_NAMESPACE_RWEDC_NEG = "urn:oasis:names:tc:SAML:1.0:action:rwedc-negation";
    public static final String SAML_ACTION_NAMESPACE_GHPP = "urn:oasis:names:tc:SAML:1.0:action:ghpp";
    public static final String SAML_ACTION_NAMESPACE_UNIX = "urn:oasis:names:tc:SAML:1.0:action:unix";
    private String namespace = null;
    private String data = null;

    public SAMLAction() {
    }

    public SAMLAction(String string, String string2) throws SAMLException {
        this.namespace = XML.assign(string);
        this.data = XML.assign(string2);
    }

    public SAMLAction(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLAction(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLAction.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Action")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAction() requires saml:Action at root");
        }
        this.namespace = XML.assign(element.getAttributeNS(null, "Namespace"));
        if (element.hasChildNodes()) {
            this.data = XML.assign(element.getFirstChild().getNodeValue());
        }
        this.checkValidity();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getData() {
        return this.data;
    }

    public void setNamespace(String string) {
        this.namespace = XML.assign(string);
        this.setDirty(true);
    }

    public void setData(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("data cannot be null or empty");
        }
        this.data = string;
        this.setDirty(true);
    }

    protected Element buildRoot(Document document, boolean bl) {
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Action");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return element;
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        super.toDOM(document, bl);
        if (this.dirty) {
            Element element = (Element)this.root;
            if (!XML.isEmpty(this.namespace)) {
                element.setAttributeNS(null, "Namespace", this.namespace);
            }
            element.appendChild(document.createTextNode(this.data));
            this.setDirty(false);
        } else if (bl) {
            ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (XML.isEmpty(this.data)) {
            throw new MalformedException("Action is invalid, data must have a value");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

