/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.acquisition.GeometryType;
import org.opengis.metadata.acquisition.Operation;
import org.opengis.metadata.acquisition.Plan;
import org.opengis.metadata.acquisition.Requirement;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.Progress;

@XmlType(name="MI_Plan_Type", propOrder={"type", "status", "citation", "operations", "satisfiedRequirements"})
@XmlRootElement(name="MI_Plan")
public class DefaultPlan
extends ISOMetadata
implements Plan {
    private static final long serialVersionUID = -1212695055582082867L;
    private GeometryType type;
    private Progress status;
    private Citation citation;
    private Collection<Operation> operations;
    private Collection<Requirement> satisfiedRequirements;

    public DefaultPlan() {
    }

    public DefaultPlan(Plan plan) {
        super(plan);
        if (plan != null) {
            this.type = plan.getType();
            this.status = plan.getStatus();
            this.citation = plan.getCitation();
            this.operations = this.copyCollection(plan.getOperations(), Operation.class);
            this.satisfiedRequirements = this.copyCollection(plan.getSatisfiedRequirements(), Requirement.class);
        }
    }

    public static DefaultPlan castOrCopy(Plan plan) {
        if (plan == null || plan instanceof DefaultPlan) {
            return (DefaultPlan)plan;
        }
        return new DefaultPlan(plan);
    }

    @XmlElement(name="type")
    public GeometryType getType() {
        return this.type;
    }

    public void setType(GeometryType geometryType) {
        this.checkWritePermission(this.type);
        this.type = geometryType;
    }

    @XmlElement(name="status", required=true)
    public Progress getStatus() {
        return this.status;
    }

    public void setStatus(Progress progress) {
        this.checkWritePermission(this.status);
        this.status = progress;
    }

    @XmlElement(name="citation", required=true)
    public Citation getCitation() {
        return this.citation;
    }

    public void setCitation(Citation citation) {
        this.checkWritePermission(this.citation);
        this.citation = citation;
    }

    @XmlElement(name="operation")
    public Collection<Operation> getOperations() {
        this.operations = this.nonNullCollection(this.operations, Operation.class);
        return this.operations;
    }

    public void setOperations(Collection<? extends Operation> collection) {
        this.operations = this.writeCollection(collection, this.operations, Operation.class);
    }

    @XmlElement(name="satisfiedRequirement")
    public Collection<Requirement> getSatisfiedRequirements() {
        this.satisfiedRequirements = this.nonNullCollection(this.satisfiedRequirements, Requirement.class);
        return this.satisfiedRequirements;
    }

    public void setSatisfiedRequirements(Collection<? extends Requirement> collection) {
        this.satisfiedRequirements = this.writeCollection(collection, this.satisfiedRequirements, Requirement.class);
    }
}

