/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class FilterParser {
    private FilterParser() {
    }

    public static boolean isContainedInFilter(String propertyId, List<String> requestedIds) {
        if (requestedIds.contains("*")) {
            return true;
        }
        return requestedIds.contains(propertyId);
    }

    public static List<String> getRequestedIdsFromFilter(String filter) {
        if (filter == null || filter.length() == 0) {
            return Collections.singletonList("*");
        }
        List<String> requestedIds = Arrays.asList(filter.split(",\\s*"));
        if (!requestedIds.contains("cmis:objectId")) {
            requestedIds = new ArrayList<String>(requestedIds);
            requestedIds.add("cmis:objectId");
        }
        if (requestedIds.contains("*")) {
            requestedIds = Collections.singletonList("*");
        }
        return requestedIds;
    }
}

