/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import ucar.unidata.geoloc.LatLonPoint;

public class LatLonPointImmutable
implements LatLonPoint {
    public static final LatLonPointImmutable INVALID = new LatLonPointImmutable(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private final double lat;
    private final double lon;

    public LatLonPointImmutable(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    @Override
    public double getLongitude() {
        return this.lon;
    }

    @Override
    public double getLatitude() {
        return this.lat;
    }

    @Override
    public boolean equals(LatLonPoint pt) {
        if (Double.compare(pt.getLatitude(), this.lat) != 0) {
            return false;
        }
        return Double.compare(pt.getLongitude(), this.lon) == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LatLonPoint)) {
            return false;
        }
        LatLonPoint that = (LatLonPoint)o;
        return this.equals(that);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.lat);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

