/*
 * Decompiled with CFR 0.152.
 */
package com.pff;

import com.pff.PSTObject;
import java.util.SimpleTimeZone;

public class PSTTimeZone {
    public static SimpleTimeZone utcTimeZone = new SimpleTimeZone(0, "UTC");
    private String name;
    private TZRule rule;
    private SimpleTimeZone simpleTimeZone = null;

    PSTTimeZone(byte[] timeZoneData) {
        this.rule = null;
        this.name = "";
        try {
            int headerLen = (int)PSTObject.convertLittleEndianBytesToLong(timeZoneData, 2, 4);
            int nameLen = 2 * (int)PSTObject.convertLittleEndianBytesToLong(timeZoneData, 6, 8);
            this.name = new String(timeZoneData, 8, nameLen, "UTF-16LE");
            int ruleOffset = 8 + nameLen;
            int nRules = (int)PSTObject.convertLittleEndianBytesToLong(timeZoneData, ruleOffset, ruleOffset + 2);
            ruleOffset = 4 + headerLen;
            for (int rule = 0; rule < nRules; ++rule) {
                int flags = (int)PSTObject.convertLittleEndianBytesToLong(timeZoneData, ruleOffset + 4, ruleOffset + 6);
                if ((flags & 2) != 0) {
                    this.rule = new TZRule(timeZoneData, ruleOffset + 6);
                    break;
                }
                ruleOffset += 66;
            }
        }
        catch (Exception e) {
            System.err.printf("Exception reading timezone: %s\n", e.toString());
            e.printStackTrace();
            this.rule = null;
            this.name = "";
        }
    }

    PSTTimeZone(String name, byte[] timeZoneData) {
        this.name = name;
        this.rule = null;
        try {
            this.rule = new TZRule(new SYSTEMTIME(), timeZoneData, 0);
        }
        catch (Exception e) {
            System.err.printf("Exception reading timezone: %s\n", e.toString());
            e.printStackTrace();
            this.rule = null;
            name = "";
        }
    }

    public String getName() {
        return this.name;
    }

    public SimpleTimeZone getSimpleTimeZone() {
        if (this.simpleTimeZone != null) {
            return this.simpleTimeZone;
        }
        if (this.rule.startStandard.wMonth == 0) {
            this.simpleTimeZone = new SimpleTimeZone((this.rule.lBias + this.rule.lStandardBias) * 60 * 1000, this.name);
            return this.simpleTimeZone;
        }
        int startMonth = this.rule.startDaylight.wMonth - 1 + 0;
        int startDayOfMonth = this.rule.startDaylight.wDay == 5 ? -1 : (this.rule.startDaylight.wDay - 1) * 7 + 1;
        int startDayOfWeek = this.rule.startDaylight.wDayOfWeek + 1;
        int endMonth = this.rule.startStandard.wMonth - 1 + 0;
        int endDayOfMonth = this.rule.startStandard.wDay == 5 ? -1 : (this.rule.startStandard.wDay - 1) * 7 + 1;
        int endDayOfWeek = this.rule.startStandard.wDayOfWeek + 1;
        int savings = (this.rule.lStandardBias - this.rule.lDaylightBias) * 60 * 1000;
        this.simpleTimeZone = new SimpleTimeZone(-((this.rule.lBias + this.rule.lStandardBias) * 60 * 1000), this.name, startMonth, startDayOfMonth, -startDayOfWeek, ((this.rule.startDaylight.wHour * 60 + this.rule.startDaylight.wMinute) * 60 + this.rule.startDaylight.wSecond) * 1000 + this.rule.startDaylight.wMilliseconds, endMonth, endDayOfMonth, -endDayOfWeek, ((this.rule.startStandard.wHour * 60 + this.rule.startStandard.wMinute) * 60 + this.rule.startStandard.wSecond) * 1000 + this.rule.startStandard.wMilliseconds, savings);
        return this.simpleTimeZone;
    }

    public boolean isEqual(PSTTimeZone rhs) {
        if (this.name.equalsIgnoreCase(rhs.name)) {
            if (this.rule.isEqual(rhs.rule)) {
                return true;
            }
            System.err.printf("Warning: different timezones with the same name: %s\n", this.name);
        }
        return false;
    }

    public SYSTEMTIME getStart() {
        return this.rule.dtStart;
    }

    public int getBias() {
        return this.rule.lBias;
    }

    public int getStandardBias() {
        return this.rule.lStandardBias;
    }

    public int getDaylightBias() {
        return this.rule.lDaylightBias;
    }

    public SYSTEMTIME getDaylightStart() {
        return this.rule.startDaylight;
    }

    public SYSTEMTIME getStandardStart() {
        return this.rule.startStandard;
    }

    private class TZRule {
        SYSTEMTIME dtStart;
        int lBias;
        int lStandardBias;
        int lDaylightBias;
        SYSTEMTIME startStandard;
        SYSTEMTIME startDaylight;

        TZRule(SYSTEMTIME dtStart, byte[] timeZoneData, int offset) {
            this.dtStart = dtStart;
            this.InitBiases(timeZoneData, offset);
            short wStandardYear = (short)PSTObject.convertLittleEndianBytesToLong(timeZoneData, offset + 12, offset + 14);
            this.startStandard = new SYSTEMTIME(timeZoneData, offset + 14);
            short wDaylightYear = (short)PSTObject.convertLittleEndianBytesToLong(timeZoneData, offset + 30, offset + 32);
            this.startDaylight = new SYSTEMTIME(timeZoneData, offset + 32);
        }

        TZRule(byte[] timeZoneData, int offset) {
            this.dtStart = new SYSTEMTIME(timeZoneData, offset);
            this.InitBiases(timeZoneData, offset + 16);
            this.startStandard = new SYSTEMTIME(timeZoneData, offset + 28);
            this.startDaylight = new SYSTEMTIME(timeZoneData, offset + 44);
        }

        private void InitBiases(byte[] timeZoneData, int offset) {
            this.lBias = (int)PSTObject.convertLittleEndianBytesToLong(timeZoneData, offset, offset + 4);
            this.lStandardBias = (int)PSTObject.convertLittleEndianBytesToLong(timeZoneData, offset + 4, offset + 8);
            this.lDaylightBias = (int)PSTObject.convertLittleEndianBytesToLong(timeZoneData, offset + 8, offset + 12);
        }

        boolean isEqual(TZRule rhs) {
            return this.dtStart.isEqual(rhs.dtStart) && this.lBias == rhs.lBias && this.lStandardBias == rhs.lStandardBias && this.lDaylightBias == rhs.lDaylightBias && this.startStandard.isEqual(rhs.startStandard) && this.startDaylight.isEqual(rhs.startDaylight);
        }
    }

    public class SYSTEMTIME {
        public short wYear;
        public short wMonth;
        public short wDayOfWeek;
        public short wDay;
        public short wHour;
        public short wMinute;
        public short wSecond;
        public short wMilliseconds;

        SYSTEMTIME() {
            this.wYear = 0;
            this.wMonth = 0;
            this.wDayOfWeek = 0;
            this.wDay = 0;
            this.wHour = 0;
            this.wMinute = 0;
            this.wSecond = 0;
            this.wMilliseconds = 0;
        }

        SYSTEMTIME(byte[] timeZoneData, int offset) {
            this.wYear = (short)(PSTObject.convertLittleEndianBytesToLong(timeZoneData, offset, offset + 2) & 0x7FFFL);
            this.wMonth = (short)(PSTObject.convertLittleEndianBytesToLong(timeZoneData, offset + 2, offset + 4) & 0x7FFFL);
            this.wDayOfWeek = (short)(PSTObject.convertLittleEndianBytesToLong(timeZoneData, offset + 4, offset + 6) & 0x7FFFL);
            this.wDay = (short)(PSTObject.convertLittleEndianBytesToLong(timeZoneData, offset + 6, offset + 8) & 0x7FFFL);
            this.wHour = (short)(PSTObject.convertLittleEndianBytesToLong(timeZoneData, offset + 8, offset + 10) & 0x7FFFL);
            this.wMinute = (short)(PSTObject.convertLittleEndianBytesToLong(timeZoneData, offset + 10, offset + 12) & 0x7FFFL);
            this.wSecond = (short)(PSTObject.convertLittleEndianBytesToLong(timeZoneData, offset + 12, offset + 14) & 0x7FFFL);
            this.wMilliseconds = (short)(PSTObject.convertLittleEndianBytesToLong(timeZoneData, offset + 14, offset + 16) & 0x7FFFL);
        }

        boolean isEqual(SYSTEMTIME rhs) {
            return this.wYear == rhs.wYear && this.wMonth == rhs.wMonth && this.wDayOfWeek == rhs.wDayOfWeek && this.wDay == rhs.wDay && this.wHour == rhs.wHour && this.wMinute == rhs.wMinute && this.wSecond == rhs.wSecond && this.wMilliseconds == rhs.wMilliseconds;
        }
    }
}

