/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.protobuf.BlockingService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.ha.proto.HAServiceProtocolProtos;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolPB;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.inotify.Event;
import org.apache.hadoop.hdfs.inotify.EventsList;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.FSLimitException;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.NamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.InotifyFSEditLogOpTranslator;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.server.namenode.UnsupportedActionException;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.FinalizeCommand;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.NodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.GenericRefreshProtocol;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RefreshCallQueueProtocol;
import org.apache.hadoop.ipc.RefreshRegistry;
import org.apache.hadoop.ipc.RefreshResponse;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.WritableRpcEngine;
import org.apache.hadoop.ipc.proto.GenericRefreshProtocolProtos;
import org.apache.hadoop.ipc.proto.RefreshCallQueueProtocolProtos;
import org.apache.hadoop.ipc.protocolPB.GenericRefreshProtocolPB;
import org.apache.hadoop.ipc.protocolPB.GenericRefreshProtocolServerSideTranslatorPB;
import org.apache.hadoop.ipc.protocolPB.RefreshCallQueueProtocolPB;
import org.apache.hadoop.ipc.protocolPB.RefreshCallQueueProtocolServerSideTranslatorPB;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.security.proto.RefreshAuthorizationPolicyProtocolProtos;
import org.apache.hadoop.security.proto.RefreshUserMappingsProtocolProtos;
import org.apache.hadoop.security.protocolPB.RefreshAuthorizationPolicyProtocolPB;
import org.apache.hadoop.security.protocolPB.RefreshAuthorizationPolicyProtocolServerSideTranslatorPB;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolPB;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolServerSideTranslatorPB;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.tools.GetUserMappingsProtocol;
import org.apache.hadoop.tools.proto.GetUserMappingsProtocolProtos;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolPB;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolServerSideTranslatorPB;
import org.apache.hadoop.tracing.SpanReceiverInfo;
import org.apache.hadoop.tracing.TraceAdminPB;
import org.apache.hadoop.tracing.TraceAdminProtocol;
import org.apache.hadoop.tracing.TraceAdminProtocolPB;
import org.apache.hadoop.tracing.TraceAdminProtocolServerSideTranslatorPB;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.VersionUtil;

class NameNodeRpcServer
implements NamenodeProtocols {
    private static final Log LOG = NameNode.LOG;
    private static final Log stateChangeLog = NameNode.stateChangeLog;
    private static final Log blockStateChangeLog = NameNode.blockStateChangeLog;
    protected final FSNamesystem namesystem;
    protected final NameNode nn;
    private final NameNodeMetrics metrics;
    private final boolean serviceAuthEnabled;
    private final RPC.Server serviceRpcServer;
    private final InetSocketAddress serviceRPCAddress;
    protected final RPC.Server clientRpcServer;
    protected final InetSocketAddress clientRpcAddress;
    private final String minimumDataNodeVersion;

    public NameNodeRpcServer(Configuration conf, NameNode nn) throws IOException {
        InetSocketAddress listenAddr;
        this.nn = nn;
        this.namesystem = nn.getNamesystem();
        this.metrics = NameNode.getNameNodeMetrics();
        int handlerCount = conf.getInt("dfs.namenode.handler.count", 10);
        RPC.setProtocolEngine((Configuration)conf, ClientNamenodeProtocolPB.class, ProtobufRpcEngine.class);
        ClientNamenodeProtocolServerSideTranslatorPB clientProtocolServerTranslator = new ClientNamenodeProtocolServerSideTranslatorPB(this);
        BlockingService clientNNPbService = ClientNamenodeProtocolProtos.ClientNamenodeProtocol.newReflectiveBlockingService(clientProtocolServerTranslator);
        DatanodeProtocolServerSideTranslatorPB dnProtoPbTranslator = new DatanodeProtocolServerSideTranslatorPB(this);
        BlockingService dnProtoPbService = DatanodeProtocolProtos.DatanodeProtocolService.newReflectiveBlockingService(dnProtoPbTranslator);
        NamenodeProtocolServerSideTranslatorPB namenodeProtocolXlator = new NamenodeProtocolServerSideTranslatorPB(this);
        BlockingService NNPbService = NamenodeProtocolProtos.NamenodeProtocolService.newReflectiveBlockingService(namenodeProtocolXlator);
        RefreshAuthorizationPolicyProtocolServerSideTranslatorPB refreshAuthPolicyXlator = new RefreshAuthorizationPolicyProtocolServerSideTranslatorPB((RefreshAuthorizationPolicyProtocol)this);
        BlockingService refreshAuthService = RefreshAuthorizationPolicyProtocolProtos.RefreshAuthorizationPolicyProtocolService.newReflectiveBlockingService((RefreshAuthorizationPolicyProtocolProtos.RefreshAuthorizationPolicyProtocolService.BlockingInterface)refreshAuthPolicyXlator);
        RefreshUserMappingsProtocolServerSideTranslatorPB refreshUserMappingXlator = new RefreshUserMappingsProtocolServerSideTranslatorPB((RefreshUserMappingsProtocol)this);
        BlockingService refreshUserMappingService = RefreshUserMappingsProtocolProtos.RefreshUserMappingsProtocolService.newReflectiveBlockingService((RefreshUserMappingsProtocolProtos.RefreshUserMappingsProtocolService.BlockingInterface)refreshUserMappingXlator);
        RefreshCallQueueProtocolServerSideTranslatorPB refreshCallQueueXlator = new RefreshCallQueueProtocolServerSideTranslatorPB((RefreshCallQueueProtocol)this);
        BlockingService refreshCallQueueService = RefreshCallQueueProtocolProtos.RefreshCallQueueProtocolService.newReflectiveBlockingService((RefreshCallQueueProtocolProtos.RefreshCallQueueProtocolService.BlockingInterface)refreshCallQueueXlator);
        GenericRefreshProtocolServerSideTranslatorPB genericRefreshXlator = new GenericRefreshProtocolServerSideTranslatorPB((GenericRefreshProtocol)this);
        BlockingService genericRefreshService = GenericRefreshProtocolProtos.GenericRefreshProtocolService.newReflectiveBlockingService((GenericRefreshProtocolProtos.GenericRefreshProtocolService.BlockingInterface)genericRefreshXlator);
        GetUserMappingsProtocolServerSideTranslatorPB getUserMappingXlator = new GetUserMappingsProtocolServerSideTranslatorPB((GetUserMappingsProtocol)this);
        BlockingService getUserMappingService = GetUserMappingsProtocolProtos.GetUserMappingsProtocolService.newReflectiveBlockingService((GetUserMappingsProtocolProtos.GetUserMappingsProtocolService.BlockingInterface)getUserMappingXlator);
        HAServiceProtocolServerSideTranslatorPB haServiceProtocolXlator = new HAServiceProtocolServerSideTranslatorPB((HAServiceProtocol)this);
        BlockingService haPbService = HAServiceProtocolProtos.HAServiceProtocolService.newReflectiveBlockingService((HAServiceProtocolProtos.HAServiceProtocolService.BlockingInterface)haServiceProtocolXlator);
        TraceAdminProtocolServerSideTranslatorPB traceAdminXlator = new TraceAdminProtocolServerSideTranslatorPB((TraceAdminProtocol)this);
        BlockingService traceAdminService = TraceAdminPB.TraceAdminService.newReflectiveBlockingService((TraceAdminPB.TraceAdminService.BlockingInterface)traceAdminXlator);
        WritableRpcEngine.ensureInitialized();
        InetSocketAddress serviceRpcAddr = nn.getServiceRpcServerAddress(conf);
        if (serviceRpcAddr != null) {
            String bindHost = nn.getServiceRpcServerBindHost(conf);
            if (bindHost == null) {
                bindHost = serviceRpcAddr.getHostName();
            }
            LOG.info((Object)("Service RPC server is binding to " + bindHost + ":" + serviceRpcAddr.getPort()));
            int serviceHandlerCount = conf.getInt("dfs.namenode.service.handler.count", 10);
            this.serviceRpcServer = new RPC.Builder(conf).setProtocol(ClientNamenodeProtocolPB.class).setInstance((Object)clientNNPbService).setBindAddress(bindHost).setPort(serviceRpcAddr.getPort()).setNumHandlers(serviceHandlerCount).setVerbose(false).setSecretManager((SecretManager)this.namesystem.getDelegationTokenSecretManager()).build();
            DFSUtil.addPBProtocol(conf, HAServiceProtocolPB.class, haPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, NamenodeProtocolPB.class, NNPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, DatanodeProtocolPB.class, dnProtoPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, RefreshAuthorizationPolicyProtocolPB.class, refreshAuthService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, RefreshUserMappingsProtocolPB.class, refreshUserMappingService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, RefreshCallQueueProtocolPB.class, refreshCallQueueService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, GenericRefreshProtocolPB.class, genericRefreshService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, GetUserMappingsProtocolPB.class, getUserMappingService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, TraceAdminProtocolPB.class, traceAdminService, this.serviceRpcServer);
            listenAddr = this.serviceRpcServer.getListenerAddress();
            this.serviceRPCAddress = new InetSocketAddress(serviceRpcAddr.getHostName(), listenAddr.getPort());
            nn.setRpcServiceServerAddress(conf, this.serviceRPCAddress);
        } else {
            this.serviceRpcServer = null;
            this.serviceRPCAddress = null;
        }
        InetSocketAddress rpcAddr = nn.getRpcServerAddress(conf);
        String bindHost = nn.getRpcServerBindHost(conf);
        if (bindHost == null) {
            bindHost = rpcAddr.getHostName();
        }
        LOG.info((Object)("RPC server is binding to " + bindHost + ":" + rpcAddr.getPort()));
        this.clientRpcServer = new RPC.Builder(conf).setProtocol(ClientNamenodeProtocolPB.class).setInstance((Object)clientNNPbService).setBindAddress(bindHost).setPort(rpcAddr.getPort()).setNumHandlers(handlerCount).setVerbose(false).setSecretManager((SecretManager)this.namesystem.getDelegationTokenSecretManager()).build();
        DFSUtil.addPBProtocol(conf, HAServiceProtocolPB.class, haPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, NamenodeProtocolPB.class, NNPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, DatanodeProtocolPB.class, dnProtoPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, RefreshAuthorizationPolicyProtocolPB.class, refreshAuthService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, RefreshUserMappingsProtocolPB.class, refreshUserMappingService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, RefreshCallQueueProtocolPB.class, refreshCallQueueService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, GenericRefreshProtocolPB.class, genericRefreshService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, GetUserMappingsProtocolPB.class, getUserMappingService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, TraceAdminProtocolPB.class, traceAdminService, this.clientRpcServer);
        this.serviceAuthEnabled = conf.getBoolean("hadoop.security.authorization", false);
        if (this.serviceAuthEnabled) {
            this.clientRpcServer.refreshServiceAcl(conf, (PolicyProvider)new HDFSPolicyProvider());
            if (this.serviceRpcServer != null) {
                this.serviceRpcServer.refreshServiceAcl(conf, (PolicyProvider)new HDFSPolicyProvider());
            }
        }
        listenAddr = this.clientRpcServer.getListenerAddress();
        this.clientRpcAddress = new InetSocketAddress(rpcAddr.getHostName(), listenAddr.getPort());
        nn.setRpcServerAddress(conf, this.clientRpcAddress);
        this.minimumDataNodeVersion = conf.get("dfs.namenode.min.supported.datanode.version", "2.1.0-beta");
        this.clientRpcServer.addTerseExceptions(new Class[]{SafeModeException.class, FileNotFoundException.class, HadoopIllegalArgumentException.class, FileAlreadyExistsException.class, InvalidPathException.class, ParentNotDirectoryException.class, UnresolvedLinkException.class, AlreadyBeingCreatedException.class, QuotaExceededException.class, RecoveryInProgressException.class, AccessControlException.class, SecretManager.InvalidToken.class, LeaseExpiredException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, AclException.class, FSLimitException.PathComponentTooLongException.class, FSLimitException.MaxDirectoryItemsExceededException.class, UnresolvedPathException.class});
    }

    @VisibleForTesting
    RPC.Server getClientRpcServer() {
        return this.clientRpcServer;
    }

    @VisibleForTesting
    RPC.Server getServiceRpcServer() {
        return this.serviceRpcServer;
    }

    void start() {
        this.clientRpcServer.start();
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.start();
        }
    }

    void join() throws InterruptedException {
        this.clientRpcServer.join();
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.join();
        }
    }

    void stop() {
        if (this.clientRpcServer != null) {
            this.clientRpcServer.stop();
        }
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.stop();
        }
    }

    InetSocketAddress getServiceRpcAddress() {
        return this.serviceRPCAddress;
    }

    InetSocketAddress getRpcAddress() {
        return this.clientRpcAddress;
    }

    private static UserGroupInformation getRemoteUser() throws IOException {
        return NameNode.getRemoteUser();
    }

    @Override
    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size) throws IOException {
        if (size <= 0L) {
            throw new IllegalArgumentException("Unexpected not positive size: " + size);
        }
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getBlockManager().getBlocks(datanode, size);
    }

    @Override
    public ExportedBlockKeys getBlockKeys() throws IOException {
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getBlockManager().getBlockKeys();
    }

    @Override
    public void errorReport(NamenodeRegistration registration, int errorCode, String msg) throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.namesystem.checkSuperuserPrivilege();
        this.verifyRequest(registration);
        LOG.info((Object)("Error report from " + registration + ": " + msg));
        if (errorCode == 1) {
            this.namesystem.releaseBackupNode(registration);
        }
    }

    @Override
    public NamenodeRegistration registerSubordinateNamenode(NamenodeRegistration registration) throws IOException {
        this.namesystem.checkSuperuserPrivilege();
        this.verifyLayoutVersion(registration.getVersion());
        NamenodeRegistration myRegistration = this.nn.setRegistration();
        this.namesystem.registerBackupNode(registration, myRegistration);
        return myRegistration;
    }

    @Override
    public NamenodeCommand startCheckpoint(NamenodeRegistration registration) throws IOException {
        this.namesystem.checkSuperuserPrivilege();
        this.verifyRequest(registration);
        if (!this.nn.isRole(HdfsServerConstants.NamenodeRole.NAMENODE)) {
            throw new IOException("Only an ACTIVE node can invoke startCheckpoint.");
        }
        return this.namesystem.startCheckpoint(registration, this.nn.setRegistration());
    }

    @Override
    public void endCheckpoint(NamenodeRegistration registration, CheckpointSignature sig) throws IOException {
        this.namesystem.checkSuperuserPrivilege();
        this.namesystem.endCheckpoint(registration, sig);
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        return this.namesystem.getDelegationToken(renewer);
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        return this.namesystem.renewDelegationToken(token);
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.namesystem.cancelDelegationToken(token);
    }

    @Override
    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
        this.metrics.incrGetBlockLocations();
        return this.namesystem.getBlockLocations(NameNodeRpcServer.getClientMachine(), src, offset, length);
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        return this.namesystem.getServerDefaults();
    }

    @Override
    public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize, CryptoProtocolVersion[] supportedVersions) throws IOException {
        String clientMachine = NameNodeRpcServer.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.create: file " + src + " for " + clientName + " at " + clientMachine));
        }
        if (!this.checkPathLength(src)) {
            throw new IOException("create: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        HdfsFileStatus fileStatus = this.namesystem.startFile(src, new PermissionStatus(NameNodeRpcServer.getRemoteUser().getShortUserName(), null, masked), clientName, clientMachine, flag.get(), createParent, replication, blockSize, supportedVersions);
        this.metrics.incrFilesCreated();
        this.metrics.incrCreateFileOps();
        return fileStatus;
    }

    @Override
    public LocatedBlock append(String src, String clientName) throws IOException {
        String clientMachine = NameNodeRpcServer.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.append: file " + src + " for " + clientName + " at " + clientMachine));
        }
        LocatedBlock info = this.namesystem.appendFile(src, clientName, clientMachine);
        this.metrics.incrFilesAppended();
        return info;
    }

    @Override
    public boolean recoverLease(String src, String clientName) throws IOException {
        String clientMachine = NameNodeRpcServer.getClientMachine();
        return this.namesystem.recoverLease(src, clientName, clientMachine);
    }

    @Override
    public boolean setReplication(String src, short replication) throws IOException {
        return this.namesystem.setReplication(src, replication);
    }

    @Override
    public void setStoragePolicy(String src, String policyName) throws IOException {
        this.namesystem.setStoragePolicy(src, policyName);
    }

    @Override
    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        return this.namesystem.getStoragePolicies();
    }

    @Override
    public void setPermission(String src, FsPermission permissions) throws IOException {
        this.namesystem.setPermission(src, permissions);
    }

    @Override
    public void setOwner(String src, String username, String groupname) throws IOException {
        this.namesystem.setOwner(src, username, groupname);
    }

    @Override
    public LocatedBlock addBlock(String src, String clientName, ExtendedBlock previous, DatanodeInfo[] excludedNodes, long fileId, String[] favoredNodes) throws IOException {
        List<String> favoredNodesList;
        LocatedBlock locatedBlock;
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*BLOCK* NameNode.addBlock: file " + src + " fileId=" + fileId + " for " + clientName));
        }
        HashSet<Node> excludedNodesSet = null;
        if (excludedNodes != null) {
            excludedNodesSet = new HashSet<Node>(excludedNodes.length);
            for (DatanodeInfo node : excludedNodes) {
                excludedNodesSet.add(node);
            }
        }
        if ((locatedBlock = this.namesystem.getAdditionalBlock(src, fileId, clientName, previous, excludedNodesSet, favoredNodesList = favoredNodes == null ? null : Arrays.asList(favoredNodes))) != null) {
            this.metrics.incrAddBlockOps();
        }
        return locatedBlock;
    }

    @Override
    public LocatedBlock getAdditionalDatanode(String src, long fileId, ExtendedBlock blk, DatanodeInfo[] existings, String[] existingStorageIDs, DatanodeInfo[] excludes, int numAdditionalNodes, String clientName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getAdditionalDatanode: src=" + src + ", fileId=" + fileId + ", blk=" + blk + ", existings=" + Arrays.asList(existings) + ", excludes=" + Arrays.asList(excludes) + ", numAdditionalNodes=" + numAdditionalNodes + ", clientName=" + clientName));
        }
        this.metrics.incrGetAdditionalDatanodeOps();
        HashSet<Node> excludeSet = null;
        if (excludes != null) {
            excludeSet = new HashSet<Node>(excludes.length);
            for (DatanodeInfo node : excludes) {
                excludeSet.add(node);
            }
        }
        return this.namesystem.getAdditionalDatanode(src, fileId, blk, existings, existingStorageIDs, excludeSet, numAdditionalNodes, clientName);
    }

    @Override
    public void abandonBlock(ExtendedBlock b, long fileId, String src, String holder) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*BLOCK* NameNode.abandonBlock: " + b + " of file " + src));
        }
        if (!this.namesystem.abandonBlock(b, fileId, src, holder)) {
            throw new IOException("Cannot abandon block during write to " + src);
        }
    }

    @Override
    public boolean complete(String src, String clientName, ExtendedBlock last, long fileId) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.complete: " + src + " fileId=" + fileId + " for " + clientName));
        }
        return this.namesystem.completeFile(src, clientName, last, fileId);
    }

    @Override
    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.namesystem.reportBadBlocks(blocks);
    }

    @Override
    public LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        return this.namesystem.updateBlockForPipeline(block, clientName);
    }

    @Override
    public void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] newStorageIDs) throws IOException {
        this.namesystem.updatePipeline(clientName, oldBlock, newBlock, newNodes, newStorageIDs);
    }

    @Override
    public void commitBlockSynchronization(ExtendedBlock block, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets, String[] newtargetstorages) throws IOException {
        this.namesystem.commitBlockSynchronization(block, newgenerationstamp, newlength, closeFile, deleteblock, newtargets, newtargetstorages);
    }

    @Override
    public long getPreferredBlockSize(String filename) throws IOException {
        return this.namesystem.getPreferredBlockSize(filename);
    }

    @Override
    @Deprecated
    public boolean rename(String src, String dst) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.rename: " + src + " to " + dst));
        }
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        boolean ret = this.namesystem.renameTo(src, dst);
        if (ret) {
            this.metrics.incrFilesRenamed();
        }
        return ret;
    }

    @Override
    public void concat(String trg, String[] src) throws IOException {
        this.namesystem.concat(trg, src);
    }

    @Override
    public void rename2(String src, String dst, Options.Rename ... options) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.rename: " + src + " to " + dst));
        }
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        this.namesystem.renameTo(src, dst, options);
        this.metrics.incrFilesRenamed();
    }

    @Override
    public boolean delete(String src, boolean recursive) throws IOException {
        boolean ret;
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* Namenode.delete: src=" + src + ", recursive=" + recursive));
        }
        if (ret = this.namesystem.delete(src, recursive)) {
            this.metrics.incrDeleteFileOps();
        }
        return ret;
    }

    private boolean checkPathLength(String src) {
        Path srcPath = new Path(src);
        return src.length() <= 8000 && srcPath.depth() <= 1000;
    }

    @Override
    public boolean mkdirs(String src, FsPermission masked, boolean createParent) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.mkdirs: " + src));
        }
        if (!this.checkPathLength(src)) {
            throw new IOException("mkdirs: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        return this.namesystem.mkdirs(src, new PermissionStatus(NameNodeRpcServer.getRemoteUser().getShortUserName(), null, masked), createParent);
    }

    @Override
    public void renewLease(String clientName) throws IOException {
        this.namesystem.renewLease(clientName);
    }

    @Override
    public DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws IOException {
        DirectoryListing files = this.namesystem.getListing(src, startAfter, needLocation);
        if (files != null) {
            this.metrics.incrGetListingOps();
            this.metrics.incrFilesInGetListingOps(files.getPartialListing().length);
        }
        return files;
    }

    @Override
    public HdfsFileStatus getFileInfo(String src) throws IOException {
        this.metrics.incrFileInfoOps();
        return this.namesystem.getFileInfo(src, true);
    }

    @Override
    public boolean isFileClosed(String src) throws IOException {
        return this.namesystem.isFileClosed(src);
    }

    @Override
    public HdfsFileStatus getFileLinkInfo(String src) throws IOException {
        this.metrics.incrFileInfoOps();
        return this.namesystem.getFileInfo(src, false);
    }

    @Override
    public long[] getStats() throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        return this.namesystem.getStats();
    }

    @Override
    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        DatanodeInfo[] results = this.namesystem.datanodeReport(type);
        if (results == null) {
            throw new IOException("Failed to get datanode report for " + (Object)((Object)type) + " datanodes.");
        }
        return results;
    }

    @Override
    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws IOException {
        DatanodeStorageReport[] reports = this.namesystem.getDatanodeStorageReport(type);
        if (reports == null) {
            throw new IOException("Failed to get datanode storage report for " + (Object)((Object)type) + " datanodes.");
        }
        return reports;
    }

    @Override
    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        NameNode.OperationCategory opCategory = NameNode.OperationCategory.UNCHECKED;
        if (isChecked) {
            opCategory = action == HdfsConstants.SafeModeAction.SAFEMODE_GET ? NameNode.OperationCategory.READ : NameNode.OperationCategory.WRITE;
        }
        this.namesystem.checkOperation(opCategory);
        return this.namesystem.setSafeMode(action);
    }

    @Override
    public boolean restoreFailedStorage(String arg) throws IOException {
        return this.namesystem.restoreFailedStorage(arg);
    }

    @Override
    public void saveNamespace() throws IOException {
        this.namesystem.saveNamespace();
    }

    @Override
    public long rollEdits() throws AccessControlException, IOException {
        CheckpointSignature sig = this.namesystem.rollEditLog();
        return sig.getCurSegmentTxId();
    }

    @Override
    public void refreshNodes() throws IOException {
        this.namesystem.refreshNodes();
    }

    @Override
    public long getTransactionID() throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getFSImage().getLastAppliedOrWrittenTxId();
    }

    @Override
    public long getMostRecentCheckpointTxId() throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getFSImage().getMostRecentCheckpointTxId();
    }

    @Override
    public CheckpointSignature rollEditLog() throws IOException {
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.rollEditLog();
    }

    @Override
    public RemoteEditLogManifest getEditLogManifest(long sinceTxId) throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getEditLog().getEditLogManifest(sinceTxId);
    }

    @Override
    public void finalizeUpgrade() throws IOException {
        this.namesystem.finalizeUpgrade();
    }

    @Override
    public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        LOG.info((Object)("rollingUpgrade " + (Object)((Object)action)));
        switch (action) {
            case QUERY: {
                return this.namesystem.queryRollingUpgrade();
            }
            case PREPARE: {
                return this.namesystem.startRollingUpgrade();
            }
            case FINALIZE: {
                this.namesystem.finalizeRollingUpgrade();
                return null;
            }
        }
        throw new UnsupportedActionException((Object)((Object)action) + " is not yet supported.");
    }

    @Override
    public void metaSave(String filename) throws IOException {
        this.namesystem.metaSave(filename);
    }

    @Override
    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        String[] cookieTab = new String[]{cookie};
        Collection<FSNamesystem.CorruptFileBlockInfo> fbs = this.namesystem.listCorruptFileBlocks(path, cookieTab);
        String[] files = new String[fbs.size()];
        int i = 0;
        for (FSNamesystem.CorruptFileBlockInfo fb : fbs) {
            files[i++] = fb.path;
        }
        return new CorruptFileBlocks(files, cookieTab[0]);
    }

    @Override
    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.namesystem.setBalancerBandwidth(bandwidth);
    }

    @Override
    public ContentSummary getContentSummary(String path) throws IOException {
        return this.namesystem.getContentSummary(path);
    }

    @Override
    public void setQuota(String path, long namespaceQuota, long diskspaceQuota) throws IOException {
        this.namesystem.setQuota(path, namespaceQuota, diskspaceQuota);
    }

    @Override
    public void fsync(String src, long fileId, String clientName, long lastBlockLength) throws IOException {
        this.namesystem.fsync(src, fileId, clientName, lastBlockLength);
    }

    @Override
    public void setTimes(String src, long mtime, long atime) throws IOException {
        this.namesystem.setTimes(src, mtime, atime);
    }

    @Override
    public void createSymlink(String target, String link, FsPermission dirPerms, boolean createParent) throws IOException {
        this.metrics.incrCreateSymlinkOps();
        if (!this.checkPathLength(link)) {
            throw new IOException("Symlink path exceeds 8000 character limit");
        }
        if ("".equals(target)) {
            throw new IOException("Invalid symlink target");
        }
        UserGroupInformation ugi = NameNodeRpcServer.getRemoteUser();
        this.namesystem.createSymlink(target, link, new PermissionStatus(ugi.getShortUserName(), null, dirPerms), createParent);
    }

    @Override
    public String getLinkTarget(String path) throws IOException {
        this.metrics.incrGetLinkTargetOps();
        HdfsFileStatus stat = null;
        try {
            stat = this.namesystem.getFileInfo(path, false);
        }
        catch (UnresolvedPathException e) {
            return e.getResolvedPath().toString();
        }
        catch (UnresolvedLinkException e) {
            throw new AssertionError((Object)"UnresolvedLinkException thrown");
        }
        if (stat == null) {
            throw new FileNotFoundException("File does not exist: " + path);
        }
        if (!stat.isSymlink()) {
            throw new IOException("Path " + path + " is not a symbolic link");
        }
        return stat.getSymlink();
    }

    @Override
    public DatanodeRegistration registerDatanode(DatanodeRegistration nodeReg) throws IOException {
        this.verifySoftwareVersion(nodeReg);
        this.namesystem.registerDatanode(nodeReg);
        return nodeReg;
    }

    @Override
    public HeartbeatResponse sendHeartbeat(DatanodeRegistration nodeReg, StorageReport[] report, long dnCacheCapacity, long dnCacheUsed, int xmitsInProgress, int xceiverCount, int failedVolumes) throws IOException {
        this.verifyRequest(nodeReg);
        return this.namesystem.handleHeartbeat(nodeReg, report, dnCacheCapacity, dnCacheUsed, xceiverCount, xmitsInProgress, failedVolumes);
    }

    @Override
    public DatanodeCommand blockReport(DatanodeRegistration nodeReg, String poolId, StorageBlockReport[] reports) throws IOException {
        this.verifyRequest(nodeReg);
        if (blockStateChangeLog.isDebugEnabled()) {
            blockStateChangeLog.debug((Object)("*BLOCK* NameNode.blockReport: from " + nodeReg + ", reports.length=" + reports.length));
        }
        BlockManager bm = this.namesystem.getBlockManager();
        boolean noStaleStorages = false;
        for (StorageBlockReport r : reports) {
            BlockListAsLongs blocks = new BlockListAsLongs(r.getBlocks());
            noStaleStorages = bm.processReport(nodeReg, r.getStorage(), blocks);
            this.metrics.incrStorageBlockReportOps();
        }
        if (this.nn.getFSImage().isUpgradeFinalized() && !this.namesystem.isRollingUpgrade() && !this.nn.isStandbyState() && noStaleStorages) {
            return new FinalizeCommand(poolId);
        }
        return null;
    }

    @Override
    public DatanodeCommand cacheReport(DatanodeRegistration nodeReg, String poolId, List<Long> blockIds) throws IOException {
        this.verifyRequest(nodeReg);
        if (blockStateChangeLog.isDebugEnabled()) {
            blockStateChangeLog.debug((Object)("*BLOCK* NameNode.cacheReport: from " + nodeReg + " " + blockIds.size() + " blocks"));
        }
        this.namesystem.getCacheManager().processCacheReport(nodeReg, blockIds);
        return null;
    }

    @Override
    public void blockReceivedAndDeleted(DatanodeRegistration nodeReg, String poolId, StorageReceivedDeletedBlocks[] receivedAndDeletedBlocks) throws IOException {
        this.verifyRequest(nodeReg);
        this.metrics.incrBlockReceivedAndDeletedOps();
        if (blockStateChangeLog.isDebugEnabled()) {
            blockStateChangeLog.debug((Object)("*BLOCK* NameNode.blockReceivedAndDeleted: from " + nodeReg + " " + receivedAndDeletedBlocks.length + " blocks."));
        }
        for (StorageReceivedDeletedBlocks r : receivedAndDeletedBlocks) {
            this.namesystem.processIncrementalBlockReport(nodeReg, r);
        }
    }

    @Override
    public void errorReport(DatanodeRegistration nodeReg, int errorCode, String msg) throws IOException {
        String dnName;
        String string = dnName = nodeReg == null ? "Unknown DataNode" : nodeReg.toString();
        if (errorCode == 0) {
            LOG.info((Object)("Error report from " + dnName + ": " + msg));
            return;
        }
        this.verifyRequest(nodeReg);
        if (errorCode == 1) {
            LOG.warn((Object)("Disk error on " + dnName + ": " + msg));
        } else if (errorCode == 3) {
            LOG.warn((Object)("Fatal disk error on " + dnName + ": " + msg));
            this.namesystem.getBlockManager().getDatanodeManager().removeDatanode(nodeReg);
        } else {
            LOG.info((Object)("Error report from " + dnName + ": " + msg));
        }
    }

    @Override
    public NamespaceInfo versionRequest() throws IOException {
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getNamespaceInfo();
    }

    private void verifyRequest(NodeRegistration nodeReg) throws IOException {
        String id = nodeReg.getRegistrationID();
        String expectedID = this.namesystem.getRegistrationID();
        if (!expectedID.equals(id)) {
            LOG.warn((Object)("Registration IDs mismatched: the " + nodeReg.getClass().getSimpleName() + " ID is " + id + " but the expected ID is " + expectedID));
            throw new UnregisteredNodeException(nodeReg);
        }
    }

    public void refreshServiceAcl() throws IOException {
        if (!this.serviceAuthEnabled) {
            throw new AuthorizationException("Service Level Authorization not enabled!");
        }
        this.clientRpcServer.refreshServiceAcl(new Configuration(), (PolicyProvider)new HDFSPolicyProvider());
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.refreshServiceAcl(new Configuration(), (PolicyProvider)new HDFSPolicyProvider());
        }
    }

    public void refreshUserToGroupsMappings() throws IOException {
        LOG.info((Object)("Refreshing all user-to-groups mappings. Requested by user: " + NameNodeRpcServer.getRemoteUser().getShortUserName()));
        Groups.getUserToGroupsMappingService().refresh();
    }

    public void refreshSuperUserGroupsConfiguration() {
        LOG.info((Object)"Refreshing SuperUser proxy group mapping list ");
        ProxyUsers.refreshSuperUserGroupsConfiguration();
    }

    public void refreshCallQueue() {
        LOG.info((Object)"Refreshing call queue.");
        Configuration conf = new Configuration();
        this.clientRpcServer.refreshCallQueue(conf);
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.refreshCallQueue(conf);
        }
    }

    public Collection<RefreshResponse> refresh(String identifier, String[] args) {
        return RefreshRegistry.defaultRegistry().dispatch(identifier, args);
    }

    public String[] getGroupsForUser(String user) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting groups for user " + user));
        }
        return UserGroupInformation.createRemoteUser((String)user).getGroupNames();
    }

    public synchronized void monitorHealth() throws HealthCheckFailedException, AccessControlException {
        this.nn.monitorHealth();
    }

    public synchronized void transitionToActive(HAServiceProtocol.StateChangeRequestInfo req) throws ServiceFailedException, AccessControlException {
        this.nn.checkHaStateChange(req);
        this.nn.transitionToActive();
    }

    public synchronized void transitionToStandby(HAServiceProtocol.StateChangeRequestInfo req) throws ServiceFailedException, AccessControlException {
        this.nn.checkHaStateChange(req);
        this.nn.transitionToStandby();
    }

    public synchronized HAServiceStatus getServiceStatus() throws AccessControlException, ServiceFailedException {
        return this.nn.getServiceStatus();
    }

    void verifyLayoutVersion(int version) throws IOException {
        if (version != HdfsConstants.NAMENODE_LAYOUT_VERSION) {
            throw new IncorrectVersionException(HdfsConstants.NAMENODE_LAYOUT_VERSION, version, "data node");
        }
    }

    private void verifySoftwareVersion(DatanodeRegistration dnReg) throws IncorrectVersionException {
        String dnVersion = dnReg.getSoftwareVersion();
        if (VersionUtil.compareVersions((String)dnVersion, (String)this.minimumDataNodeVersion) < 0) {
            IncorrectVersionException ive = new IncorrectVersionException(this.minimumDataNodeVersion, dnVersion, "DataNode", "NameNode");
            LOG.warn((Object)(ive.getMessage() + " DN: " + dnReg));
            throw ive;
        }
        String nnVersion = VersionInfo.getVersion();
        if (!dnVersion.equals(nnVersion)) {
            long dnCTime;
            String messagePrefix = "Reported DataNode version '" + dnVersion + "' of DN " + dnReg + " does not match NameNode version '" + nnVersion + "'";
            long nnCTime = this.nn.getFSImage().getStorage().getCTime();
            if (nnCTime != (dnCTime = dnReg.getStorageInfo().getCTime())) {
                IncorrectVersionException ive = new IncorrectVersionException(messagePrefix + " and CTime of DN ('" + dnCTime + "') does not match CTime of NN ('" + nnCTime + "')");
                LOG.warn((Object)ive);
                throw ive;
            }
            LOG.info((Object)(messagePrefix + ". Note: This is normal during a rolling upgrade."));
        }
    }

    private static String getClientMachine() {
        String clientMachine = NamenodeWebHdfsMethods.getRemoteAddress();
        if (clientMachine == null) {
            clientMachine = Server.getRemoteAddress();
        }
        if (clientMachine == null) {
            clientMachine = "";
        }
        return clientMachine;
    }

    @Override
    public DataEncryptionKey getDataEncryptionKey() throws IOException {
        return this.namesystem.getBlockManager().generateDataEncryptionKey();
    }

    @Override
    public String createSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        if (!this.checkPathLength(snapshotRoot)) {
            throw new IOException("createSnapshot: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        this.metrics.incrCreateSnapshotOps();
        return this.namesystem.createSnapshot(snapshotRoot, snapshotName);
    }

    @Override
    public void deleteSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        this.metrics.incrDeleteSnapshotOps();
        this.namesystem.deleteSnapshot(snapshotRoot, snapshotName);
    }

    @Override
    public void allowSnapshot(String snapshotRoot) throws IOException {
        this.metrics.incrAllowSnapshotOps();
        this.namesystem.allowSnapshot(snapshotRoot);
    }

    @Override
    public void disallowSnapshot(String snapshot) throws IOException {
        this.metrics.incrDisAllowSnapshotOps();
        this.namesystem.disallowSnapshot(snapshot);
    }

    @Override
    public void renameSnapshot(String snapshotRoot, String snapshotOldName, String snapshotNewName) throws IOException {
        if (snapshotNewName == null || snapshotNewName.isEmpty()) {
            throw new IOException("The new snapshot name is null or empty.");
        }
        this.metrics.incrRenameSnapshotOps();
        this.namesystem.renameSnapshot(snapshotRoot, snapshotOldName, snapshotNewName);
    }

    @Override
    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        SnapshottableDirectoryStatus[] status = this.namesystem.getSnapshottableDirListing();
        this.metrics.incrListSnapshottableDirOps();
        return status;
    }

    @Override
    public SnapshotDiffReport getSnapshotDiffReport(String snapshotRoot, String earlierSnapshotName, String laterSnapshotName) throws IOException {
        SnapshotDiffReport report = this.namesystem.getSnapshotDiffReport(snapshotRoot, earlierSnapshotName, laterSnapshotName);
        this.metrics.incrSnapshotDiffReportOps();
        return report;
    }

    @Override
    public long addCacheDirective(CacheDirectiveInfo path, EnumSet<CacheFlag> flags) throws IOException {
        return this.namesystem.addCacheDirective(path, flags);
    }

    @Override
    public void modifyCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        this.namesystem.modifyCacheDirective(directive, flags);
    }

    @Override
    public void removeCacheDirective(long id) throws IOException {
        this.namesystem.removeCacheDirective(id);
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> listCacheDirectives(long prevId, CacheDirectiveInfo filter) throws IOException {
        if (filter == null) {
            filter = new CacheDirectiveInfo.Builder().build();
        }
        return this.namesystem.listCacheDirectives(prevId, filter);
    }

    @Override
    public void addCachePool(CachePoolInfo info) throws IOException {
        this.namesystem.addCachePool(info);
    }

    @Override
    public void modifyCachePool(CachePoolInfo info) throws IOException {
        this.namesystem.modifyCachePool(info);
    }

    @Override
    public void removeCachePool(String cachePoolName) throws IOException {
        this.namesystem.removeCachePool(cachePoolName);
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> listCachePools(String prevKey) throws IOException {
        return this.namesystem.listCachePools(prevKey != null ? prevKey : "");
    }

    @Override
    public void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.namesystem.modifyAclEntries(src, aclSpec);
    }

    @Override
    public void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.namesystem.removeAclEntries(src, aclSpec);
    }

    @Override
    public void removeDefaultAcl(String src) throws IOException {
        this.namesystem.removeDefaultAcl(src);
    }

    @Override
    public void removeAcl(String src) throws IOException {
        this.namesystem.removeAcl(src);
    }

    @Override
    public void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        this.namesystem.setAcl(src, aclSpec);
    }

    @Override
    public AclStatus getAclStatus(String src) throws IOException {
        return this.namesystem.getAclStatus(src);
    }

    @Override
    public void createEncryptionZone(String src, String keyName) throws IOException {
        this.namesystem.createEncryptionZone(src, keyName);
    }

    @Override
    public EncryptionZone getEZForPath(String src) throws IOException {
        return this.namesystem.getEZForPath(src);
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<EncryptionZone> listEncryptionZones(long prevId) throws IOException {
        return this.namesystem.listEncryptionZones(prevId);
    }

    @Override
    public void setXAttr(String src, XAttr xAttr, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.namesystem.setXAttr(src, xAttr, flag);
    }

    @Override
    public List<XAttr> getXAttrs(String src, List<XAttr> xAttrs) throws IOException {
        return this.namesystem.getXAttrs(src, xAttrs);
    }

    @Override
    public List<XAttr> listXAttrs(String src) throws IOException {
        return this.namesystem.listXAttrs(src);
    }

    @Override
    public void removeXAttr(String src, XAttr xAttr) throws IOException {
        this.namesystem.removeXAttr(src, xAttr);
    }

    @Override
    public void checkAccess(String path, FsAction mode) throws IOException {
        this.namesystem.checkAccess(path, mode);
    }

    @Override
    public long getCurrentEditLogTxid() throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getEditLog().isOpenForWrite() ? this.namesystem.getEditLog().getLastWrittenTxId() : -1L;
    }

    private static FSEditLogOp readOp(EditLogInputStream elis) throws IOException {
        try {
            return elis.readOp();
        }
        catch (FileNotFoundException e) {
            LOG.debug((Object)"Tried to read from deleted or moved edit log segment", (Throwable)e);
            return null;
        }
        catch (TransferFsImage.HttpGetFailedException e) {
            LOG.debug((Object)"Tried to read from deleted edit log segment", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventsList getEditsFromTxid(long txid) throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        this.namesystem.checkSuperuserPrivilege();
        int maxEventsPerRPC = this.nn.conf.getInt("dfs.namenode.inotify.max.events.per.rpc", 1000);
        FSEditLog log = this.namesystem.getFSImage().getEditLog();
        long syncTxid = log.getSyncTxId();
        boolean readInProgress = syncTxid > 0L;
        ArrayList events = Lists.newArrayList();
        long maxSeenTxid = -1L;
        long firstSeenTxid = -1L;
        if (syncTxid > 0L && txid > syncTxid) {
            return new EventsList(events, firstSeenTxid, maxSeenTxid, syncTxid);
        }
        Collection<EditLogInputStream> streams = null;
        try {
            streams = log.selectInputStreams(txid, 0L, null, readInProgress);
        }
        catch (IllegalStateException e) {
            LOG.info((Object)"NN is transitioning from active to standby and FSEditLog is closed -- could not read edits");
            return new EventsList(events, firstSeenTxid, maxSeenTxid, syncTxid);
        }
        boolean breakOuter = false;
        for (EditLogInputStream elis : streams) {
            try {
                FSEditLogOp op = null;
                while ((op = NameNodeRpcServer.readOp(elis)) != null) {
                    if (syncTxid > 0L && op.getTransactionId() > syncTxid) {
                        breakOuter = true;
                    } else {
                        Event[] eventsFromOp = InotifyFSEditLogOpTranslator.translate(op);
                        if (eventsFromOp != null) {
                            events.addAll(Arrays.asList(eventsFromOp));
                        }
                        if (op.getTransactionId() > maxSeenTxid) {
                            maxSeenTxid = op.getTransactionId();
                        }
                        if (firstSeenTxid == -1L) {
                            firstSeenTxid = op.getTransactionId();
                        }
                        if (events.size() < maxEventsPerRPC && (syncTxid <= 0L || op.getTransactionId() != syncTxid)) continue;
                        breakOuter = true;
                    }
                    break;
                }
            }
            finally {
                elis.close();
            }
            if (!breakOuter) continue;
            break;
        }
        return new EventsList(events, firstSeenTxid, maxSeenTxid, syncTxid);
    }

    public SpanReceiverInfo[] listSpanReceivers() throws IOException {
        this.namesystem.checkSuperuserPrivilege();
        return this.nn.spanReceiverHost.listSpanReceivers();
    }

    public long addSpanReceiver(SpanReceiverInfo info) throws IOException {
        this.namesystem.checkSuperuserPrivilege();
        return this.nn.spanReceiverHost.addSpanReceiver(info);
    }

    public void removeSpanReceiver(long id) throws IOException {
        this.namesystem.checkSuperuserPrivilege();
        this.nn.spanReceiverHost.removeSpanReceiver(id);
    }
}

