/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Locale;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class GrandSumEvaluator
extends RecursiveObjectEvaluator
implements OneValueWorker {
    protected static final long serialVersionUID = 1L;

    public GrandSumEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (1 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 1 value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value) throws IOException {
        if (null == value) {
            return null;
        }
        if (value instanceof Matrix) {
            Matrix matrix = (Matrix)value;
            double[][] data = matrix.getData();
            double grandSum = 0.0;
            double[][] dArray = data;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                double[] row;
                for (double d : row = dArray[i]) {
                    grandSum += d;
                }
            }
            return grandSum;
        }
        throw new IOException("Grand sum function only operates on a matrix");
    }
}

