/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator;

import javax.jws.Oneway;
import javax.jws.WebResult;
import javax.jws.soap.SOAPBinding;
import org.apache.cxf.tools.common.model.Annotator;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JAnnotationElement;
import org.apache.cxf.tools.common.model.JavaAnnotatable;
import org.apache.cxf.tools.common.model.JavaMethod;

public class WebResultAnnotator
implements Annotator {
    public void annotate(JavaAnnotatable ja) {
        if (!(ja instanceof JavaMethod)) {
            throw new RuntimeException("WebResult can only annotate JavaMethod");
        }
        JavaMethod method = (JavaMethod)ja;
        if (method.isOneWay()) {
            JAnnotation oneWayAnnotation = new JAnnotation(Oneway.class);
            method.addAnnotation("Oneway", oneWayAnnotation);
            return;
        }
        if ("void".equals(method.getReturn().getType())) {
            return;
        }
        JAnnotation resultAnnotation = new JAnnotation(WebResult.class);
        String targetNamespace = method.getReturn().getTargetNamespace();
        String name = "return";
        if (method.getSoapStyle() == SOAPBinding.Style.DOCUMENT && !method.isWrapperStyle()) {
            name = method.getName() + "Response";
        }
        if (method.getSoapStyle() == SOAPBinding.Style.RPC) {
            name = method.getReturn().getName();
            targetNamespace = method.getInterface().getNamespace();
        }
        if (method.getSoapStyle() == SOAPBinding.Style.DOCUMENT) {
            if (method.getReturn().getQName() != null) {
                name = method.getReturn().getQName().getLocalPart();
            }
            targetNamespace = method.getReturn().getTargetNamespace();
        }
        resultAnnotation.addElement(new JAnnotationElement("name", (Object)name));
        if (null != targetNamespace) {
            resultAnnotation.addElement(new JAnnotationElement("targetNamespace", (Object)targetNamespace));
        }
        if (method.getSoapStyle() == SOAPBinding.Style.RPC || method.getSoapStyle() == SOAPBinding.Style.DOCUMENT && !method.isWrapperStyle()) {
            resultAnnotation.addElement(new JAnnotationElement("partName", (Object)method.getReturn().getName()));
        }
        method.addAnnotation("WebResult", resultAnnotation);
        method.getInterface().addImport("javax.jws.WebResult");
    }
}

