/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit.format;

import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.measure.converter.AddConverter;
import javax.measure.converter.ExpConverter;
import javax.measure.converter.LogConverter;
import javax.measure.converter.MultiplyConverter;
import javax.measure.converter.RationalConverter;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.AlternateUnit;
import javax.measure.unit.AnnotatedUnit;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.ProductUnit;
import javax.measure.unit.SI;
import javax.measure.unit.TransformedUnit;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import javax.measure.unit.format.ParseException;
import javax.measure.unit.format.Prefix;
import javax.measure.unit.format.SymbolMap;
import javax.measure.unit.format.TokenMgrError;
import javax.measure.unit.format.UnitParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFormat
extends UnitFormat {
    private static final long serialVersionUID = -2046025264383639924L;
    private static LocalFormat DEFAULT_INSTANCE = new LocalFormat(new SymbolMap(ResourceBundle.getBundle(LocalFormat.class.getName())));
    private static final char MIDDLE_DOT = '\u00b7';
    private static final int ADDITION_PRECEDENCE = 0;
    private static final int PRODUCT_PRECEDENCE = 2;
    private static final int EXPONENT_PRECEDENCE = 4;
    private static final int NOOP_PRECEDENCE = Integer.MAX_VALUE;
    private transient SymbolMap symbolMap;

    public static LocalFormat getInstance() {
        return DEFAULT_INSTANCE;
    }

    public static LocalFormat getInstance(Locale locale) {
        return new LocalFormat(new SymbolMap(ResourceBundle.getBundle(LocalFormat.class.getName(), locale)));
    }

    public static LocalFormat getInstance(SymbolMap symbols) {
        return new LocalFormat(symbols);
    }

    private LocalFormat(SymbolMap symbols) {
        this.symbolMap = symbols;
    }

    public SymbolMap getSymbols() {
        return this.symbolMap;
    }

    @Override
    public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
        this.formatInternal(unit, appendable);
        return appendable;
    }

    @Override
    public Unit<?> parse(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException {
        int start = cursor.getIndex();
        int end = csq.length();
        if (end <= start) {
            return Unit.ONE;
        }
        String source = ((Object)csq.subSequence(start, end)).toString().trim();
        if (source.length() == 0) {
            return Unit.ONE;
        }
        try {
            UnitParser parser = new UnitParser(this.symbolMap, new StringReader(source));
            Unit result = parser.parseUnit();
            cursor.setIndex(end);
            return result;
        }
        catch (ParseException e) {
            if (e.currentToken != null) {
                cursor.setErrorIndex(start + e.currentToken.endColumn);
            } else {
                cursor.setErrorIndex(start);
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (TokenMgrError e) {
            cursor.setErrorIndex(start);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private int formatInternal(Unit<?> unit, Appendable buffer) throws IOException {
        String symbol;
        if (unit instanceof AnnotatedUnit) {
            unit = ((AnnotatedUnit)unit).getRealUnit();
        }
        if ((symbol = this.symbolMap.getSymbol(unit)) != null) {
            buffer.append(symbol);
            return Integer.MAX_VALUE;
        }
        if (unit instanceof ProductUnit) {
            int pow;
            int i;
            ProductUnit productUnit = (ProductUnit)unit;
            int negativeExponentCount = 0;
            boolean start = true;
            for (i = 0; i < productUnit.getUnitCount(); ++i) {
                pow = productUnit.getUnitPow(i);
                if (pow >= 0) {
                    this.formatExponent(productUnit.getUnit(i), pow, productUnit.getUnitRoot(i), !start, buffer);
                    start = false;
                    continue;
                }
                ++negativeExponentCount;
            }
            if (negativeExponentCount > 0) {
                if (start) {
                    buffer.append('1');
                }
                buffer.append('/');
                if (negativeExponentCount > 1) {
                    buffer.append('(');
                }
                start = true;
                for (i = 0; i < productUnit.getUnitCount(); ++i) {
                    pow = productUnit.getUnitPow(i);
                    if (pow >= 0) continue;
                    this.formatExponent(productUnit.getUnit(i), -pow, productUnit.getUnitRoot(i), !start, buffer);
                    start = false;
                }
                if (negativeExponentCount > 1) {
                    buffer.append(')');
                }
            }
            return 2;
        }
        if (unit instanceof TransformedUnit || unit.equals(SI.KILOGRAM)) {
            UnitConverter converter = null;
            boolean printSeparator = false;
            StringBuffer temp = new StringBuffer();
            int unitPrecedence = Integer.MAX_VALUE;
            if (unit.equals(SI.KILOGRAM)) {
                converter = Prefix.KILO.getConverter();
                unitPrecedence = this.formatInternal(SI.GRAM, temp);
                printSeparator = true;
            } else {
                TransformedUnit transformedUnit = (TransformedUnit)unit;
                Unit<Object> parentUnits = transformedUnit.getParentUnit();
                converter = transformedUnit.toParentUnit();
                if (parentUnits.equals(SI.KILOGRAM)) {
                    parentUnits = SI.GRAM;
                    converter = converter.concatenate(Prefix.KILO.getConverter());
                }
                unitPrecedence = this.formatInternal(parentUnits, temp);
                printSeparator = !parentUnits.equals(Unit.ONE);
            }
            int result = this.formatConverter(converter, printSeparator, unitPrecedence, temp);
            buffer.append(temp);
            return result;
        }
        if (unit instanceof AlternateUnit) {
            buffer.append(((AlternateUnit)unit).getSymbol());
            return Integer.MAX_VALUE;
        }
        if (unit instanceof BaseUnit) {
            buffer.append(((BaseUnit)unit).getSymbol());
            return Integer.MAX_VALUE;
        }
        throw new IllegalArgumentException("Cannot format the given Object as a Unit (unsupported unit type " + unit.getClass().getName() + ")");
    }

    private void formatExponent(Unit<?> unit, int pow, int root, boolean continued, Appendable buffer) throws IOException {
        StringBuffer temp;
        int unitPrecedence;
        if (continued) {
            buffer.append('\u00b7');
        }
        if ((unitPrecedence = this.formatInternal(unit, temp = new StringBuffer())) < 2) {
            temp.insert(0, '(');
            temp.append(')');
        }
        buffer.append(temp);
        if (root != 1 || pow != 1) {
            if (root == 1 && pow > 1) {
                String powStr = Integer.toString(pow);
                block12: for (int i = 0; i < powStr.length(); ++i) {
                    char c = powStr.charAt(i);
                    switch (c) {
                        case '0': {
                            buffer.append('\u2070');
                            continue block12;
                        }
                        case '1': {
                            buffer.append('\u00b9');
                            continue block12;
                        }
                        case '2': {
                            buffer.append('\u00b2');
                            continue block12;
                        }
                        case '3': {
                            buffer.append('\u00b3');
                            continue block12;
                        }
                        case '4': {
                            buffer.append('\u2074');
                            continue block12;
                        }
                        case '5': {
                            buffer.append('\u2075');
                            continue block12;
                        }
                        case '6': {
                            buffer.append('\u2076');
                            continue block12;
                        }
                        case '7': {
                            buffer.append('\u2077');
                            continue block12;
                        }
                        case '8': {
                            buffer.append('\u2078');
                            continue block12;
                        }
                        case '9': {
                            buffer.append('\u2079');
                        }
                    }
                }
            } else if (root == 1) {
                buffer.append("^");
                buffer.append(String.valueOf(pow));
            } else {
                buffer.append("^(");
                buffer.append(String.valueOf(pow));
                buffer.append('/');
                buffer.append(String.valueOf(root));
                buffer.append(')');
            }
        }
    }

    private int formatConverter(UnitConverter converter, boolean continued, int unitPrecedence, StringBuffer buffer) {
        Prefix prefix = this.symbolMap.getPrefix(converter);
        if (prefix != null && unitPrecedence == Integer.MAX_VALUE) {
            buffer.insert(0, this.symbolMap.getSymbol(prefix));
            return Integer.MAX_VALUE;
        }
        if (converter instanceof AddConverter) {
            double offset;
            if (unitPrecedence < 0) {
                buffer.insert(0, '(');
                buffer.append(')');
            }
            if ((offset = ((AddConverter)converter).getOffset()) < 0.0) {
                buffer.append("-");
                offset = -offset;
            } else if (continued) {
                buffer.append("+");
            }
            long lOffset = (long)offset;
            if ((double)lOffset == offset) {
                buffer.append(lOffset);
            } else {
                buffer.append(offset);
            }
            return 0;
        }
        if (converter instanceof LogConverter) {
            double base = ((LogConverter)converter).getBase();
            StringBuffer expr = new StringBuffer();
            if (base == Math.E) {
                expr.append("ln");
            } else {
                expr.append("log");
                if (base != 10.0) {
                    expr.append((int)base);
                }
            }
            expr.append("(");
            buffer.insert(0, expr);
            buffer.append(")");
            return 4;
        }
        if (converter instanceof ExpConverter) {
            if (unitPrecedence < 4) {
                buffer.insert(0, '(');
                buffer.append(')');
            }
            StringBuffer expr = new StringBuffer();
            double base = ((ExpConverter)converter).getBase();
            if (base == Math.E) {
                expr.append('e');
            } else {
                expr.append((int)base);
            }
            expr.append('^');
            buffer.insert(0, expr);
            return 4;
        }
        if (converter instanceof MultiplyConverter) {
            double factor;
            long lFactor;
            if (unitPrecedence < 2) {
                buffer.insert(0, '(');
                buffer.append(')');
            }
            if (continued) {
                buffer.append('\u00b7');
            }
            if ((double)(lFactor = (long)(factor = ((MultiplyConverter)converter).getFactor())) == factor) {
                buffer.append(lFactor);
            } else {
                buffer.append(factor);
            }
            return 2;
        }
        if (converter instanceof RationalConverter) {
            RationalConverter rationalConverter;
            if (unitPrecedence < 2) {
                buffer.insert(0, '(');
                buffer.append(')');
            }
            if (!(rationalConverter = (RationalConverter)converter).getDividend().equals(BigInteger.ONE)) {
                if (continued) {
                    buffer.append('\u00b7');
                }
                buffer.append(rationalConverter.getDividend());
            }
            if (!rationalConverter.getDivisor().equals(BigInteger.ONE)) {
                buffer.append('/');
                buffer.append(rationalConverter.getDivisor());
            }
            return 2;
        }
        throw new IllegalArgumentException("Unable to format the given UnitConverter: " + converter.getClass());
    }
}

