/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import org.bson.util.Assertions;

public class GroupCommand {
    private final String collectionName;
    private final DBObject keys;
    private final String keyf;
    private final DBObject condition;
    private final DBObject initial;
    private final String reduce;
    private final String finalize;

    public GroupCommand(DBCollection collection, DBObject keys, DBObject condition, DBObject initial, String reduce, String finalize) {
        Assertions.notNull("collection", collection);
        this.collectionName = collection.getName();
        this.keys = keys;
        this.condition = condition;
        this.initial = initial;
        this.reduce = reduce;
        this.finalize = finalize;
        this.keyf = null;
    }

    public GroupCommand(DBCollection collection, String keyf, DBObject condition, DBObject initial, String reduce, String finalize) {
        Assertions.notNull("collection", collection);
        this.collectionName = collection.getName();
        this.keyf = Assertions.notNull("keyf", keyf);
        this.condition = condition;
        this.initial = initial;
        this.reduce = reduce;
        this.finalize = finalize;
        this.keys = null;
    }

    public DBObject toDBObject() {
        BasicDBObject args = new BasicDBObject("ns", this.collectionName).append("cond", this.condition).append("$reduce", this.reduce).append("initial", this.initial);
        if (this.keys != null) {
            args.put("key", (Object)this.keys);
        }
        if (this.keyf != null) {
            args.put("$keyf", (Object)this.keyf);
        }
        if (this.finalize != null) {
            args.put("finalize", (Object)this.finalize);
        }
        return new BasicDBObject("group", args);
    }
}

