/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import java.io.File;
import java.io.IOException;
import org.apache.uima.UIMAException;
import org.apache.uima.fit.factory.FsIndexFactory;
import org.apache.uima.fit.factory.TypePrioritiesFactory;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.fit.internal.ResourceManagerFactory;
import org.apache.uima.fit.util.CasIOUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;

public final class JCasFactory {
    private JCasFactory() {
    }

    public static JCas createText(String aText) throws UIMAException {
        return JCasFactory.createText(aText, null);
    }

    public static JCas createText(String aText, String aLanguage) throws UIMAException {
        JCas jcas = JCasFactory.createJCas();
        if (aText != null) {
            jcas.setDocumentText(aText);
        }
        if (aLanguage != null) {
            jcas.setDocumentLanguage(aLanguage);
        }
        return jcas;
    }

    public static JCas createJCas() throws UIMAException {
        TypeSystemDescription tsd = TypeSystemDescriptionFactory.createTypeSystemDescription();
        TypePriorities tp = TypePrioritiesFactory.createTypePriorities();
        FsIndexCollection indexes = FsIndexFactory.createFsIndexCollection();
        ResourceManager resMgr = ResourceManagerFactory.newResourceManager();
        return CasCreationUtils.createCas((TypeSystemDescription)tsd, (TypePriorities)tp, (FsIndexDescription[])indexes.getFsIndexes(), null, (ResourceManager)resMgr).getJCas();
    }

    public static JCas createJCas(String ... typeSystemDescriptorNames) throws UIMAException {
        return CasCreationUtils.createCas((TypeSystemDescription)TypeSystemDescriptionFactory.createTypeSystemDescription(typeSystemDescriptorNames), null, null).getJCas();
    }

    public static JCas createJCasFromPath(String ... typeSystemDescriptorPaths) throws UIMAException {
        return JCasFactory.createJCas(TypeSystemDescriptionFactory.createTypeSystemDescriptionFromPath(typeSystemDescriptorPaths));
    }

    public static JCas createJCas(TypeSystemDescription typeSystemDescription) throws UIMAException {
        return CasCreationUtils.createCas((TypeSystemDescription)typeSystemDescription, null, null).getJCas();
    }

    public static JCas createJCas(String fileName, TypeSystemDescription typeSystemDescription) throws UIMAException, IOException {
        JCas jCas = JCasFactory.createJCas(typeSystemDescription);
        CasIOUtil.readJCas(jCas, new File(fileName));
        return jCas;
    }
}

