/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.graph.Traversal;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;

public class Node {
    private String id;
    private List<Metric> metrics;
    private Set<String> ancestors;

    public Node(String id, boolean track) {
        this.id = id;
        if (track) {
            this.ancestors = new TreeSet<String>();
        }
    }

    public void setMetrics(List<Metric> metrics) {
        this.metrics = metrics;
    }

    public void add(String ancestor, Tuple tuple) {
        if (this.ancestors != null) {
            this.ancestors.add(ancestor);
        }
        if (this.metrics != null) {
            for (Metric metric : this.metrics) {
                metric.update(tuple);
            }
        }
    }

    public Tuple toTuple(String collection, String field, int level, Traversal traversal) {
        Tuple tuple = new Tuple();
        tuple.put("node", this.id);
        tuple.put("collection", collection);
        tuple.put("field", field);
        tuple.put("level", level);
        boolean prependCollection = traversal.isMultiCollection();
        List<String> cols = traversal.getCollections();
        if (this.ancestors != null) {
            ArrayList<Object> l = new ArrayList<Object>();
            for (String ancestor : this.ancestors) {
                String[] ancestorParts = ancestor.split("\\^");
                if (prependCollection) {
                    int colIndex = Integer.parseInt(ancestorParts[0]);
                    l.add(cols.get(colIndex) + "/" + ancestorParts[1]);
                    continue;
                }
                l.add(ancestorParts[1]);
            }
            tuple.put("ancestors", l);
        }
        if (this.metrics != null) {
            for (Metric metric : this.metrics) {
                tuple.put(metric.getIdentifier(), metric.getValue());
            }
        }
        return tuple;
    }
}

