/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects.blob;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileCleaningTracker;
import org.nuxeo.client.objects.blob.AbstractBlob;

public class FileBlob
extends AbstractBlob {
    protected final File file;

    public FileBlob(File file) {
        this(file, file.getName());
    }

    public FileBlob(File file, String filename) {
        this(file, filename, "application/octet-stream");
    }

    public FileBlob(File file, String filename, String mediaType) {
        super(filename, mediaType);
        this.file = file;
    }

    @Override
    public int getLength() {
        long length = this.file.length();
        if (length > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)length;
    }

    @Override
    public InputStream getStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public void track() {
        if (this.file != null) {
            FileCleaningTracker fileCleaningTracker = new FileCleaningTracker();
            fileCleaningTracker.track(this.file, (Object)this);
        }
    }

    @JsonIgnore
    protected String formatLength(int len) {
        int k = len / 1024;
        if (k <= 0) {
            return len + " B";
        }
        if (k < 1024) {
            return k + " K";
        }
        return k / 1024 + " M";
    }

    public String toString() {
        return this.filename + " - " + this.mimeType + " - " + this.formatLength(this.getLength());
    }
}

