/**

  All content copyright (c) 2003-2007 Terracotta, Inc.,
  except as may otherwise be noted in a separate copyright notice.
  All rights reserved.

*/
package ${packageName}.demo;

import java.util.*;

public class Model {

   private int value;
   private Random random;
   private transient Observer observer;
   
   public Model() {
      random = new Random();
      value  = random.nextInt(1000);
   }
   
   public String toString() {
      return Integer.toString(value);
   }
   
   public void modify() {
      value = random.nextInt(1000);
      notifyObserver();
   }
   
   public void setObserver(Observer observer) {
      this.observer = observer;
   }
    
   private void notifyObserver() {
      observer.update(null, null);
   }
}