/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api;

import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import javax.tools.DocumentationTool;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.apache.maven.api.PathType;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;

@Experimental
public enum JavaPathType implements PathType
{
    CLASSES(StandardLocation.CLASS_PATH, "--class-path"),
    MODULES(StandardLocation.MODULE_PATH, "--module-path"),
    UPGRADE_MODULES(StandardLocation.UPGRADE_MODULE_PATH, "--upgrade-module-path"),
    PATCH_MODULE(StandardLocation.PATCH_MODULE_PATH, "--patch-module"),
    PROCESSOR_CLASSES(StandardLocation.ANNOTATION_PROCESSOR_PATH, "--processor-path"),
    PROCESSOR_MODULES(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH, "--processor-module-path"),
    AGENT(null, "-agentpath"),
    DOCLET(DocumentationTool.Location.DOCLET_PATH, "-doclet"),
    TAGLETS(DocumentationTool.Location.TAGLET_PATH, "-tagletpath");

    private final JavaFileManager.Location location;
    private final String option;

    @Nonnull
    public static Modular patchModule(@Nonnull String moduleName) {
        JavaPathType javaPathType = PATCH_MODULE;
        Objects.requireNonNull(javaPathType);
        return javaPathType.new Modular(moduleName);
    }

    private JavaPathType(JavaFileManager.Location location, String option) {
        this.location = location;
        this.option = option;
    }

    @Override
    public String id() {
        return this.name();
    }

    public Optional<JavaFileManager.Location> location() {
        return Optional.ofNullable(this.location);
    }

    public static Optional<JavaPathType> valueOf(JavaFileManager.Location location) {
        for (JavaPathType type : JavaPathType.values()) {
            if (!location.equals(type.location)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<String> option() {
        return Optional.ofNullable(this.option);
    }

    @Override
    @Nonnull
    public String[] option(Iterable<? extends Path> paths) {
        return this.format(null, paths);
    }

    final String[] format(String moduleName, Iterable<? extends Path> paths) {
        if (this.option == null) {
            throw new IllegalStateException("No option is associated to this path type.");
        }
        Object prefix = moduleName == null ? "" : moduleName + "=";
        StringJoiner joiner = new StringJoiner(File.pathSeparator, (CharSequence)prefix, "");
        joiner.setEmptyValue("");
        for (Path path : paths) {
            joiner.add(path.toString());
        }
        String value = joiner.toString();
        if (value.isEmpty()) {
            return new String[0];
        }
        return new String[]{this.option, value};
    }

    @Override
    public String toString() {
        return "PathType[" + this.id() + "]";
    }

    public final class Modular
    implements PathType {
        @Nonnull
        private final String moduleName;

        private Modular(String moduleName) {
            this.moduleName = Objects.requireNonNull(moduleName);
        }

        @Nonnull
        public JavaPathType rawType() {
            return JavaPathType.this;
        }

        @Override
        public String id() {
            return JavaPathType.this.name() + ":" + this.moduleName;
        }

        @Override
        @Nonnull
        public String name() {
            return JavaPathType.this.name();
        }

        @Nonnull
        public String moduleName() {
            return this.moduleName;
        }

        @Override
        @Nonnull
        public Optional<String> option() {
            return JavaPathType.this.option();
        }

        @Override
        @Nonnull
        public String[] option(Iterable<? extends Path> paths) {
            return JavaPathType.this.format(this.moduleName, paths);
        }

        @Override
        @Nonnull
        public String toString() {
            return "PathType[" + this.id() + "]";
        }
    }
}

