/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.Comparator;
import java.util.List;
import org.assertj.core.api.recursive.comparison.ComparisonDifference;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonDifferenceCalculator;

public class RecursiveComparator
implements Comparator<Object> {
    private final RecursiveComparisonConfiguration recursiveComparisonConfiguration;
    private final RecursiveComparisonDifferenceCalculator recursiveComparisonDifferenceCalculator;

    public RecursiveComparator(RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        this.recursiveComparisonConfiguration = recursiveComparisonConfiguration;
        this.recursiveComparisonDifferenceCalculator = new RecursiveComparisonDifferenceCalculator();
    }

    private List<ComparisonDifference> determineDifferencesWith(Object actual, Object expected) {
        return this.recursiveComparisonDifferenceCalculator.determineDifferences(actual, expected, this.recursiveComparisonConfiguration);
    }

    @Override
    public int compare(Object actual, Object other) {
        if (actual == other) {
            return 0;
        }
        if (actual != null && other != null) {
            return this.determineDifferencesWith(actual, other).size();
        }
        return -1;
    }

    public String getDescription() {
        return String.format("RecursiveComparator a comparator based on the recursive comparison with the following configuration:%n%s", this.recursiveComparisonConfiguration);
    }
}

