/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.OptionalDouble;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.error.OptionalDoubleShouldHaveValueCloseToOffset;
import org.assertj.core.error.OptionalDoubleShouldHaveValueCloseToPercentage;
import org.assertj.core.error.OptionalShouldBeEmpty;
import org.assertj.core.error.OptionalShouldBePresent;
import org.assertj.core.error.OptionalShouldContain;
import org.assertj.core.internal.Doubles;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractOptionalDoubleAssert<SELF extends AbstractOptionalDoubleAssert<SELF>>
extends AbstractAssert<SELF, OptionalDouble> {
    @VisibleForTesting
    Doubles doubles = Doubles.instance();

    protected AbstractOptionalDoubleAssert(OptionalDouble actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isPresent() {
        this.isNotNull();
        if (!((OptionalDouble)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldBePresent.shouldBePresent(this.actual));
        }
        return (SELF)((AbstractOptionalDoubleAssert)this.myself);
    }

    public SELF isNotPresent() {
        return this.isEmpty();
    }

    public SELF isEmpty() {
        this.isNotNull();
        if (((OptionalDouble)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldBeEmpty.shouldBeEmpty((OptionalDouble)this.actual));
        }
        return (SELF)((AbstractOptionalDoubleAssert)this.myself);
    }

    public SELF isNotEmpty() {
        return this.isPresent();
    }

    public SELF hasValue(double expectedValue) {
        this.isNotNull();
        if (!((OptionalDouble)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldContain.shouldContain(expectedValue));
        }
        if (Double.compare(expectedValue, ((OptionalDouble)this.actual).getAsDouble()) != 0) {
            throw Failures.instance().failure(this.info, OptionalShouldContain.shouldContain((OptionalDouble)this.actual, expectedValue), ((OptionalDouble)this.actual).getAsDouble(), expectedValue);
        }
        return (SELF)((AbstractOptionalDoubleAssert)this.myself);
    }

    public SELF hasValueCloseTo(Double expectedValue, Offset<Double> offset) {
        this.isNotNull();
        if (!((OptionalDouble)this.actual).isPresent()) {
            this.throwAssertionError(OptionalDoubleShouldHaveValueCloseToOffset.shouldHaveValueCloseToOffset(expectedValue));
        }
        try {
            this.doubles.assertIsCloseTo(this.info, ((OptionalDouble)this.actual).getAsDouble(), expectedValue, offset);
        }
        catch (AssertionError assertionError) {
            this.throwAssertionError(OptionalDoubleShouldHaveValueCloseToOffset.shouldHaveValueCloseToOffset((OptionalDouble)this.actual, expectedValue, offset, Math.abs(expectedValue - ((OptionalDouble)this.actual).getAsDouble())));
        }
        return (SELF)((AbstractOptionalDoubleAssert)this.myself);
    }

    public SELF hasValueCloseTo(Double expectedValue, Percentage percentage) {
        this.isNotNull();
        if (!((OptionalDouble)this.actual).isPresent()) {
            this.throwAssertionError(OptionalDoubleShouldHaveValueCloseToPercentage.shouldHaveValueCloseToPercentage(expectedValue));
        }
        try {
            this.doubles.assertIsCloseToPercentage(this.info, ((OptionalDouble)this.actual).getAsDouble(), expectedValue, percentage);
        }
        catch (AssertionError assertionError) {
            this.throwAssertionError(OptionalDoubleShouldHaveValueCloseToPercentage.shouldHaveValueCloseToPercentage((OptionalDouble)this.actual, expectedValue, percentage, Math.abs(expectedValue - ((OptionalDouble)this.actual).getAsDouble())));
        }
        return (SELF)((AbstractOptionalDoubleAssert)this.myself);
    }
}

