/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.contrib.server.subsystem.sftp;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.sftp.server.AbstractSftpEventListenerAdapter;
import org.apache.sshd.sftp.server.DirectoryHandle;
import org.apache.sshd.sftp.server.FileHandle;
import org.apache.sshd.sftp.server.Handle;

public abstract class SimpleAccessControlSftpEventListener
extends AbstractSftpEventListenerAdapter {
    public static final SimpleAccessControlSftpEventListener READ_ONLY_ACCESSOR = new SimpleAccessControlSftpEventListener(){

        @Override
        protected boolean isAccessAllowed(ServerSession session, String remoteHandle, Path localPath) throws IOException {
            return true;
        }

        @Override
        protected boolean isModificationAllowed(ServerSession session, String remoteHandle, Path localPath) throws IOException {
            return false;
        }
    };

    protected SimpleAccessControlSftpEventListener() {
    }

    public void opening(ServerSession session, String remoteHandle, Handle localHandle) throws IOException {
        Set options;
        super.opening(session, remoteHandle, localHandle);
        if (localHandle instanceof DirectoryHandle ? !this.isAccessAllowed(session, remoteHandle, localHandle) : (GenericUtils.containsAny((Collection)(options = ((FileHandle)localHandle).getOpenOptions()), (Iterable)IoUtils.WRITEABLE_OPEN_OPTIONS) ? !this.isModificationAllowed(session, remoteHandle, localHandle.getFile()) : !this.isAccessAllowed(session, remoteHandle, localHandle))) {
            throw new AccessDeniedException(remoteHandle);
        }
    }

    public void readEntries(ServerSession session, String remoteHandle, DirectoryHandle localHandle, Map<String, Path> entries) throws IOException {
        super.readEntries(session, remoteHandle, localHandle, entries);
        if (!this.isAccessAllowed(session, remoteHandle, (Handle)localHandle)) {
            throw new AccessDeniedException(remoteHandle);
        }
    }

    public void reading(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen) throws IOException {
        super.reading(session, remoteHandle, localHandle, offset, data, dataOffset, dataLen);
        if (!this.isAccessAllowed(session, remoteHandle, (Handle)localHandle)) {
            throw new AccessDeniedException(remoteHandle);
        }
    }

    protected boolean isAccessAllowed(ServerSession session, String remoteHandle, Handle localHandle) throws IOException {
        return this.isAccessAllowed(session, remoteHandle, localHandle.getFile());
    }

    protected abstract boolean isAccessAllowed(ServerSession var1, String var2, Path var3) throws IOException;

    public void writing(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen) throws IOException {
        super.writing(session, remoteHandle, localHandle, offset, data, dataOffset, dataLen);
        if (!this.isModificationAllowed(session, remoteHandle, localHandle.getFile())) {
            throw new AccessDeniedException(remoteHandle);
        }
    }

    public void blocking(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length, int mask) throws IOException {
        super.blocking(session, remoteHandle, localHandle, offset, length, mask);
        if (!this.isModificationAllowed(session, remoteHandle, localHandle.getFile())) {
            throw new AccessDeniedException(remoteHandle);
        }
    }

    public void unblocking(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length) throws IOException {
        super.unblocking(session, remoteHandle, localHandle, offset, length);
        if (!this.isModificationAllowed(session, remoteHandle, localHandle.getFile())) {
            throw new AccessDeniedException(remoteHandle);
        }
    }

    public void creating(ServerSession session, Path path, Map<String, ?> attrs) throws IOException {
        super.creating(session, path, attrs);
        if (!this.isModificationAllowed(session, path.toString(), path)) {
            throw new AccessDeniedException(path.toString());
        }
    }

    public void moving(ServerSession session, Path srcPath, Path dstPath, Collection<CopyOption> opts) throws IOException {
        super.moving(session, srcPath, dstPath, opts);
        if (!this.isModificationAllowed(session, srcPath.toString(), srcPath)) {
            throw new AccessDeniedException(srcPath.toString());
        }
    }

    public void removing(ServerSession session, Path path, boolean isDirectory) throws IOException {
        super.removing(session, path, isDirectory);
        if (!this.isModificationAllowed(session, path.toString(), path)) {
            throw new AccessDeniedException(path.toString());
        }
    }

    public void removed(ServerSession session, Path path, boolean isDirectory, Throwable thrown) throws IOException {
        super.removed(session, path, isDirectory, thrown);
        if (!this.isModificationAllowed(session, path.toString(), path)) {
            throw new AccessDeniedException(path.toString());
        }
    }

    public void linking(ServerSession session, Path source, Path target, boolean symLink) throws IOException {
        super.linking(session, source, target, symLink);
        if (!this.isModificationAllowed(session, source.toString(), source)) {
            throw new AccessDeniedException(source.toString());
        }
    }

    public void modifyingAttributes(ServerSession session, Path path, Map<String, ?> attrs) throws IOException {
        super.modifyingAttributes(session, path, attrs);
        if (!this.isModificationAllowed(session, path.toString(), path)) {
            throw new AccessDeniedException(path.toString());
        }
    }

    protected abstract boolean isModificationAllowed(ServerSession var1, String var2, Path var3) throws IOException;
}

