/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.storage.jcr.vcardtemp;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.vysper.storage.jcr.JcrStorage;
import org.apache.vysper.storage.jcr.JcrStorageException;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.extension.xep0054_vcardtemp.VcardTempPersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrVcardTempPersistenceManager
implements VcardTempPersistenceManager {
    final Logger logger = LoggerFactory.getLogger(JcrVcardTempPersistenceManager.class);
    protected JcrStorage jcrStorage;

    public JcrVcardTempPersistenceManager(JcrStorage jcrStorage) {
        this.jcrStorage = jcrStorage;
    }

    public boolean isAvailable() {
        Session session = null;
        try {
            session = this.jcrStorage.getRepositorySession();
            return session != null;
        }
        catch (JcrStorageException e) {
            return false;
        }
    }

    public String getVcard(Entity entity) {
        Node entityNode = this.getEntityNodeSave(entity, false);
        if (entityNode == null) {
            return null;
        }
        try {
            return entityNode.getProperty("content").getString();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    private Node getEntityNodeSave(Entity entity, boolean createIfMissing) {
        Node entityNode;
        try {
            entityNode = this.jcrStorage.getEntityNode(entity.getBareJID(), "vcard-temp", createIfMissing);
        }
        catch (JcrStorageException e) {
            return null;
        }
        if (entityNode == null) {
            return null;
        }
        return entityNode;
    }

    public boolean setVcard(Entity entity, String xml) {
        Node entityNode = this.getEntityNodeSave(entity, true);
        try {
            entityNode.setProperty("content", xml);
            entityNode.save();
            this.logger.info("JCR node created: " + entityNode);
            return true;
        }
        catch (RepositoryException e) {
            return false;
        }
    }
}

