/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler;

import java.util.List;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.AffiliationItem;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.NodeAffiliationVisitor;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.PubSubServiceConfiguration;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.AbstractPubSubGeneralHandler;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.CollectionNode;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PubSubRetrieveAffiliationsHandler
extends AbstractPubSubGeneralHandler {
    public PubSubRetrieveAffiliationsHandler(PubSubServiceConfiguration serviceConfiguration) {
        super(serviceConfiguration);
    }

    @Override
    protected String getWorkerElement() {
        return "affiliations";
    }

    protected Stanza handleGet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        Entity serverJID = this.serviceConfiguration.getDomainJID();
        CollectionNode root = this.serviceConfiguration.getRootNode();
        Entity sender = PubSubRetrieveAffiliationsHandler.extractSenderJID((XMPPCoreStanza)stanza, (SessionContext)sessionContext);
        String iqStanzaID = stanza.getAttributeValue("id");
        StanzaBuilder sb = StanzaBuilder.createDirectReply((XMPPCoreStanza)stanza, (boolean)false, (IQStanzaType)IQStanzaType.RESULT);
        sb.startInnerElement("pubsub", "http://jabber.org/protocol/pubsub");
        List<AffiliationItem> subscriptions = this.collectAffiliations(root, sender);
        this.buildSuccessStanza(sb, subscriptions);
        sb.endInnerElement();
        return new IQStanza((Stanza)sb.build());
    }

    private List<AffiliationItem> collectAffiliations(CollectionNode root, Entity sender) {
        NodeAffiliationVisitor nodeAffiliationVisitor = new NodeAffiliationVisitor(sender);
        root.acceptNodes(nodeAffiliationVisitor);
        List<AffiliationItem> affiliations = nodeAffiliationVisitor.getAffiliations();
        return affiliations;
    }

    private void buildSuccessStanza(StanzaBuilder sb, List<AffiliationItem> affiliations) {
        sb.startInnerElement("affiliations", "http://jabber.org/protocol/pubsub");
        for (AffiliationItem s : affiliations) {
            sb.startInnerElement("affiliation", "http://jabber.org/protocol/pubsub");
            sb.addAttribute("node", s.getNodeName());
            sb.addAttribute("affiliation", s.getAffiliation().toString());
            sb.endInnerElement();
        }
        sb.endInnerElement();
    }
}

