/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.markup;

import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.SimpleCell;
import com.lowagie.text.SimpleTable;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class MarkupParser
extends HashMap {
    private static final long serialVersionUID = 3724008022202507040L;
    protected HashMap stylecache = new HashMap();
    protected HashMap fontcache = new HashMap();
    public static HashMap colorTable = new HashMap();

    static {
        colorTable.put("black", new Color(0));
        colorTable.put("green", new Color(32768));
        colorTable.put("silver", new Color(0xC0C0C0));
        colorTable.put("lime", new Color(65280));
        colorTable.put("gray", new Color(0x808080));
        colorTable.put("olive", new Color(0x808000));
        colorTable.put("white", new Color(0xFFFFFF));
        colorTable.put("yellow", new Color(0xFFFF00));
        colorTable.put("maroon", new Color(0x800000));
        colorTable.put("navy", new Color(128));
        colorTable.put("red", new Color(0xFF0000));
        colorTable.put("blue", new Color(255));
        colorTable.put("purple", new Color(0x800080));
        colorTable.put("teal", new Color(32896));
        colorTable.put("fuchsia", new Color(0xFF00FF));
        colorTable.put("aqua", new Color(65535));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MarkupParser(String file) {
        BufferedReader br = null;
        try {
            try {
                StringTokenizer tokenizer;
                FileReader reader = new FileReader(file);
                br = new BufferedReader(reader);
                StringBuffer buf = new StringBuffer();
                while (true) {
                    String line;
                    if ((line = br.readLine()) == null) {
                        String string = buf.toString();
                        string = MarkupParser.removeComment(string, "/*", "*/");
                        tokenizer = new StringTokenizer(string, "}");
                        break;
                    }
                    buf.append(line.trim());
                }
                while (tokenizer.hasMoreTokens()) {
                    String tmp = tokenizer.nextToken();
                    int pos = tmp.indexOf(123);
                    if (pos <= 0) continue;
                    String selector = tmp.substring(0, pos).trim();
                    String attributes = tmp.substring(pos + 1).trim();
                    if (attributes.endsWith("}")) {
                        attributes = attributes.substring(0, attributes.length() - 1);
                    }
                    this.put(selector, MarkupParser.parseAttributes(attributes));
                }
            }
            catch (Exception e) {
                throw new ExceptionConverter(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                if (br == null) throw throwable;
                br.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var12_15 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (br == null) return;
        br.close();
    }

    public static String removeComment(String string, String startComment, String endComment) {
        StringBuffer result = new StringBuffer();
        int pos = 0;
        int end = endComment.length();
        int start = string.indexOf(startComment, pos);
        while (start > -1) {
            result.append(string.substring(pos, start));
            pos = string.indexOf(endComment, start) + end;
            start = string.indexOf(startComment, pos);
        }
        result.append(string.substring(pos));
        return result.toString();
    }

    public static Properties parseAttributes(String string) {
        Properties result = new Properties();
        if (string == null) {
            return result;
        }
        StringTokenizer keyValuePairs = new StringTokenizer(string, ";");
        while (keyValuePairs.hasMoreTokens()) {
            StringTokenizer keyValuePair = new StringTokenizer(keyValuePairs.nextToken(), ":");
            if (!keyValuePair.hasMoreTokens()) continue;
            String key = keyValuePair.nextToken().trim();
            if (!keyValuePair.hasMoreTokens()) continue;
            String value = keyValuePair.nextToken().trim();
            if (value.startsWith("\"")) {
                value = value.substring(1);
            }
            if (value.endsWith("\"")) {
                value = value.substring(0, value.length() - 1);
            }
            result.setProperty(key.toLowerCase(), value);
        }
        return result;
    }

    public static float parseLength(String string) {
        int pos = 0;
        int length = string.length();
        boolean ok = true;
        while (ok && pos < length) {
            switch (string.charAt(pos)) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ++pos;
                    break;
                }
                default: {
                    ok = false;
                }
            }
        }
        if (pos == 0) {
            return 0.0f;
        }
        if (pos == length) {
            return Float.parseFloat(String.valueOf(string) + "f");
        }
        float f = Float.parseFloat(String.valueOf(string.substring(0, pos)) + "f");
        if ((string = string.substring(pos)).startsWith("in")) {
            return f * 72.0f;
        }
        if (string.startsWith("cm")) {
            return f / 2.54f * 72.0f;
        }
        if (string.startsWith("mm")) {
            return f / 25.4f * 72.0f;
        }
        if (string.startsWith("pc")) {
            return f * 12.0f;
        }
        return f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Color decodeColor(String s) {
        if (s == null) {
            return null;
        }
        Color c = (Color)colorTable.get(s = s.toLowerCase().trim());
        if (c != null) {
            return c;
        }
        try {
            if (s.startsWith("#")) {
                if (s.length() == 4) {
                    s = "#" + s.substring(1, 2) + s.substring(1, 2) + s.substring(2, 3) + s.substring(2, 3) + s.substring(3, 4) + s.substring(3, 4);
                }
                if (s.length() != 7) return null;
                return new Color(Integer.parseInt(s.substring(1), 16));
            }
            if (!s.startsWith("rgb")) return null;
            StringTokenizer tk = new StringTokenizer(s.substring(3), " \t\r\n\f(),");
            int[] cc = new int[3];
            int k = 0;
            while (true) {
                float n;
                if (k >= 3) {
                    return new Color(cc[0], cc[1], cc[2]);
                }
                if (!tk.hasMoreTokens()) {
                    return null;
                }
                String t = tk.nextToken();
                if (t.endsWith("%")) {
                    n = Float.parseFloat(t.substring(0, t.length() - 1));
                    n = n * 255.0f / 100.0f;
                } else {
                    n = Float.parseFloat(t);
                }
                int ni = (int)n;
                if (ni > 255) {
                    ni = 255;
                } else if (ni < 0) {
                    ni = 0;
                }
                cc[k] = ni;
                ++k;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getKey(Properties attributes) {
        String tag = attributes.getProperty("tag");
        String id = attributes.getProperty("id");
        String cl = attributes.getProperty("class");
        id = id == null ? "" : "#" + id;
        cl = cl == null ? "" : "." + cl;
        String key = String.valueOf(tag) + id + cl;
        if (!this.stylecache.containsKey(key) && key.length() > 0) {
            Properties props = new Properties();
            Properties tagprops = (Properties)this.get(tag);
            Properties idprops = (Properties)this.get(id);
            Properties clprops = (Properties)this.get(cl);
            Properties tagidprops = (Properties)this.get(String.valueOf(tag) + id);
            Properties tagclprops = (Properties)this.get(String.valueOf(tag) + cl);
            if (tagprops != null) {
                props.putAll((Map<?, ?>)tagprops);
            }
            if (idprops != null) {
                props.putAll((Map<?, ?>)idprops);
            }
            if (clprops != null) {
                props.putAll((Map<?, ?>)clprops);
            }
            if (tagidprops != null) {
                props.putAll((Map<?, ?>)tagidprops);
            }
            if (tagclprops != null) {
                props.putAll((Map<?, ?>)tagclprops);
            }
            this.stylecache.put(key, props);
        }
        return key;
    }

    public boolean getPageBreakBefore(Properties attributes) {
        String key = this.getKey(attributes);
        Properties styleattributes = (Properties)this.stylecache.get(key);
        return styleattributes != null && "always".equals(styleattributes.getProperty("page-break-before"));
    }

    public boolean getPageBreakAfter(Properties attributes) {
        String key = this.getKey(attributes);
        Properties styleattributes = (Properties)this.stylecache.get(key);
        return styleattributes != null && "always".equals(styleattributes.getProperty("page-break-after"));
    }

    public Element getObject(Properties attributes) {
        String key = this.getKey(attributes);
        Properties styleattributes = (Properties)this.stylecache.get(key);
        if (styleattributes == null) {
            return null;
        }
        if ("hidden".equals(styleattributes.get("visibility"))) {
            return null;
        }
        String display = styleattributes.getProperty("display");
        Element element = null;
        if ("inline".equals(display)) {
            element = this.retrievePhrase(this.getFont(attributes), styleattributes);
        } else if ("block".equals(display)) {
            element = this.retrieveParagraph(this.getFont(attributes), styleattributes);
        } else if ("list-item".equals(display)) {
            element = this.retrieveListItem(this.getFont(attributes), styleattributes);
        } else if ("table-cell".equals(display)) {
            element = this.retrieveTableCell(attributes, styleattributes);
        } else if ("table-row".equals(display)) {
            element = this.retrieveTableRow(attributes, styleattributes);
        } else if ("table".equals(display)) {
            element = this.retrieveTable(attributes, styleattributes);
        }
        return element;
    }

    public Font getFont(Properties attributes) {
        String key = this.getKey(attributes);
        Font f = (Font)this.fontcache.get(key);
        if (f != null) {
            return f;
        }
        Properties styleattributes = (Properties)this.stylecache.get(key);
        f = this.retrieveFont(styleattributes);
        this.fontcache.put(key, f);
        return f;
    }

    public Rectangle getRectangle(Properties attrs) {
        String width = null;
        String height = null;
        String key = this.getKey(attrs);
        Properties styleattributes = (Properties)this.stylecache.get(key);
        if (styleattributes != null) {
            width = styleattributes.getProperty("width");
            height = styleattributes.getProperty("height");
        }
        if (width == null) {
            width = attrs.getProperty("width");
        }
        if (height == null) {
            height = attrs.getProperty("height");
        }
        if (width == null || height == null) {
            return null;
        }
        return new Rectangle(MarkupParser.parseLength(width), MarkupParser.parseLength(height));
    }

    public Element retrievePhrase(Font font, Properties styleattributes) {
        Phrase p = new Phrase("", font);
        if (styleattributes == null) {
            return p;
        }
        String leading = styleattributes.getProperty("line-height");
        if (leading != null) {
            if (leading.endsWith("%")) {
                p.setLeading(p.font().size() * (MarkupParser.parseLength(leading) / 100.0f));
            } else {
                p.setLeading(MarkupParser.parseLength(leading));
            }
        }
        return p;
    }

    public Element retrieveParagraph(Font font, Properties styleattributes) {
        String align;
        float f;
        Paragraph p = new Paragraph((Phrase)this.retrievePhrase(font, styleattributes));
        if (styleattributes == null) {
            return p;
        }
        String margin = styleattributes.getProperty("margin");
        if (margin != null) {
            f = MarkupParser.parseLength(margin);
            p.setIndentationLeft(f);
            p.setIndentationRight(f);
            p.setSpacingBefore(f);
            p.setSpacingAfter(f);
        }
        if ((margin = styleattributes.getProperty("margin-left")) != null) {
            f = MarkupParser.parseLength(margin);
            p.setIndentationLeft(f);
        }
        if ((margin = styleattributes.getProperty("margin-right")) != null) {
            f = MarkupParser.parseLength(margin);
            p.setIndentationRight(f);
        }
        if ((margin = styleattributes.getProperty("margin-top")) != null) {
            f = MarkupParser.parseLength(margin);
            p.setSpacingBefore(f);
        }
        if ((margin = styleattributes.getProperty("margin-bottom")) != null) {
            f = MarkupParser.parseLength(margin);
            p.setSpacingAfter(f);
        }
        if ("left".equals(align = styleattributes.getProperty("text-align"))) {
            p.setAlignment(0);
        } else if ("right".equals(align)) {
            p.setAlignment(2);
        } else if ("center".equals(align)) {
            p.setAlignment(1);
        } else if ("justify".equals(align)) {
            p.setAlignment(3);
        }
        return p;
    }

    private Element retrieveTable(Properties attributes, Properties styleattributes) {
        SimpleTable table = new SimpleTable();
        this.applyBordersColors(table, attributes, styleattributes);
        return table;
    }

    private Element retrieveTableRow(Properties attributes, Properties styleattributes) {
        String padding;
        float f;
        String margin;
        SimpleCell row = new SimpleCell(true);
        this.applyBordersColors(row, attributes, styleattributes);
        String width = null;
        if (attributes != null) {
            width = attributes.getProperty("width");
        }
        if (width == null) {
            width = styleattributes.getProperty("width");
        }
        if (width != null) {
            if (width.endsWith("%")) {
                row.setWidthpercentage(MarkupParser.parseLength(width));
            } else {
                row.setWidth(MarkupParser.parseLength(width));
            }
        }
        if ((margin = styleattributes.getProperty("margin")) != null) {
            f = MarkupParser.parseLength(margin);
            row.setSpacing(f);
        }
        if ((margin = styleattributes.getProperty("margin-left")) != null) {
            f = MarkupParser.parseLength(margin);
            row.setSpacing_left(f);
        }
        if ((margin = styleattributes.getProperty("margin-right")) != null) {
            f = MarkupParser.parseLength(margin);
            row.setSpacing_right(f);
        }
        if ((margin = styleattributes.getProperty("margin-top")) != null) {
            f = MarkupParser.parseLength(margin);
            row.setSpacing_top(f);
        }
        if ((margin = styleattributes.getProperty("margin-bottom")) != null) {
            f = MarkupParser.parseLength(margin);
            row.setSpacing_bottom(f);
        }
        if ((padding = styleattributes.getProperty("padding")) != null) {
            f = MarkupParser.parseLength(padding);
            row.setPadding(f);
        }
        if ((padding = styleattributes.getProperty("padding-left")) != null) {
            f = MarkupParser.parseLength(padding);
            row.setSpacing_left(f);
        }
        if ((padding = styleattributes.getProperty("padding-right")) != null) {
            f = MarkupParser.parseLength(padding);
            row.setSpacing_right(f);
        }
        if ((padding = styleattributes.getProperty("padding-top")) != null) {
            f = MarkupParser.parseLength(padding);
            row.setSpacing_top(f);
        }
        if ((padding = styleattributes.getProperty("padding-bottom")) != null) {
            f = MarkupParser.parseLength(padding);
            row.setSpacing_bottom(f);
        }
        return row;
    }

    private Element retrieveTableCell(Properties attributes, Properties styleattributes) {
        SimpleCell cell = (SimpleCell)this.retrieveTableRow(attributes, styleattributes);
        cell.setCellgroup(false);
        return cell;
    }

    private Element retrieveListItem(Font font, Properties styleattributes) {
        ListItem li = new ListItem();
        return li;
    }

    private void applyBordersColors(Rectangle rect, Properties attributes, Properties styleattributes) {
        float f;
        String s = styleattributes.getProperty("border-width");
        if (s != null) {
            f = MarkupParser.parseLength(s);
            rect.setBorderWidth(f);
        }
        if ((s = styleattributes.getProperty("border-left-width")) != null) {
            f = MarkupParser.parseLength(s);
            rect.setBorderWidthLeft(f);
        }
        if ((s = styleattributes.getProperty("border-right-width")) != null) {
            f = MarkupParser.parseLength(s);
            rect.setBorderWidthRight(f);
        }
        if ((s = styleattributes.getProperty("border-top-width")) != null) {
            f = MarkupParser.parseLength(s);
            rect.setBorderWidthTop(f);
        }
        if ((s = styleattributes.getProperty("border-bottom-width")) != null) {
            f = MarkupParser.parseLength(s);
            rect.setBorderWidthBottom(f);
        }
        if ((s = styleattributes.getProperty("border-color")) != null) {
            rect.setBorderColor(MarkupParser.decodeColor(s));
        }
    }

    /*
     * Unable to fully structure code
     */
    public Font retrieveFont(Properties styleAttributes) {
        block6: {
            fontname = null;
            encoding = FontFactory.defaultEncoding;
            embedded = FontFactory.defaultEmbedding;
            size = -1.0f;
            style = 0;
            color = null;
            value = (String)styleAttributes.get("font-family");
            if (value == null) break block6;
            if (value.indexOf(44) != -1) ** GOTO lbl17
            fontname = value.trim();
            break block6;
lbl-1000:
            // 1 sources

            {
                tmp = value.substring(0, value.indexOf(44)).trim();
                if (FontFactory.isRegistered(tmp)) {
                    fontname = tmp;
                    break;
                }
                value = value.substring(value.indexOf(44) + 1);
lbl17:
                // 2 sources

                ** while (value.indexOf((int)44) != -1)
            }
        }
        if ((value = (String)styleAttributes.get("font-size")) != null) {
            size = MarkupParser.parseLength(value);
        }
        if ((value = (String)styleAttributes.get("font-weight")) != null) {
            style |= Font.getStyleValue(value);
        }
        if ((value = (String)styleAttributes.get("font-style")) != null) {
            style |= Font.getStyleValue(value);
        }
        if ((value = (String)styleAttributes.get("color")) != null) {
            color = MarkupParser.decodeColor(value);
        }
        return FontFactory.getFont(fontname, encoding, embedded, size, style, color);
    }
}

