/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.faces.validator._MessageUtils;

public class LengthValidator
implements Validator,
StateHolder {
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MINIMUM";
    public static final String VALIDATOR_ID = "javax.faces.Length";
    private Integer _minimum = null;
    private Integer _maximum = null;
    private boolean _transient = false;

    public LengthValidator() {
    }

    public LengthValidator(int maximum) {
        this._maximum = new Integer(maximum);
    }

    public LengthValidator(int maximum, int minimum) {
        this._maximum = new Integer(maximum);
        this._minimum = new Integer(minimum);
    }

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        int length;
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return;
        }
        int n = length = value instanceof String ? ((String)value).length() : value.toString().length();
        if (this._minimum != null && length < this._minimum) {
            Object[] args = new Object[]{this._minimum, uiComponent.getId()};
            throw new ValidatorException(_MessageUtils.getErrorMessage(facesContext, MINIMUM_MESSAGE_ID, args));
        }
        if (this._maximum != null && length > this._maximum) {
            Object[] args = new Object[]{this._maximum, uiComponent.getId()};
            throw new ValidatorException(_MessageUtils.getErrorMessage(facesContext, MAXIMUM_MESSAGE_ID, args));
        }
    }

    public int getMaximum() {
        return this._maximum != null ? this._maximum : 0;
    }

    public void setMaximum(int maximum) {
        this._maximum = new Integer(maximum);
    }

    public int getMinimum() {
        return this._minimum != null ? this._minimum : 0;
    }

    public void setMinimum(int minimum) {
        this._minimum = new Integer(minimum);
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean transientValue) {
        this._transient = transientValue;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this._maximum, this._minimum};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this._maximum = (Integer)values[0];
        this._minimum = (Integer)values[1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LengthValidator)) {
            return false;
        }
        LengthValidator lengthValidator = (LengthValidator)o;
        if (this._maximum != null ? !this._maximum.equals(lengthValidator._maximum) : lengthValidator._maximum != null) {
            return false;
        }
        return !(this._minimum != null ? !this._minimum.equals(lengthValidator._minimum) : lengthValidator._minimum != null);
    }
}

