/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit;

import javax.faces.context.FacesContext;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.util.StringUtils;

public class ContentTypeUtils {
    public static final String HTML_CONTENT_TYPE = "text/html";
    public static final String TEXT_ANY_CONTENT_TYPE = "text/*";
    public static final String ANY_CONTENT_TYPE = "*/*";
    public static final String[] HTML_ALLOWED_CONTENT_TYPES = new String[]{"text/html", "*/*", "text/*"};
    public static final String XHTML_CONTENT_TYPE = "application/xhtml+xml";
    public static final String APPLICATION_XML_CONTENT_TYPE = "application/xml";
    public static final String TEXT_XML_CONTENT_TYPE = "text/xml";
    public static final String[] XHTML_ALLOWED_CONTENT_TYPES = new String[]{"application/xhtml+xml", "application/xml", "text/xml"};
    public static final String[] AJAX_XHTML_ALLOWED_CONTENT_TYPES = new String[]{"application/xhtml+xml"};

    public static boolean containsContentType(String contentType, String[] allowedContentTypes) {
        if (allowedContentTypes == null) {
            return false;
        }
        for (int i = 0; i < allowedContentTypes.length; ++i) {
            if (allowedContentTypes[i].indexOf(contentType) == -1) continue;
            return true;
        }
        return false;
    }

    public static String chooseWriterContentType(String contentTypeListString, String[] htmlContentTypes, String[] xhtmlContentTypes) {
        String[] contentTypeList = ContentTypeUtils.splitContentTypeListString(contentTypeListString);
        String[] supportedContentTypeArray = HtmlRendererUtils.getSupportedContentTypes();
        String selectedContentType = null;
        for (int i = 0; i < supportedContentTypeArray.length; ++i) {
            String supportedContentType = supportedContentTypeArray[i].trim();
            for (int j = 0; j < contentTypeList.length; ++j) {
                String contentType = contentTypeList[j];
                if (contentType.indexOf(supportedContentType) == -1) continue;
                if (ContentTypeUtils.containsContentType(contentType, htmlContentTypes)) {
                    selectedContentType = HTML_CONTENT_TYPE;
                    break;
                }
                if (!ContentTypeUtils.containsContentType(contentType, xhtmlContentTypes)) break;
                selectedContentType = XHTML_CONTENT_TYPE;
                break;
            }
            if (selectedContentType != null) break;
        }
        return selectedContentType;
    }

    public static String[] splitContentTypeListString(String contentTypeListString) {
        String[] splittedArray = StringUtils.splitShortString(contentTypeListString, ',');
        for (int i = 0; i < splittedArray.length; ++i) {
            int semicolonIndex = splittedArray[i].indexOf(";");
            if (semicolonIndex == -1) continue;
            splittedArray[i] = splittedArray[i].substring(0, semicolonIndex);
        }
        return splittedArray;
    }

    public static String getContentTypeFromAcceptHeader(FacesContext context) {
        String contentTypeListString = context.getExternalContext().getRequestHeaderMap().get("Accept");
        if (contentTypeListString != null && contentTypeListString.startsWith("application/vnd.wap.mms-message;*/*")) {
            contentTypeListString = ANY_CONTENT_TYPE;
        }
        return contentTypeListString;
    }
}

