/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces._FactoryFinderProviderFactory;
import javax.faces.application.ApplicationFactory;
import javax.faces.component.visit.VisitContextFactory;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.ExternalContextFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.FlashFactory;
import javax.faces.context.PartialViewContextFactory;
import javax.faces.flow.FlowHandlerFactory;
import javax.faces.lifecycle.ClientWindowFactory;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;
import javax.faces.view.ViewDeclarationLanguageFactory;
import javax.faces.view.facelets.FaceletCacheFactory;
import javax.faces.view.facelets.TagHandlerDelegateFactory;

public final class FactoryFinder {
    public static final String APPLICATION_FACTORY = "javax.faces.application.ApplicationFactory";
    public static final String EXCEPTION_HANDLER_FACTORY = "javax.faces.context.ExceptionHandlerFactory";
    public static final String EXTERNAL_CONTEXT_FACTORY = "javax.faces.context.ExternalContextFactory";
    public static final String FACES_CONTEXT_FACTORY = "javax.faces.context.FacesContextFactory";
    public static final String LIFECYCLE_FACTORY = "javax.faces.lifecycle.LifecycleFactory";
    public static final String PARTIAL_VIEW_CONTEXT_FACTORY = "javax.faces.context.PartialViewContextFactory";
    public static final String RENDER_KIT_FACTORY = "javax.faces.render.RenderKitFactory";
    public static final String TAG_HANDLER_DELEGATE_FACTORY = "javax.faces.view.facelets.TagHandlerDelegateFactory";
    public static final String VIEW_DECLARATION_LANGUAGE_FACTORY = "javax.faces.view.ViewDeclarationLanguageFactory";
    public static final String VISIT_CONTEXT_FACTORY = "javax.faces.component.visit.VisitContextFactory";
    public static final String FACELET_CACHE_FACTORY = "javax.faces.view.facelets.FaceletCacheFactory";
    public static final String FLASH_FACTORY = "javax.faces.context.FlashFactory";
    public static final String FLOW_HANDLER_FACTORY = "javax.faces.flow.FlowHandlerFactory";
    public static final String CLIENT_WINDOW_FACTORY = "javax.faces.lifecycle.ClientWindowFactory";
    private static Map<ClassLoader, Map<String, List<String>>> registeredFactoryNames = new HashMap<ClassLoader, Map<String, List<String>>>();
    private static Map<ClassLoader, Map<String, Object>> factories = new HashMap<ClassLoader, Map<String, Object>>();
    private static final Set<String> VALID_FACTORY_NAMES = new HashSet<String>();
    private static final Map<String, Class<?>> ABSTRACT_FACTORY_CLASSES = new HashMap();
    private static final ClassLoader MYFACES_CLASSLOADER;
    private static final String INJECTION_PROVIDER_INSTANCE = "oam.spi.INJECTION_PROVIDER_KEY";
    private static final String INJECTED_BEAN_STORAGE_KEY = "org.apache.myfaces.spi.BEAN_ENTRY_STORAGE";
    private static final String BEAN_ENTRY_CLASS_NAME = "org.apache.myfaces.cdi.dependent.BeanEntry";
    private static final Logger LOGGER;
    private static Object factoryFinderProviderFactoryInstance;
    private static volatile boolean initialized;

    private static void initializeFactoryFinderProviderFactory() {
        if (!initialized) {
            factoryFinderProviderFactoryInstance = _FactoryFinderProviderFactory.getInstance();
            initialized = true;
        }
    }

    FactoryFinder() {
    }

    public static Object getFactory(String factoryName) throws FacesException {
        if (factoryName == null) {
            throw new NullPointerException("factoryName may not be null");
        }
        FactoryFinder.initializeFactoryFinderProviderFactory();
        if (factoryFinderProviderFactoryInstance == null) {
            return FactoryFinder._getFactory(factoryName);
        }
        try {
            Object ffp = _FactoryFinderProviderFactory.FACTORY_FINDER_PROVIDER_FACTORY_GET_FACTORY_FINDER_METHOD.invoke(factoryFinderProviderFactoryInstance, null);
            return _FactoryFinderProviderFactory.FACTORY_FINDER_PROVIDER_GET_FACTORY_METHOD.invoke(ffp, factoryName);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getCause();
            if (targetException instanceof NullPointerException) {
                throw (NullPointerException)targetException;
            }
            if (targetException instanceof FacesException) {
                throw (FacesException)targetException;
            }
            if (targetException instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)targetException;
            }
            if (targetException instanceof IllegalStateException) {
                throw (IllegalStateException)targetException;
            }
            if (targetException == null) {
                throw new FacesException(e);
            }
            throw new FacesException(targetException);
        }
        catch (Exception e) {
            throw new FacesException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object _getFactory(String factoryName) throws FacesException {
        Object injectionProvider;
        List<String> classNames;
        Object factory;
        CopyOnWriteArrayList beanEntryStorage;
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        Map<String, List<String>> factoryClassNames = null;
        Map<String, Object> factoryMap = null;
        Map<ClassLoader, Map<String, List<String>>> map = registeredFactoryNames;
        synchronized (map) {
            factoryClassNames = registeredFactoryNames.get(classLoader);
            if (factoryClassNames == null) {
                String message = "No Factories configured for this Application. This happens if the faces-initialization does not work at all - make sure that you properly include all configuration settings necessary for a basic faces application and that all the necessary libs are included. Also check the logging output of your web application and your container for any exceptions!\nIf you did that and find nothing, the mistake might be due to the fact that you use some special web-containers which do not support registering context-listeners via TLD files and a context listener is not setup in your web.xml.\nA typical config looks like this;\n<listener>\n  <listener-class>org.apache.myfaces.webapp.StartupServletContextListener</listener-class>\n</listener>\n";
                throw new IllegalStateException(message);
            }
            if (!factoryClassNames.containsKey(factoryName)) {
                throw new IllegalArgumentException("no factory " + factoryName + " configured for this application.");
            }
            factoryMap = factories.get(classLoader);
            if (factoryMap == null) {
                factoryMap = new HashMap<String, Object>();
                factories.put(classLoader, factoryMap);
            }
        }
        Map<String, List<String>> message = factoryClassNames;
        synchronized (message) {
            beanEntryStorage = (CopyOnWriteArrayList)factoryMap.get(INJECTED_BEAN_STORAGE_KEY);
            if (beanEntryStorage == null) {
                beanEntryStorage = new CopyOnWriteArrayList();
                factoryMap.put(INJECTED_BEAN_STORAGE_KEY, beanEntryStorage);
            }
        }
        Map<String, List<String>> map2 = factoryClassNames;
        synchronized (map2) {
            factory = factoryMap.get(factoryName);
            if (factory != null) {
                return factory;
            }
            classNames = factoryClassNames.get(factoryName);
            injectionProvider = factoryMap.get(INJECTION_PROVIDER_INSTANCE);
        }
        if (injectionProvider == null) {
            injectionProvider = FactoryFinder.getInjectionProvider();
            map2 = factoryClassNames;
            synchronized (map2) {
                factoryMap.put(INJECTION_PROVIDER_INSTANCE, injectionProvider);
            }
        }
        factory = FactoryFinder.newFactoryInstance(ABSTRACT_FACTORY_CLASSES.get(factoryName), classNames.iterator(), classLoader, injectionProvider, beanEntryStorage);
        map2 = factoryClassNames;
        synchronized (map2) {
            if (factoryMap.get(factoryName) == null) {
                factoryMap.put(factoryName, factory);
            }
        }
        return factory;
    }

    private static Object getInjectionProvider() {
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext != null) {
                Object injectionProviderFactory = _FactoryFinderProviderFactory.INJECTION_PROVIDER_FACTORY_GET_INSTANCE_METHOD.invoke(_FactoryFinderProviderFactory.INJECTION_PROVIDER_CLASS, new Object[0]);
                Object injectionProvider = _FactoryFinderProviderFactory.INJECTION_PROVIDER_FACTORY_GET_INJECTION_PROVIDER_METHOD.invoke(injectionProviderFactory, facesContext.getExternalContext());
                return injectionProvider;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void injectAndPostConstruct(Object injectionProvider, Object instance, List injectedBeanStorage) {
        if (injectionProvider != null) {
            try {
                Object creationMetaData = _FactoryFinderProviderFactory.INJECTION_PROVIDER_INJECT_METHOD.invoke(injectionProvider, instance);
                FactoryFinder.addBeanEntry(instance, creationMetaData, injectedBeanStorage);
                _FactoryFinderProviderFactory.INJECTION_PROVIDER_POST_CONSTRUCT_METHOD.invoke(injectionProvider, instance, creationMetaData);
            }
            catch (Exception ex) {
                throw new FacesException(ex);
            }
        }
    }

    private static void preDestroy(Object injectionProvider, Object beanEntry) {
        if (injectionProvider != null) {
            try {
                _FactoryFinderProviderFactory.INJECTION_PROVIDER_PRE_DESTROY_METHOD.invoke(injectionProvider, FactoryFinder.getInstance(beanEntry), FactoryFinder.getCreationMetaData(beanEntry));
            }
            catch (Exception ex) {
                throw new FacesException(ex);
            }
        }
    }

    private static Object getInstance(Object beanEntry) {
        try {
            Method getterMethod = FactoryFinder.getMethod(beanEntry, "getInstance");
            return getterMethod.invoke(beanEntry, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Object getCreationMetaData(Object beanEntry) {
        try {
            Method getterMethod = FactoryFinder.getMethod(beanEntry, "getCreationMetaData");
            return getterMethod.invoke(beanEntry, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Method getMethod(Object beanEntry, String methodName) throws NoSuchMethodException {
        return beanEntry.getClass().getDeclaredMethod(methodName, new Class[0]);
    }

    private static void addBeanEntry(Object instance, Object creationMetaData, List injectedBeanStorage) {
        try {
            Class<?> beanEntryClass = _FactoryFinderProviderFactory.classForName(BEAN_ENTRY_CLASS_NAME);
            Constructor<?> beanEntryConstructor = beanEntryClass.getDeclaredConstructor(Object.class, Object.class);
            Object result = beanEntryConstructor.newInstance(instance, creationMetaData);
            injectedBeanStorage.add(result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Object newFactoryInstance(Class<?> interfaceClass, Iterator<String> classNamesIterator, ClassLoader classLoader, Object injectionProvider, List injectedBeanStorage) {
        try {
            Object current = null;
            while (classNamesIterator.hasNext()) {
                String implClassName = classNamesIterator.next();
                Class<?> implClass = null;
                try {
                    implClass = classLoader.loadClass(implClassName);
                }
                catch (ClassNotFoundException e) {
                    implClass = MYFACES_CLASSLOADER.loadClass(implClassName);
                }
                if (!interfaceClass.isAssignableFrom(implClass)) {
                    throw new IllegalArgumentException("Class " + implClassName + " is no " + interfaceClass.getName());
                }
                if (current == null) {
                    current = implClass.newInstance();
                    FactoryFinder.injectAndPostConstruct(injectionProvider, current, injectedBeanStorage);
                    continue;
                }
                try {
                    Constructor<?> delegationConstructor = implClass.getConstructor(interfaceClass);
                    try {
                        current = delegationConstructor.newInstance(current);
                        FactoryFinder.injectAndPostConstruct(injectionProvider, current, injectedBeanStorage);
                    }
                    catch (InstantiationException e) {
                        throw new FacesException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new FacesException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new FacesException(e);
                    }
                }
                catch (NoSuchMethodException e) {
                    current = implClass.newInstance();
                    FactoryFinder.injectAndPostConstruct(injectionProvider, current, injectedBeanStorage);
                }
            }
            return current;
        }
        catch (ClassNotFoundException e) {
            throw new FacesException(e);
        }
        catch (InstantiationException e) {
            throw new FacesException(e);
        }
        catch (IllegalAccessException e) {
            throw new FacesException(e);
        }
    }

    public static void setFactory(String factoryName, String implName) {
        if (factoryName == null) {
            throw new NullPointerException("factoryName may not be null");
        }
        FactoryFinder.initializeFactoryFinderProviderFactory();
        if (factoryFinderProviderFactoryInstance == null) {
            FactoryFinder._setFactory(factoryName, implName);
        } else {
            try {
                Object ffp = _FactoryFinderProviderFactory.FACTORY_FINDER_PROVIDER_FACTORY_GET_FACTORY_FINDER_METHOD.invoke(factoryFinderProviderFactoryInstance, null);
                _FactoryFinderProviderFactory.FACTORY_FINDER_PROVIDER_SET_FACTORY_METHOD.invoke(ffp, factoryName, implName);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getCause();
                if (targetException instanceof NullPointerException) {
                    throw (NullPointerException)targetException;
                }
                if (targetException instanceof FacesException) {
                    throw (FacesException)targetException;
                }
                if (targetException instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)targetException;
                }
                if (targetException == null) {
                    throw new FacesException(e);
                }
                throw new FacesException(targetException);
            }
            catch (Exception e) {
                throw new FacesException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _setFactory(String factoryName, String implName) {
        FactoryFinder.checkFactoryName(factoryName);
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        Map<String, List<String>> factoryClassNames = null;
        Map<Object, Object> map = registeredFactoryNames;
        synchronized (map) {
            Map<String, Object> factories = FactoryFinder.factories.get(classLoader);
            if (factories != null && factories.containsKey(factoryName)) {
                return;
            }
            factoryClassNames = registeredFactoryNames.get(classLoader);
            if (factoryClassNames == null) {
                factoryClassNames = new HashMap<String, List<String>>();
                registeredFactoryNames.put(classLoader, factoryClassNames);
            }
        }
        map = factoryClassNames;
        synchronized (map) {
            List<String> classNameList = factoryClassNames.get(factoryName);
            if (classNameList == null) {
                classNameList = new ArrayList<String>();
                factoryClassNames.put(factoryName, classNameList);
            }
            classNameList.add(implName);
        }
    }

    public static void releaseFactories() throws FacesException {
        FactoryFinder.initializeFactoryFinderProviderFactory();
        if (factoryFinderProviderFactoryInstance == null) {
            FactoryFinder._releaseFactories();
        } else {
            try {
                Object ffp = _FactoryFinderProviderFactory.FACTORY_FINDER_PROVIDER_FACTORY_GET_FACTORY_FINDER_METHOD.invoke(factoryFinderProviderFactoryInstance, null);
                _FactoryFinderProviderFactory.FACTORY_FINDER_PROVIDER_RELEASE_FACTORIES_METHOD.invoke(ffp, null);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getCause();
                if (targetException instanceof FacesException) {
                    throw (FacesException)targetException;
                }
                if (targetException == null) {
                    throw new FacesException(e);
                }
                throw new FacesException(targetException);
            }
            catch (Exception e) {
                throw new FacesException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _releaseFactories() throws FacesException {
        Object injectionProvider;
        Map<String, Object> factoryMap;
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        Map<ClassLoader, Map<String, List<String>>> map = registeredFactoryNames;
        synchronized (map) {
            factoryMap = factories.remove(classLoader);
            Map<String, List<String>> factoryClassNames = registeredFactoryNames.get(classLoader);
            if (factoryClassNames != null) {
                factoryClassNames.clear();
            }
            registeredFactoryNames.remove(classLoader);
        }
        if (factoryMap != null && (injectionProvider = factoryMap.remove(INJECTION_PROVIDER_INSTANCE)) != null) {
            List injectedBeanStorage = (List)factoryMap.get(INJECTED_BEAN_STORAGE_KEY);
            FacesException firstException = null;
            for (Object entry : injectedBeanStorage) {
                try {
                    FactoryFinder.preDestroy(injectionProvider, entry);
                }
                catch (FacesException e) {
                    LOGGER.log(Level.SEVERE, "#preDestroy failed", e);
                    if (firstException != null) continue;
                    firstException = e;
                }
            }
            injectedBeanStorage.clear();
            if (firstException != null) {
                throw firstException;
            }
        }
    }

    private static void checkFactoryName(String factoryName) {
        if (!VALID_FACTORY_NAMES.contains(factoryName)) {
            throw new IllegalArgumentException("factoryName '" + factoryName + "'");
        }
    }

    private static ClassLoader getClassLoader() {
        try {
            ClassLoader classLoader = null;
            classLoader = System.getSecurityManager() != null ? (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            }) : Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                throw new FacesException("web application class loader cannot be identified", null);
            }
            return classLoader;
        }
        catch (Exception e) {
            throw new FacesException("web application class loader cannot be identified", e);
        }
    }

    static {
        LOGGER = Logger.getLogger(FactoryFinder.class.getName());
        VALID_FACTORY_NAMES.add(APPLICATION_FACTORY);
        VALID_FACTORY_NAMES.add(EXCEPTION_HANDLER_FACTORY);
        VALID_FACTORY_NAMES.add(EXTERNAL_CONTEXT_FACTORY);
        VALID_FACTORY_NAMES.add(FACES_CONTEXT_FACTORY);
        VALID_FACTORY_NAMES.add(LIFECYCLE_FACTORY);
        VALID_FACTORY_NAMES.add(PARTIAL_VIEW_CONTEXT_FACTORY);
        VALID_FACTORY_NAMES.add(RENDER_KIT_FACTORY);
        VALID_FACTORY_NAMES.add(TAG_HANDLER_DELEGATE_FACTORY);
        VALID_FACTORY_NAMES.add(VIEW_DECLARATION_LANGUAGE_FACTORY);
        VALID_FACTORY_NAMES.add(VISIT_CONTEXT_FACTORY);
        VALID_FACTORY_NAMES.add(FACELET_CACHE_FACTORY);
        VALID_FACTORY_NAMES.add(FLASH_FACTORY);
        VALID_FACTORY_NAMES.add(FLOW_HANDLER_FACTORY);
        VALID_FACTORY_NAMES.add(CLIENT_WINDOW_FACTORY);
        ABSTRACT_FACTORY_CLASSES.put(APPLICATION_FACTORY, ApplicationFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(EXCEPTION_HANDLER_FACTORY, ExceptionHandlerFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(EXTERNAL_CONTEXT_FACTORY, ExternalContextFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(FACES_CONTEXT_FACTORY, FacesContextFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(LIFECYCLE_FACTORY, LifecycleFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(PARTIAL_VIEW_CONTEXT_FACTORY, PartialViewContextFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(RENDER_KIT_FACTORY, RenderKitFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(TAG_HANDLER_DELEGATE_FACTORY, TagHandlerDelegateFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(VIEW_DECLARATION_LANGUAGE_FACTORY, ViewDeclarationLanguageFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(VISIT_CONTEXT_FACTORY, VisitContextFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(FACELET_CACHE_FACTORY, FaceletCacheFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(FLASH_FACTORY, FlashFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(FLOW_HANDLER_FACTORY, FlowHandlerFactory.class);
        ABSTRACT_FACTORY_CLASSES.put(CLIENT_WINDOW_FACTORY, ClientWindowFactory.class);
        try {
            ClassLoader classLoader = System.getSecurityManager() != null ? (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return FactoryFinder.class.getClassLoader();
                }
            }) : FactoryFinder.class.getClassLoader();
            if (classLoader == null) {
                throw new FacesException("jsf api class loader cannot be identified", null);
            }
            MYFACES_CLASSLOADER = classLoader;
        }
        catch (Exception e) {
            throw new FacesException("jsf api class loader cannot be identified", e);
        }
        initialized = false;
    }
}

