/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.spi.ResourceLibraryContractsProvider;
import org.apache.myfaces.spi.impl.DefaultResourceLibraryContractsProviderFactory;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class ResourceLibraryContractsProviderFactory {
    private static final String FACTORY_KEY = ResourceLibraryContractsProviderFactory.class.getName();

    public static ResourceLibraryContractsProviderFactory getFacesConfigResourceProviderFactory(ExternalContext ctx) {
        ResourceLibraryContractsProviderFactory instance = (ResourceLibraryContractsProviderFactory)ctx.getApplicationMap().get(FACTORY_KEY);
        if (instance != null) {
            return instance;
        }
        ResourceLibraryContractsProviderFactory lpf = null;
        try {
            if (System.getSecurityManager() != null) {
                ExternalContext ectx = ctx;
                lpf = (ResourceLibraryContractsProviderFactory)AccessController.doPrivileged(() -> SpiUtils.build(ectx, ResourceLibraryContractsProviderFactory.class, DefaultResourceLibraryContractsProviderFactory.class));
            } else {
                lpf = (ResourceLibraryContractsProviderFactory)SpiUtils.build(ctx, ResourceLibraryContractsProviderFactory.class, DefaultResourceLibraryContractsProviderFactory.class);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException((Throwable)pae);
        }
        if (lpf != null) {
            ResourceLibraryContractsProviderFactory.setResourceLibraryContractsProviderFactory(ctx, lpf);
        }
        return lpf;
    }

    public static void setResourceLibraryContractsProviderFactory(ExternalContext ctx, ResourceLibraryContractsProviderFactory instance) {
        ctx.getApplicationMap().put(FACTORY_KEY, instance);
    }

    public abstract ResourceLibraryContractsProvider createResourceLibraryContractsProvider(ExternalContext var1);
}

