/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.FacesWrapper;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewVisitOption;
import javax.faces.component.ActionSource2;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIPanel;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.MethodExpressionActionListener;
import javax.faces.event.MethodExpressionValueChangeListener;
import javax.faces.event.PhaseId;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PostRestoreStateEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.render.RenderKit;
import javax.faces.render.ResponseStateManager;
import javax.faces.validator.MethodExpressionValidator;
import javax.faces.validator.Validator;
import javax.faces.view.ActionSource2AttachedObjectHandler;
import javax.faces.view.ActionSource2AttachedObjectTarget;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.AttachedObjectTarget;
import javax.faces.view.BehaviorHolderAttachedObjectHandler;
import javax.faces.view.BehaviorHolderAttachedObjectTarget;
import javax.faces.view.EditableValueHolderAttachedObjectHandler;
import javax.faces.view.EditableValueHolderAttachedObjectTarget;
import javax.faces.view.StateManagementStrategy;
import javax.faces.view.ValueHolderAttachedObjectHandler;
import javax.faces.view.ValueHolderAttachedObjectTarget;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewMetadata;
import javax.faces.view.facelets.Facelet;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.ResourceResolver;
import org.apache.myfaces.application.StateManagerImpl;
import org.apache.myfaces.application.ViewIdSupport;
import org.apache.myfaces.component.visit.MyFacesVisitHints;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.util.WebConfigParamUtils;
import org.apache.myfaces.util.lang.Assert;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.util.lang.StringUtils;
import org.apache.myfaces.view.ViewDeclarationLanguageStrategy;
import org.apache.myfaces.view.ViewMetadataBase;
import org.apache.myfaces.view.facelets.AbstractFacelet;
import org.apache.myfaces.view.facelets.DefaultFaceletsStateManagementStrategy;
import org.apache.myfaces.view.facelets.DynamicComponentRefreshTransientBuildEvent;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.FaceletDynamicComponentRefreshTransientBuildEvent;
import org.apache.myfaces.view.facelets.FaceletFactory;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguageBase;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguageStrategy;
import org.apache.myfaces.view.facelets.FaceletsVDLUtils;
import org.apache.myfaces.view.facelets.PublishDynamicComponentRefreshTransientBuildCallback;
import org.apache.myfaces.view.facelets.StateWriter;
import org.apache.myfaces.view.facelets.ViewPoolProcessor;
import org.apache.myfaces.view.facelets.compiler.Compiler;
import org.apache.myfaces.view.facelets.compiler.FaceletsCompilerSupport;
import org.apache.myfaces.view.facelets.compiler.RefreshDynamicComponentListener;
import org.apache.myfaces.view.facelets.compiler.SAXCompiler;
import org.apache.myfaces.view.facelets.el.CompositeComponentELUtils;
import org.apache.myfaces.view.facelets.el.LocationMethodExpression;
import org.apache.myfaces.view.facelets.el.LocationValueExpression;
import org.apache.myfaces.view.facelets.el.MethodExpressionMethodExpression;
import org.apache.myfaces.view.facelets.el.RedirectMethodExpressionValueExpressionActionListener;
import org.apache.myfaces.view.facelets.el.RedirectMethodExpressionValueExpressionValidator;
import org.apache.myfaces.view.facelets.el.RedirectMethodExpressionValueExpressionValueChangeListener;
import org.apache.myfaces.view.facelets.el.ValueExpressionMethodExpression;
import org.apache.myfaces.view.facelets.el.VariableMapperWrapper;
import org.apache.myfaces.view.facelets.impl.DefaultFaceletFactory;
import org.apache.myfaces.view.facelets.impl.DefaultResourceResolver;
import org.apache.myfaces.view.facelets.impl.SectionUniqueIdCounter;
import org.apache.myfaces.view.facelets.pool.RestoreViewFromPoolResult;
import org.apache.myfaces.view.facelets.pool.ViewEntry;
import org.apache.myfaces.view.facelets.pool.ViewPool;
import org.apache.myfaces.view.facelets.pool.ViewStructureMetadata;
import org.apache.myfaces.view.facelets.tag.composite.ClientBehaviorAttachedObjectTarget;
import org.apache.myfaces.view.facelets.tag.composite.ClientBehaviorRedirectBehaviorAttachedObjectHandlerWrapper;
import org.apache.myfaces.view.facelets.tag.composite.ClientBehaviorRedirectEventComponentWrapper;
import org.apache.myfaces.view.facelets.tag.composite.CreateDynamicCompositeComponentListener;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;
import org.apache.myfaces.view.facelets.tag.jsf.PartialMethodExpressionActionListener;
import org.apache.myfaces.view.facelets.tag.jsf.PartialMethodExpressionValidator;
import org.apache.myfaces.view.facelets.tag.jsf.PartialMethodExpressionValueChangeListener;
import org.apache.myfaces.view.facelets.tag.ui.UIDebug;
import org.apache.myfaces.view.facelets.util.FaceletsTemplateMappingUtils;
import org.apache.myfaces.view.facelets.util.FaceletsViewDeclarationLanguageUtils;

public class FaceletViewDeclarationLanguage
extends FaceletViewDeclarationLanguageBase {
    private static final Logger log = Logger.getLogger(FaceletViewDeclarationLanguage.class.getName());
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Class<?>[] VALUE_CHANGE_LISTENER_SIGNATURE = new Class[]{ValueChangeEvent.class};
    private static final Class<?>[] ACTION_LISTENER_SIGNATURE = new Class[]{ActionEvent.class};
    private static final Class<?>[] VALIDATOR_SIGNATURE = new Class[]{FacesContext.class, UIComponent.class, Object.class};
    public static final long DEFAULT_REFRESH_PERIOD = 0L;
    public static final long DEFAULT_REFRESH_PERIOD_PRODUCTION = -1L;
    public static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    public static final String PARAM_ENCODING = "facelets.Encoding";
    public static final String BUILDING_VIEW_METADATA = "org.apache.myfaces.BUILDING_VIEW_METADATA";
    public static final String REFRESHING_TRANSIENT_BUILD = "org.apache.myfaces.REFRESHING_TRANSIENT_BUILD";
    public static final String REFRESH_TRANSIENT_BUILD_ON_PSS = "org.apache.myfaces.REFRESH_TRANSIENT_BUILD_ON_PSS";
    public static final String USING_PSS_ON_THIS_VIEW = "org.apache.myfaces.USING_PSS_ON_THIS_VIEW";
    public static final String REMOVING_COMPONENTS_BUILD = "org.apache.myfaces.REMOVING_COMPONENTS_BUILD";
    public static final String DYN_WRAPPER = "oam.vf.DYN_WRAPPER";
    public static final String GEN_MARK_ID = "oam.vf.GEN_MARK_ID";
    public static final String MARK_INITIAL_STATE_KEY = "org.apache.myfaces.MARK_INITIAL_STATE";
    public static final String IS_BUILDING_INITIAL_STATE_KEY_ALIAS = "javax.faces.view.ViewDeclarationLanguage.IS_BUILDING_INITIAL_STATE";
    public static final String CLEAN_TRANSIENT_BUILD_ON_RESTORE = "org.apache.myfaces.CLEAN_TRANSIENT_BUILD_ON_RESTORE";
    private static final String STATE_KEY = "<!--@@JSF_FORM_STATE_MARKER@@-->";
    private static final int STATE_KEY_LEN = "<!--@@JSF_FORM_STATE_MARKER@@-->".length();
    private static final String SERIALIZED_VIEW_REQUEST_ATTR = StateManagerImpl.class.getName() + ".SERIALIZED_VIEW";
    public static final String CACHED_COMPONENT_IDS = "oam.CACHED_COMPONENT_IDS";
    private static final String ASTERISK = "*";
    private final FaceletFactory faceletFactory;
    private final ViewDeclarationLanguageStrategy strategy;
    private final FaceletsCompilerSupport faceletsCompilerSupport;
    private final MyfacesConfig config;
    private final ViewPoolProcessor viewPoolProcessor;
    private final ViewIdSupport viewIdSupport;
    private StateManagementStrategy stateManagementStrategy;
    private Set<String> fullStateSavingViewIds;
    private ResourceResolver _resourceResolver;
    private Map<String, List<String>> _contractMappings;
    private List<String> _prefixWildcardKeys;

    public FaceletViewDeclarationLanguage(FacesContext context) {
        this(context, new FaceletViewDeclarationLanguageStrategy());
    }

    public FaceletViewDeclarationLanguage(FacesContext context, ViewDeclarationLanguageStrategy strategy) {
        log.finest("Initializing");
        this.config = MyfacesConfig.getCurrentInstance(context);
        this.strategy = strategy;
        this.viewPoolProcessor = ViewPoolProcessor.getInstance(context);
        this.viewIdSupport = ViewIdSupport.getInstance(context);
        this.faceletsCompilerSupport = new FaceletsCompilerSupport();
        Compiler compiler = this.createCompiler(context);
        this.faceletFactory = this.createFaceletFactory(context, compiler);
        if (this.config.isPartialStateSaving()) {
            this.stateManagementStrategy = new DefaultFaceletsStateManagementStrategy(context);
        }
        ExternalContext externalContext = context.getExternalContext();
        String[] fullStateSavingViewIds = this.config.getFullStateSavingViewIds();
        if (fullStateSavingViewIds != null && fullStateSavingViewIds.length > 0) {
            this.fullStateSavingViewIds = new HashSet<String>(fullStateSavingViewIds.length, 1.0f);
            Collections.addAll(this.fullStateSavingViewIds, fullStateSavingViewIds);
        }
        this._initializeContractMappings(externalContext);
        if (this.config.getComponentUniqueIdsCacheSize() > 0) {
            String[] componentIdsCached = SectionUniqueIdCounter.generateUniqueIdCache("_", this.config.getComponentUniqueIdsCacheSize());
            externalContext.getApplicationMap().put(CACHED_COMPONENT_IDS, componentIdsCached);
        }
        log.finest("Initialization Successful");
    }

    @Override
    public String getId() {
        return "java.faces.Facelets";
    }

    @Override
    public boolean viewExists(FacesContext facesContext, String viewId) {
        if (this.strategy.handles(viewId)) {
            if (this._resourceResolver instanceof DefaultResourceResolver) {
                return ((DefaultResourceResolver)this._resourceResolver).resolveUrl(facesContext, viewId) != null;
            }
            return this._resourceResolver.resolveUrl(viewId) != null;
        }
        return false;
    }

    private RestoreViewFromPoolResult tryRestoreViewFromCache(FacesContext context, UIViewRoot view) {
        ViewEntry entry;
        ViewStructureMetadata metadata;
        ViewPool viewPool;
        if (this.viewPoolProcessor != null && (viewPool = this.viewPoolProcessor.getViewPool(context, view)) != null && (metadata = viewPool.retrieveStaticViewStructureMetadata(context, view)) != null && (entry = viewPool.popStaticOrPartialStructureView(context, view)) != null) {
            this.viewPoolProcessor.cloneAndRestoreView(context, view, entry, metadata);
            return entry.getResult();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildView(FacesContext context, UIViewRoot view) throws IOException {
        RestoreViewFromPoolResult result;
        if (this.isFilledView(context, view) && (view == null || !FaceletViewDeclarationLanguageBase.isDynamicComponentRefreshTransientBuildActive(context, view))) {
            return;
        }
        String viewId = view.getViewId();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Building View: " + viewId);
        }
        boolean usePartialStateSavingOnThisView = this._usePartialStateSavingOnThisView(viewId);
        boolean refreshTransientBuild = view.getChildCount() > 0;
        boolean refreshTransientBuildOnPSS = usePartialStateSavingOnThisView && this.config.isRefreshTransientBuildOnPSS();
        boolean refreshPartialView = false;
        if (this.viewPoolProcessor != null && !refreshTransientBuild && (result = this.tryRestoreViewFromCache(context, view)) != null) {
            if (RestoreViewFromPoolResult.COMPLETE.equals((Object)result)) {
                if (!PhaseId.RESTORE_VIEW.equals(context.getCurrentPhaseId())) {
                    ((DefaultFaceletsStateManagementStrategy)this.getStateManagementStrategy(context, view.getViewId())).suscribeListeners(view);
                }
                if (!refreshTransientBuildOnPSS) {
                    this.setFilledView(context, view);
                } else if (this.config.isRefreshTransientBuildOnPSSAuto() && !context.getAttributes().containsKey(CLEAN_TRANSIENT_BUILD_ON_RESTORE)) {
                    this.setFilledView(context, view);
                }
                return;
            }
            refreshTransientBuild = true;
            refreshPartialView = true;
        }
        if (usePartialStateSavingOnThisView) {
            if (view.getId() == null) {
                view.setId(view.createUniqueId(context, null));
            }
            context.getAttributes().put(USING_PSS_ON_THIS_VIEW, Boolean.TRUE);
            if (!refreshTransientBuild || refreshPartialView) {
                context.getAttributes().put("javax.faces.IS_BUILDING_INITIAL_STATE", Boolean.TRUE);
                context.getAttributes().put(IS_BUILDING_INITIAL_STATE_KEY_ALIAS, Boolean.TRUE);
            }
            if (!refreshTransientBuild && this.config.isMarkInitialStateWhenApplyBuildView()) {
                context.getAttributes().put(MARK_INITIAL_STATE_KEY, Boolean.TRUE);
            }
            if (refreshTransientBuildOnPSS) {
                context.getAttributes().put(REFRESH_TRANSIENT_BUILD_ON_PSS, this.config.isRefreshTransientBuildOnPSSAuto() ? "auto" : "true");
            }
        }
        try {
            if (refreshTransientBuild) {
                context.getAttributes().put(REFRESHING_TRANSIENT_BUILD, Boolean.TRUE);
            }
            this._getFacelet(context, viewId).apply(context, view);
        }
        finally {
            if (refreshTransientBuildOnPSS) {
                context.getAttributes().remove(REFRESH_TRANSIENT_BUILD_ON_PSS);
            }
            if (refreshTransientBuild) {
                if (FaceletViewDeclarationLanguageBase.isDynamicComponentRefreshTransientBuildActive(context)) {
                    VisitContext visitContext = this.getVisitContextFactory().getVisitContext(context, null, MyFacesVisitHints.SET_SKIP_ITERATION);
                    view.visitTree(visitContext, PublishDynamicComponentRefreshTransientBuildCallback.INSTANCE);
                }
                if (!usePartialStateSavingOnThisView || refreshTransientBuildOnPSS) {
                    // empty if block
                }
                context.getAttributes().remove(REFRESHING_TRANSIENT_BUILD);
            } else {
                context.getApplication().publishEvent(context, PostAddToViewEvent.class, UIViewRoot.class, view);
            }
        }
        if (refreshTransientBuild) {
            this.setFilledView(context, view);
        } else if (!refreshTransientBuildOnPSS) {
            this.setFilledView(context, view);
        } else if (this.config.isRefreshTransientBuildOnPSSAuto() && !context.getAttributes().containsKey(CLEAN_TRANSIENT_BUILD_ON_RESTORE)) {
            this.setFilledView(context, view);
        }
        if (usePartialStateSavingOnThisView) {
            if (!refreshTransientBuild || refreshPartialView) {
                if (this.viewPoolProcessor != null && this.viewPoolProcessor.isViewPoolEnabledForThisView(context, view)) {
                    this.viewPoolProcessor.storeViewStructureMetadata(context, view);
                }
                if (this.config.isMarkInitialStateWhenApplyBuildView()) {
                    if (!refreshTransientBuildOnPSS || !view.getAttributes().containsKey("oam.COMPONENT_ADDED_AFTER_BUILD_VIEW")) {
                        view.markInitialState();
                    }
                    context.getAttributes().remove(MARK_INITIAL_STATE_KEY);
                } else {
                    context.getAttributes().put(MARK_INITIAL_STATE_KEY, Boolean.TRUE);
                    this._markInitialStateOnView(view, refreshTransientBuildOnPSS);
                    context.getAttributes().remove(MARK_INITIAL_STATE_KEY);
                }
                context.getAttributes().remove("javax.faces.IS_BUILDING_INITIAL_STATE");
                context.getAttributes().remove(IS_BUILDING_INITIAL_STATE_KEY_ALIAS);
            }
            if (!(refreshTransientBuild && PhaseId.RESTORE_VIEW.equals(context.getCurrentPhaseId()) || view.isTransient())) {
                ((DefaultFaceletsStateManagementStrategy)this.getStateManagementStrategy(context, view.getViewId())).suscribeListeners(view);
            }
            context.getAttributes().remove(USING_PSS_ON_THIS_VIEW);
        }
        context.getAttributes().remove("org.apache.myfaces.STANDARD_JSF_AJAX_LIBRARY_LOADED");
    }

    private void _markInitialStateOnView(UIViewRoot view, boolean refreshTransientBuildOnPSS) {
        int childCount;
        if (!(refreshTransientBuildOnPSS && view.getAttributes().containsKey("oam.COMPONENT_ADDED_AFTER_BUILD_VIEW") || view.isTransient())) {
            view.markInitialState();
        }
        if ((childCount = view.getChildCount()) > 0) {
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = view.getChildren().get(i);
                if (child.isTransient()) continue;
                this._markInitialState(child);
            }
        }
        if (view.getFacetCount() > 0) {
            Map<String, UIComponent> facetMap = view.getFacets();
            for (Map.Entry<String, UIComponent> entry : facetMap.entrySet()) {
                UIComponent child = entry.getValue();
                if (child.isTransient()) continue;
                this._markInitialState(child);
            }
        }
    }

    private void _markInitialState(UIComponent component) {
        component.markInitialState();
        int childCount = component.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = component.getChildren().get(i);
                if (child.isTransient()) continue;
                this._markInitialState(child);
            }
        }
        if (component.getFacetCount() > 0) {
            Map<String, UIComponent> facetMap = component.getFacets();
            for (Map.Entry<String, UIComponent> entry : facetMap.entrySet()) {
                UIComponent child = entry.getValue();
                if (child.isTransient()) continue;
                this._markInitialState(child);
            }
        }
    }

    private boolean isFilledView(FacesContext context, UIViewRoot view) {
        return context.getAttributes().containsKey(view);
    }

    private void setFilledView(FacesContext context, UIViewRoot view) {
        context.getAttributes().put(view, Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeanInfo getComponentMetadata(FacesContext context, Resource componentResource) {
        BeanInfo beanInfo = null;
        Assert.notNull(context, "context");
        try {
            Facelet compositeComponentFacelet;
            FaceletFactory.setInstance(this.faceletFactory);
            try {
                compositeComponentFacelet = this.faceletFactory.getCompositeComponentMetadataFacelet(componentResource.getURL());
            }
            finally {
                FaceletFactory.setInstance(null);
            }
            UINamingContainer compositeComponentBase = (UINamingContainer)context.getApplication().createComponent(context, "javax.faces.NamingContainer", null);
            compositeComponentBase.getAttributes().put("javax.faces.application.Resource.ComponentResource", componentResource);
            FaceletContext faceletContext = (FaceletContext)((Object)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY));
            VariableMapper orig = faceletContext.getVariableMapper();
            try {
                faceletContext.setVariableMapper(new VariableMapperWrapper(orig));
                compositeComponentBase.pushComponentToEL(context, compositeComponentBase);
                compositeComponentFacelet.apply(context, compositeComponentBase);
                compositeComponentBase.popComponentFromEL(context);
            }
            finally {
                faceletContext.setVariableMapper(orig);
            }
            beanInfo = (BeanInfo)compositeComponentBase.getAttributes().get("javax.faces.component.BEANINFO_KEY");
        }
        catch (IOException e) {
            throw new FacesException(e);
        }
        return beanInfo;
    }

    public static boolean isBuildingViewMetadata(FacesContext context) {
        return context.getAttributes().containsKey(BUILDING_VIEW_METADATA);
    }

    public static boolean isRefreshingTransientBuild(FacesContext context) {
        return context.getAttributes().containsKey(REFRESHING_TRANSIENT_BUILD);
    }

    public static boolean isRemovingComponentBuild(FacesContext context) {
        return context.getAttributes().containsKey(REMOVING_COMPONENTS_BUILD);
    }

    public static boolean isMarkInitialState(FacesContext context) {
        return Boolean.TRUE.equals(context.getAttributes().get(MARK_INITIAL_STATE_KEY));
    }

    public static boolean isRefreshTransientBuildOnPSS(FacesContext context) {
        return context.getAttributes().containsKey(REFRESH_TRANSIENT_BUILD_ON_PSS);
    }

    public static boolean isRefreshTransientBuildOnPSSAuto(FacesContext context) {
        return "auto".equalsIgnoreCase((String)context.getAttributes().get(REFRESH_TRANSIENT_BUILD_ON_PSS));
    }

    public static boolean isCleanTransientBuildOnRestore(FacesContext context) {
        return context.getAttributes().containsKey(CLEAN_TRANSIENT_BUILD_ON_RESTORE);
    }

    public static void cleanTransientBuildOnRestore(FacesContext context) {
        context.getAttributes().put(CLEAN_TRANSIENT_BUILD_ON_RESTORE, Boolean.TRUE);
    }

    public static boolean isUsingPSSOnThisView(FacesContext context) {
        return context.getAttributes().containsKey(USING_PSS_ON_THIS_VIEW);
    }

    @Override
    public void retargetAttachedObjects(FacesContext context, UIComponent topLevelComponent, List<AttachedObjectHandler> handlerList) {
        Assert.notNull(context, "context");
        Assert.notNull(topLevelComponent, "topLevelComponent");
        Assert.notNull(handlerList, "handlerList");
        BeanInfo compositeComponentMetadata = (BeanInfo)topLevelComponent.getAttributes().get("javax.faces.component.BEANINFO_KEY");
        if (compositeComponentMetadata == null) {
            log.severe("Composite component metadata not found for: " + topLevelComponent.getClientId(context));
            return;
        }
        BeanDescriptor compositeComponentDescriptor = compositeComponentMetadata.getBeanDescriptor();
        List targetList = (List)compositeComponentDescriptor.getValue("javax.faces.view.AttachedObjectTargets");
        if (targetList == null || targetList.isEmpty()) {
            return;
        }
        int size = handlerList.size();
        for (int i = 0; i < size; ++i) {
            AttachedObjectHandler currentHandler = handlerList.get(i);
            String forValue = currentHandler.getFor();
            int targetsSize = targetList.size();
            for (int k = 0; k < targetsSize; ++k) {
                AttachedObjectTarget currentTarget = (AttachedObjectTarget)targetList.get(k);
                FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance();
                if (forValue != null && forValue.equals(currentTarget.getName()) && (currentTarget instanceof ActionSource2AttachedObjectTarget && currentHandler instanceof ActionSource2AttachedObjectHandler || currentTarget instanceof EditableValueHolderAttachedObjectTarget && currentHandler instanceof EditableValueHolderAttachedObjectHandler || currentTarget instanceof ValueHolderAttachedObjectTarget && currentHandler instanceof ValueHolderAttachedObjectHandler)) {
                    List<UIComponent> targets = currentTarget.getTargets(topLevelComponent);
                    int targetsCount = targets.size();
                    for (int l = 0; l < targetsCount; ++l) {
                        UIComponent component = targets.get(l);
                        if (UIComponent.isCompositeComponent(component)) {
                            mctx.addAttachedObjectHandler(component, currentHandler);
                            List<AttachedObjectHandler> handlers = mctx.getAttachedObjectHandlers(component);
                            this.retargetAttachedObjects(context, component, handlers);
                            handlers.remove(currentHandler);
                        } else {
                            currentHandler.applyAttachedObject(context, component);
                        }
                        if (!mctx.isUsingPSSOnThisView() || !mctx.isMarkInitialState()) continue;
                        component.markInitialState();
                    }
                    continue;
                }
                if (!(currentTarget instanceof BehaviorHolderAttachedObjectTarget) || !(currentHandler instanceof BehaviorHolderAttachedObjectHandler)) continue;
                String eventName = ((BehaviorHolderAttachedObjectHandler)currentHandler).getEventName();
                boolean isDefaultEvent = ((BehaviorHolderAttachedObjectTarget)currentTarget).isDefaultEvent();
                if ((eventName == null || !eventName.equals(currentTarget.getName())) && (eventName != null || !isDefaultEvent)) continue;
                List<UIComponent> targets = currentTarget.getTargets(topLevelComponent);
                int targetssize = targets.size();
                for (int j = 0; j < targetssize; ++j) {
                    UIComponent component = targets.get(j);
                    if (UIComponent.isCompositeComponent(component)) {
                        if (currentTarget instanceof ClientBehaviorAttachedObjectTarget) {
                            mctx.addAttachedObjectHandler(component, new ClientBehaviorRedirectBehaviorAttachedObjectHandlerWrapper((BehaviorHolderAttachedObjectHandler)currentHandler, ((ClientBehaviorAttachedObjectTarget)currentTarget).getEvent()));
                        } else {
                            mctx.addAttachedObjectHandler(component, currentHandler);
                        }
                        List<AttachedObjectHandler> handlers = mctx.getAttachedObjectHandlers(component);
                        this.retargetAttachedObjects(context, component, handlers);
                        handlers.remove(currentHandler);
                    } else if (currentHandler instanceof ClientBehaviorRedirectBehaviorAttachedObjectHandlerWrapper) {
                        currentHandler.applyAttachedObject(context, new ClientBehaviorRedirectEventComponentWrapper(component, ((ClientBehaviorRedirectBehaviorAttachedObjectHandlerWrapper)currentHandler).getWrappedEventName(), eventName));
                    } else {
                        currentHandler.applyAttachedObject(context, component);
                    }
                    if (!mctx.isUsingPSSOnThisView() || !mctx.isMarkInitialState()) continue;
                    component.markInitialState();
                }
            }
        }
    }

    @Override
    public void retargetMethodExpressions(FacesContext context, UIComponent topLevelComponent) {
        Assert.notNull(context, "context");
        BeanInfo compositeComponentMetadata = (BeanInfo)topLevelComponent.getAttributes().get("javax.faces.component.BEANINFO_KEY");
        if (compositeComponentMetadata == null) {
            log.severe("Composite component metadata not found for: " + topLevelComponent.getClientId(context));
            return;
        }
        PropertyDescriptor[] propertyDescriptors = compositeComponentMetadata.getPropertyDescriptors();
        ELContext elContext = (ELContext)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            FaceletCompositionContext mctx;
            boolean isKnownTargetAttributeMethod;
            if (propertyDescriptor.getValue("type") != null) continue;
            String attributeName = propertyDescriptor.getName();
            ValueExpression methodSignatureExpression = (ValueExpression)propertyDescriptor.getValue("method-signature");
            String methodSignature = null;
            if (methodSignatureExpression != null) {
                methodSignature = (String)methodSignatureExpression.getValue(elContext);
            }
            String targetAttributeName = null;
            ValueExpression targetAttributeNameVE = (ValueExpression)propertyDescriptor.getValue("targetAttributeName");
            if (targetAttributeNameVE != null) {
                targetAttributeName = (String)targetAttributeNameVE.getValue(context.getELContext());
                if (targetAttributeName == null) {
                    targetAttributeName = attributeName;
                }
            } else {
                targetAttributeName = attributeName;
            }
            boolean bl = isKnownTargetAttributeMethod = "action".equals(targetAttributeName) || "actionListener".equals(targetAttributeName) || "validator".equals(targetAttributeName) || "valueChangeListener".equals(targetAttributeName);
            if (!isKnownTargetAttributeMethod && methodSignature == null) continue;
            ValueExpression targetsExpression = (ValueExpression)propertyDescriptor.getValue("targets");
            String targets = null;
            if (targetsExpression != null) {
                targets = (String)targetsExpression.getValue(elContext);
            }
            if (targets == null) {
                targets = attributeName;
            }
            if (!(mctx = FaceletCompositionContext.getCurrentInstance()).isMethodExpressionAttributeApplied(topLevelComponent, attributeName)) {
                boolean ccAttrMeRedirection;
                ValueExpression attributeNameValueExpression = (ValueExpression)topLevelComponent.getAttributes().get(attributeName);
                if (attributeNameValueExpression == null && (attributeNameValueExpression = (ValueExpression)propertyDescriptor.getValue("default")) == null) {
                    Object requiredValue;
                    Boolean required;
                    ValueExpression ve = (ValueExpression)propertyDescriptor.getValue("required");
                    if (ve == null || (required = (requiredValue = ve.getValue(elContext)) instanceof Boolean ? (Boolean)requiredValue : Boolean.valueOf(requiredValue.toString())) == null || !required.booleanValue() || !log.isLoggable(Level.SEVERE)) continue;
                    log.severe("attributeValueExpression not found under the key \"" + attributeName + "\". Looking for the next attribute");
                    continue;
                }
                String[] targetsArray = StringUtils.splitShortString(targets, ' ');
                String attributeExpressionString = attributeNameValueExpression.getExpressionString();
                boolean bl2 = ccAttrMeRedirection = attributeNameValueExpression instanceof LocationValueExpression && CompositeComponentELUtils.isCompositeComponentAttrsMethodExpression(attributeNameValueExpression.getExpressionString());
                if (isKnownTargetAttributeMethod) {
                    if ("action".equals(targetAttributeName)) {
                        this.applyActionMethodExpressionEL(context, elContext, topLevelComponent, attributeName, attributeExpressionString, attributeNameValueExpression, ccAttrMeRedirection);
                    } else if ("actionListener".equals(targetAttributeName)) {
                        this.applyActionListenerMethodExpressionEL(context, elContext, topLevelComponent, attributeName, attributeExpressionString, attributeNameValueExpression, ccAttrMeRedirection);
                    } else if ("validator".equals(targetAttributeName)) {
                        this.applyValidatorMethodExpressionEL(context, elContext, topLevelComponent, attributeName, attributeExpressionString, attributeNameValueExpression, ccAttrMeRedirection);
                    } else if ("valueChangeListener".equals(targetAttributeName)) {
                        this.applyValueChangeListenerMethodExpressionEL(context, elContext, topLevelComponent, attributeName, attributeExpressionString, attributeNameValueExpression, ccAttrMeRedirection);
                    }
                    UIComponent topLevelComponentBase = topLevelComponent.getFacet("javax.faces.component.COMPOSITE_FACET_NAME");
                    for (String target : targetsArray) {
                        UIComponent innerComponent = ComponentSupport.findComponentChildOrFacetFrom(context, topLevelComponentBase, target);
                        if (innerComponent == null) continue;
                        if (this.isCompositeComponentRetarget(context, innerComponent, targetAttributeName)) {
                            innerComponent.getAttributes().put(targetAttributeName, attributeNameValueExpression);
                            mctx.clearMethodExpressionAttribute(innerComponent, targetAttributeName);
                            this.retargetMethodExpressions(context, innerComponent);
                            if (!mctx.isUsingPSSOnThisView() || !mctx.isMarkInitialState()) continue;
                            innerComponent.markInitialState();
                            continue;
                        }
                        if ("action".equals(targetAttributeName)) {
                            this.applyActionMethodExpressionTarget(context, mctx, elContext, topLevelComponentBase, innerComponent, attributeName, targetAttributeName, attributeExpressionString, attributeNameValueExpression, ccAttrMeRedirection);
                            if (!mctx.isUsingPSSOnThisView() || !mctx.isMarkInitialState()) continue;
                            innerComponent.markInitialState();
                            continue;
                        }
                        if ("actionListener".equals(targetAttributeName)) {
                            this.applyActionListenerMethodExpressionTarget(context, mctx, elContext, topLevelComponentBase, innerComponent, attributeName, targetAttributeName, attributeExpressionString, attributeNameValueExpression, ccAttrMeRedirection);
                            if (!mctx.isUsingPSSOnThisView() || !mctx.isMarkInitialState()) continue;
                            innerComponent.markInitialState();
                            continue;
                        }
                        if ("validator".equals(targetAttributeName)) {
                            this.applyValidatorMethodExpressionTarget(context, mctx, elContext, topLevelComponentBase, innerComponent, attributeName, targetAttributeName, attributeExpressionString, attributeNameValueExpression, ccAttrMeRedirection);
                            if (!mctx.isUsingPSSOnThisView() || !mctx.isMarkInitialState()) continue;
                            innerComponent.markInitialState();
                            continue;
                        }
                        if (!"valueChangeListener".equals(targetAttributeName)) continue;
                        this.applyValueChangeListenerMethodExpressionTarget(context, mctx, elContext, topLevelComponentBase, innerComponent, attributeName, targetAttributeName, attributeExpressionString, attributeNameValueExpression, ccAttrMeRedirection);
                        if (!mctx.isUsingPSSOnThisView() || !mctx.isMarkInitialState()) continue;
                        innerComponent.markInitialState();
                    }
                } else {
                    MethodExpression methodExpression = null;
                    methodSignature = methodSignature.trim();
                    methodExpression = context.getApplication().getExpressionFactory().createMethodExpression(elContext, attributeExpressionString, FaceletsViewDeclarationLanguageUtils.getReturnType(methodSignature), FaceletsViewDeclarationLanguageUtils.getParameters(methodSignature));
                    methodExpression = this.reWrapMethodExpression(methodExpression, attributeNameValueExpression);
                    this.applyMethodExpression(context, mctx, topLevelComponent, attributeName, targetAttributeName, attributeNameValueExpression, methodExpression, ccAttrMeRedirection, targetsArray);
                }
                mctx.markMethodExpressionAttribute(topLevelComponent, attributeName);
            }
            topLevelComponent.setValueExpression(attributeName, null);
        }
    }

    private void applyActionMethodExpressionEL(FacesContext context, ELContext elContext, UIComponent topLevelComponent, String attributeName, String attributeExpressionString, ValueExpression attributeNameValueExpression, boolean ccAttrMeRedirection) {
        MethodExpression methodExpression = this.reWrapMethodExpression(context.getApplication().getExpressionFactory().createMethodExpression(elContext, attributeExpressionString, null, (Class[])EMPTY_CLASS_ARRAY), attributeNameValueExpression);
        if (!ccAttrMeRedirection) {
            topLevelComponent.getAttributes().put(attributeName, methodExpression);
        }
    }

    private void applyActionListenerMethodExpressionEL(FacesContext context, ELContext elContext, UIComponent topLevelComponent, String attributeName, String attributeExpressionString, ValueExpression attributeNameValueExpression, boolean ccAttrMeRedirection) {
        MethodExpression methodExpression = this.reWrapMethodExpression(context.getApplication().getExpressionFactory().createMethodExpression(elContext, attributeExpressionString, Void.TYPE, (Class[])ACTION_LISTENER_SIGNATURE), attributeNameValueExpression);
        MethodExpression methodExpression2 = this.reWrapMethodExpression(context.getApplication().getExpressionFactory().createMethodExpression(elContext, attributeExpressionString, Void.TYPE, (Class[])EMPTY_CLASS_ARRAY), attributeNameValueExpression);
        if (!ccAttrMeRedirection) {
            topLevelComponent.getAttributes().put(attributeName, new MethodExpressionMethodExpression(methodExpression, methodExpression2));
        }
    }

    private void applyValidatorMethodExpressionEL(FacesContext context, ELContext elContext, UIComponent topLevelComponent, String attributeName, String attributeExpressionString, ValueExpression attributeNameValueExpression, boolean ccAttrMeRedirection) {
        MethodExpression methodExpression = this.reWrapMethodExpression(context.getApplication().getExpressionFactory().createMethodExpression(elContext, attributeExpressionString, Void.TYPE, (Class[])VALIDATOR_SIGNATURE), attributeNameValueExpression);
        if (!ccAttrMeRedirection) {
            topLevelComponent.getAttributes().put(attributeName, methodExpression);
        }
    }

    private void applyValueChangeListenerMethodExpressionEL(FacesContext context, ELContext elContext, UIComponent topLevelComponent, String attributeName, String attributeExpressionString, ValueExpression attributeNameValueExpression, boolean ccAttrMeRedirection) {
        MethodExpression methodExpression = this.reWrapMethodExpression(context.getApplication().getExpressionFactory().createMethodExpression(elContext, attributeExpressionString, Void.TYPE, (Class[])VALUE_CHANGE_LISTENER_SIGNATURE), attributeNameValueExpression);
        MethodExpression methodExpression2 = this.reWrapMethodExpression(context.getApplication().getExpressionFactory().createMethodExpression(elContext, attributeExpressionString, Void.TYPE, (Class[])EMPTY_CLASS_ARRAY), attributeNameValueExpression);
        if (!ccAttrMeRedirection) {
            topLevelComponent.getAttributes().put(attributeName, new MethodExpressionMethodExpression(methodExpression, methodExpression2));
        }
    }

    private void applyActionMethodExpressionTarget(FacesContext context, FaceletCompositionContext mctx, ELContext elContext, UIComponent topLevelComponent, UIComponent innerComponent, String attributeName, String targetAttributeName, String attributeExpressionString, ValueExpression attributeNameValueExpression, boolean ccAttrMeRedirection) {
        MethodExpression methodExpression = this.reWrapMethodExpression(context.getApplication().getExpressionFactory().createMethodExpression(elContext, attributeExpressionString, null, (Class[])EMPTY_CLASS_ARRAY), attributeNameValueExpression);
        if (ccAttrMeRedirection) {
            ((ActionSource2)((Object)innerComponent)).setActionExpression(new ValueExpressionMethodExpression(attributeNameValueExpression));
        } else {
            ((ActionSource2)((Object)innerComponent)).setActionExpression(methodExpression);
        }
    }

    private void applyActionListenerMethodExpressionTarget(FacesContext context, FaceletCompositionContext mctx, ELContext elContext, UIComponent topLevelComponent, UIComponent innerComponent, String attributeName, String targetAttributeName, String attributeExpressionString, ValueExpression attributeNameValueExpression, boolean ccAttrMeRedirection) {
        ActionListener o = (ActionListener)mctx.removeMethodExpressionTargeted(innerComponent, targetAttributeName);
        if (o != null) {
            ((ActionSource2)((Object)innerComponent)).removeActionListener(o);
        }
        ActionListener actionListener = null;
        if (ccAttrMeRedirection) {
            actionListener = new RedirectMethodExpressionValueExpressionActionListener(attributeNameValueExpression);
        } else {
            MethodExpression methodExpression = this.reWrapMethodExpression(context.getApplication().getExpressionFactory().createMethodExpression(elContext, attributeExpressionString, Void.TYPE, (Class[])ACTION_LISTENER_SIGNATURE), attributeNameValueExpression);
            MethodExpression methodExpression2 = this.reWrapMethodExpression(context.getApplication().getExpressionFactory().createMethodExpression(elContext, attributeExpressionString, Void.TYPE, (Class[])EMPTY_CLASS_ARRAY), attributeNameValueExpression);
            actionListener = mctx.isUsingPSSOnThisView() ? new PartialMethodExpressionActionListener(methodExpression, methodExpression2) : new MethodExpressionActionListener(methodExpression, methodExpression2);
        }
        ((ActionSource2)((Object)innerComponent)).addActionListener(actionListener);
        mctx.addMethodExpressionTargeted(innerComponent, targetAttributeName, actionListener);
    }

    private void applyValidatorMethodExpressionTarget(FacesContext context, FaceletCompositionContext mctx, ELContext elContext, UIComponent topLevelComponent, UIComponent innerComponent, String attributeName, String targetAttributeName, String attributeExpressionString, ValueExpression attributeNameValueExpression, boolean ccAttrMeRedirection) {
        Validator o = (Validator)mctx.removeMethodExpressionTargeted(innerComponent, targetAttributeName);
        if (o != null) {
            ((EditableValueHolder)((Object)innerComponent)).removeValidator(o);
        }
        Validator validator = null;
        if (ccAttrMeRedirection) {
            validator = new RedirectMethodExpressionValueExpressionValidator(attributeNameValueExpression);
        } else {
            MethodExpression methodExpression = this.reWrapMethodExpression(context.getApplication().getExpressionFactory().createMethodExpression(elContext, attributeExpressionString, Void.TYPE, (Class[])VALIDATOR_SIGNATURE), attributeNameValueExpression);
            validator = mctx.isUsingPSSOnThisView() ? new PartialMethodExpressionValidator(methodExpression) : new MethodExpressionValidator(methodExpression);
        }
        ((EditableValueHolder)((Object)innerComponent)).addValidator(validator);
        mctx.addMethodExpressionTargeted(innerComponent, targetAttributeName, validator);
    }

    private void applyValueChangeListenerMethodExpressionTarget(FacesContext context, FaceletCompositionContext mctx, ELContext elContext, UIComponent topLevelComponent, UIComponent innerComponent, String attributeName, String targetAttributeName, String attributeExpressionString, ValueExpression attributeNameValueExpression, boolean ccAttrMeRedirection) {
        ValueChangeListener o = (ValueChangeListener)mctx.removeMethodExpressionTargeted(innerComponent, targetAttributeName);
        if (o != null) {
            ((EditableValueHolder)((Object)innerComponent)).removeValueChangeListener(o);
        }
        ValueChangeListener valueChangeListener = null;
        if (ccAttrMeRedirection) {
            valueChangeListener = new RedirectMethodExpressionValueExpressionValueChangeListener(attributeNameValueExpression);
        } else {
            MethodExpression methodExpression = this.reWrapMethodExpression(context.getApplication().getExpressionFactory().createMethodExpression(elContext, attributeExpressionString, Void.TYPE, (Class[])VALUE_CHANGE_LISTENER_SIGNATURE), attributeNameValueExpression);
            MethodExpression methodExpression2 = this.reWrapMethodExpression(context.getApplication().getExpressionFactory().createMethodExpression(elContext, attributeExpressionString, Void.TYPE, (Class[])EMPTY_CLASS_ARRAY), attributeNameValueExpression);
            valueChangeListener = mctx.isUsingPSSOnThisView() ? new PartialMethodExpressionValueChangeListener(methodExpression, methodExpression2) : new MethodExpressionValueChangeListener(methodExpression, methodExpression2);
        }
        ((EditableValueHolder)((Object)innerComponent)).addValueChangeListener(valueChangeListener);
        mctx.addMethodExpressionTargeted(innerComponent, targetAttributeName, valueChangeListener);
    }

    private void applyMethodExpression(FacesContext context, FaceletCompositionContext mctx, UIComponent topLevelComponent, String attributeName, String targetAttributeName, ValueExpression attributeNameValueExpression, MethodExpression methodExpression, boolean ccAttrMeRedirection, String[] targetsArray) {
        UIComponent topLevelComponentBase = topLevelComponent.getFacet("javax.faces.component.COMPOSITE_FACET_NAME");
        for (String target : targetsArray) {
            UIComponent innerComponent = ComponentSupport.findComponentChildOrFacetFrom(context, topLevelComponentBase, target);
            if (innerComponent == null) continue;
            if (this.isCompositeComponentRetarget(context, innerComponent, targetAttributeName)) {
                innerComponent.getAttributes().put(targetAttributeName, attributeNameValueExpression);
                mctx.clearMethodExpressionAttribute(innerComponent, targetAttributeName);
                this.retargetMethodExpressions(context, innerComponent);
                if (!mctx.isUsingPSSOnThisView() || !mctx.isMarkInitialState()) continue;
                innerComponent.markInitialState();
                continue;
            }
            if (ccAttrMeRedirection) {
                innerComponent.getAttributes().put(targetAttributeName, new ValueExpressionMethodExpression(attributeNameValueExpression));
            } else {
                innerComponent.getAttributes().put(targetAttributeName, methodExpression);
            }
            if (!mctx.isUsingPSSOnThisView() || !mctx.isMarkInitialState()) continue;
            innerComponent.markInitialState();
        }
        if (!ccAttrMeRedirection) {
            topLevelComponent.getAttributes().put(attributeName, methodExpression);
        }
    }

    private boolean isCompositeComponentRetarget(FacesContext context, UIComponent component, String attributeName) {
        if (UIComponent.isCompositeComponent(component)) {
            BeanInfo compositeComponentMetadata = (BeanInfo)component.getAttributes().get("javax.faces.component.BEANINFO_KEY");
            PropertyDescriptor[] propertyDescriptors = compositeComponentMetadata.getPropertyDescriptors();
            ELContext elContext = (ELContext)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                boolean isKnownTargetAttributeMethod;
                if (propertyDescriptor.getValue("type") != null || !attributeName.equals(propertyDescriptor.getName())) continue;
                ValueExpression methodSignatureExpression = (ValueExpression)propertyDescriptor.getValue("method-signature");
                String methodSignature = null;
                if (methodSignatureExpression != null) {
                    methodSignature = (String)methodSignatureExpression.getValue(elContext);
                }
                String targetAttributeName = null;
                ValueExpression targetAttributeNameVE = (ValueExpression)propertyDescriptor.getValue("targetAttributeName");
                if (targetAttributeNameVE != null) {
                    targetAttributeName = (String)targetAttributeNameVE.getValue(context.getELContext());
                    if (targetAttributeName == null) {
                        targetAttributeName = attributeName;
                    }
                } else {
                    targetAttributeName = attributeName;
                }
                boolean bl = isKnownTargetAttributeMethod = "action".equals(targetAttributeName) || "actionListener".equals(targetAttributeName) || "validator".equals(targetAttributeName) || "valueChangeListener".equals(targetAttributeName);
                if (!isKnownTargetAttributeMethod && methodSignature == null) continue;
                if ("action".equals(targetAttributeName)) {
                    return !(component instanceof ActionSource2);
                }
                if ("actionListener".equals(targetAttributeName)) {
                    return !(component instanceof ActionSource2);
                }
                if ("validator".equals(targetAttributeName)) {
                    return !(component instanceof EditableValueHolder);
                }
                if ("valueChangeListener".equals(targetAttributeName)) {
                    return !(component instanceof EditableValueHolder);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private MethodExpression reWrapMethodExpression(MethodExpression createdMethodExpression, ValueExpression originalValueExpression) {
        if (originalValueExpression instanceof LocationValueExpression) {
            return new LocationMethodExpression(((LocationValueExpression)originalValueExpression).getLocation(), this.reWrapMethodExpression(createdMethodExpression, ((LocationValueExpression)originalValueExpression).getWrapped()), ((LocationValueExpression)originalValueExpression).getCCLevel());
        }
        if (originalValueExpression instanceof FacesWrapper && ((FacesWrapper)originalValueExpression).getWrapped() instanceof ValueExpression) {
            return this.reWrapMethodExpression(createdMethodExpression, (ValueExpression)((FacesWrapper)originalValueExpression).getWrapped());
        }
        return createdMethodExpression;
    }

    @Override
    public Resource getScriptComponentResource(FacesContext context, Resource componentResource) {
        Assert.notNull(context, "context");
        Assert.notNull(componentResource, "componentResource");
        return null;
    }

    @Override
    public StateManagementStrategy getStateManagementStrategy(FacesContext context, String viewId) {
        return this._usePartialStateSavingOnThisView(viewId) ? this.stateManagementStrategy : null;
    }

    @Override
    public ViewMetadata getViewMetadata(FacesContext context, String viewId) {
        Assert.notNull(context, "facesContext");
        Assert.notNull(viewId, "viewId");
        return new FaceletViewMetadata(viewId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderView(FacesContext context, UIViewRoot view) throws IOException {
        block25: {
            if (!view.isRendered()) {
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Rendering View: " + view.getViewId());
            }
            try {
                ResponseWriter origWriter = context.getResponseWriter();
                if (origWriter == null) {
                    origWriter = this.createResponseWriter(context);
                }
                ExternalContext extContext = context.getExternalContext();
                Writer outputWriter = extContext.getResponseOutputWriter();
                StateWriter stateWriter = new StateWriter(outputWriter, 1024, context);
                try (ResponseWriter writer = origWriter.cloneWithWriter(stateWriter);){
                    StateManagementStrategy sms;
                    ViewDeclarationLanguage vdl;
                    context.setResponseWriter(writer);
                    StateManager stateMgr = context.getApplication().getStateManager();
                    writer.startDocument();
                    view.encodeAll(context);
                    writer.endDocument();
                    if (stateWriter.isStateWritten()) {
                        writer.flush();
                        Object stateObj = stateMgr.saveView(context);
                        String content = stateWriter.getAndResetBuffer();
                        int end = content.indexOf(STATE_KEY);
                        if (end >= 0) {
                            int start = 0;
                            while (end != -1) {
                                String stateStr;
                                origWriter.write(content, start, end - start);
                                if (view.isTransient()) {
                                    stateMgr.writeState(context, stateObj);
                                    stateStr = stateWriter.getAndResetBuffer();
                                } else if (stateObj == null) {
                                    stateStr = null;
                                } else {
                                    stateMgr.writeState(context, stateObj);
                                    stateStr = stateWriter.getAndResetBuffer();
                                }
                                if (stateStr != null) {
                                    origWriter.write(stateStr);
                                }
                                start = end + STATE_KEY_LEN;
                                end = content.indexOf(STATE_KEY, start);
                            }
                            origWriter.write(content, start, content.length() - start);
                        } else {
                            origWriter.write(content);
                        }
                        break block25;
                    }
                    if (stateWriter.isStateWrittenWithoutWrapper()) {
                        stateMgr.saveView(context);
                        break block25;
                    }
                    if (this.viewPoolProcessor == null || !this.viewPoolProcessor.isViewPoolEnabledForThisView(context, view) || !"java.faces.Facelets".equals((vdl = context.getApplication().getViewHandler().getViewDeclarationLanguage(context, view.getViewId())).getId()) || (sms = vdl.getStateManagementStrategy(context, view.getId())) == null) break block25;
                    context.getAttributes().put("oam.ViewPool.forceHardReset", Boolean.TRUE);
                    try {
                        Object object = sms.saveView(context);
                    }
                    finally {
                        context.getAttributes().remove("oam.ViewPool.forceHardReset");
                    }
                    context.getAttributes().remove(SERIALIZED_VIEW_REQUEST_ATTR);
                }
                finally {
                    stateWriter.release(context);
                }
            }
            catch (FileNotFoundException e) {
                this.handleFaceletNotFound(context, view.getViewId());
            }
            catch (Exception e) {
                this.handleRenderException(context, e);
            }
        }
    }

    @Override
    public UIViewRoot createView(FacesContext context, String viewId) {
        ViewDeclarationLanguage vdl;
        Assert.notNull(viewId, "viewId");
        if (UIDebug.debugRequest(context)) {
            return null;
        }
        UIViewRoot root = super.createView(context, viewId);
        if (root != null && (vdl = context.getApplication().getViewHandler().getViewDeclarationLanguage(context, viewId)) != null) {
            List<String> contracts = vdl.calculateResourceLibraryContracts(context, root.getViewId() != null ? root.getViewId() : viewId);
            context.setResourceLibraryContracts(contracts);
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UIViewRoot restoreView(FacesContext context, String viewId) {
        Assert.notNull(viewId, "viewId");
        Application application = context.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(context, viewId);
        List<String> contracts = vdl.calculateResourceLibraryContracts(context, viewId);
        context.setResourceLibraryContracts(contracts);
        String renderKitId = viewHandler.calculateRenderKitId(context);
        ResponseStateManager manager = this.getRenderKitFactory().getRenderKit(context, renderKitId).getResponseStateManager();
        if (manager.isStateless(context, viewId)) {
            UIViewRoot view = null;
            try {
                ViewMetadata metadata = vdl.getViewMetadata(context, viewId);
                if (metadata != null) {
                    view = metadata.createMetadataView(context);
                }
                if (view == null) {
                    view = viewHandler.createView(context, viewId);
                }
                context.setViewRoot(view);
                boolean oldContextEventState = context.isProcessingEvents();
                try {
                    context.setProcessingEvents(true);
                    vdl.buildView(context, view);
                    if (!view.isTransient()) {
                        throw new FacesException("unable to create view \"" + viewId + "\"");
                    }
                }
                finally {
                    context.setProcessingEvents(oldContextEventState);
                }
            }
            catch (Throwable e) {
                throw new FacesException("unable to create view \"" + viewId + '\"', e);
            }
            FaceletsViewDeclarationLanguageUtils.markRenderedResources(context, view);
            return view;
        }
        UIViewRoot root = super.restoreView(context, viewId);
        FaceletsViewDeclarationLanguageUtils.markRenderedResources(context, root);
        return root;
    }

    @Override
    protected String calculateViewId(FacesContext context, String viewId) {
        return this.viewIdSupport.deriveLogicalViewId(context, viewId);
    }

    protected Compiler createCompiler(FacesContext context) {
        SAXCompiler compiler = new SAXCompiler();
        compiler.setDevelopmentProjectStage(context.isProjectStage(ProjectStage.Development));
        this.loadLibraries(context, compiler);
        this.loadDecorators(context, compiler);
        this.loadOptions(context, compiler);
        return compiler;
    }

    protected FaceletFactory createFaceletFactory(FacesContext context, Compiler compiler) {
        List<String> resourceResolversFromAnnotations;
        ExternalContext eContext = context.getExternalContext();
        long refreshPeriod = context.isProjectStage(ProjectStage.Production) ? WebConfigParamUtils.getLongInitParameter(eContext, "javax.faces.FACELETS_REFRESH_PERIOD", -1L) : WebConfigParamUtils.getLongInitParameter(eContext, "javax.faces.FACELETS_REFRESH_PERIOD", 0L);
        ResourceResolver resolver = new DefaultResourceResolver();
        ArrayList<String> classNames = new ArrayList<String>();
        String faceletsResourceResolverClassName = this.config.getResourceResolver();
        if (faceletsResourceResolverClassName != null) {
            classNames.add(faceletsResourceResolverClassName);
        }
        if (!(resourceResolversFromAnnotations = RuntimeConfig.getCurrentInstance(context.getExternalContext()).getResourceResolvers()).isEmpty()) {
            classNames.addAll(resourceResolversFromAnnotations);
        }
        if (!classNames.isEmpty()) {
            resolver = ClassUtils.buildApplicationObject(ResourceResolver.class, classNames, resolver);
        }
        this._resourceResolver = resolver;
        return new DefaultFaceletFactory(compiler, resolver, refreshPeriod);
    }

    protected ResponseWriter createResponseWriter(FacesContext context) throws IOException, FacesException {
        ExternalContext extContext = context.getExternalContext();
        RenderKit renderKit = context.getRenderKit();
        if (renderKit == null) {
            String id = context.getViewRoot().getRenderKitId();
            throw new IllegalStateException("No render kit was available for id \"" + id + '\"');
        }
        int faceletsBufferSize = this.config.getFaceletsBufferSize();
        if (faceletsBufferSize != -1) {
            extContext.setResponseBufferSize(faceletsBufferSize);
        }
        String contentType = (String)context.getAttributes().get("facelets.ContentType");
        String encoding = (String)context.getAttributes().get(PARAM_ENCODING);
        ResponseWriter writer = renderKit.createResponseWriter(FaceletsVDLUtils.NullWriter.INSTANCE, contentType, encoding);
        contentType = this.getResponseContentType(context, writer.getContentType());
        encoding = this.getResponseEncoding(context, writer.getCharacterEncoding());
        extContext.setResponseContentType(contentType + "; charset=" + encoding);
        writer = writer.cloneWithWriter(extContext.getResponseOutputWriter());
        return writer;
    }

    protected String getResponseContentType(FacesContext context, String orig) {
        String contentType = orig;
        Map<Object, Object> m = context.getAttributes();
        if (m.containsKey("facelets.ContentType")) {
            contentType = (String)m.get("facelets.ContentType");
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Facelet specified alternate contentType '" + contentType + '\'');
            }
        }
        if (contentType == null) {
            contentType = "text/html";
            log.finest("ResponseWriter created had a null ContentType, defaulting to text/html");
        }
        return contentType;
    }

    protected String getResponseEncoding(FacesContext context, String orig) {
        String encoding = orig;
        Map<Object, Object> m = context.getAttributes();
        Object session = context.getExternalContext().getSession(false);
        if (m.containsKey(PARAM_ENCODING)) {
            encoding = (String)m.get(PARAM_ENCODING);
            if (encoding != null && log.isLoggable(Level.FINEST)) {
                log.finest("Facelet specified alternate encoding '" + encoding + '\'');
            }
            if (session != null) {
                context.getExternalContext().getSessionMap().put("javax.faces.request.charset", encoding);
            }
        }
        if (encoding == null) {
            encoding = context.getExternalContext().getRequestCharacterEncoding();
        }
        if (encoding == null && session != null && (encoding = (String)context.getExternalContext().getSessionMap().get("javax.faces.request.charset")) != null && log.isLoggable(Level.FINEST)) {
            log.finest("Session specified alternate encoding '" + encoding + '\'');
        }
        if (encoding == null) {
            encoding = DEFAULT_CHARACTER_ENCODING;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("ResponseWriter created had a null CharacterEncoding, defaulting to " + encoding);
            }
        }
        return encoding;
    }

    protected void handleFaceletNotFound(FacesContext context, String viewId) throws FacesException, IOException {
        String actualId = context.getApplication().getViewHandler().getActionURL(context, viewId);
        context.getExternalContext().responseSendError(404, actualId);
        context.responseComplete();
    }

    protected void handleRenderException(FacesContext context, Exception e) throws IOException, ELException, FacesException {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        throw new FacesException(e.getMessage(), e);
    }

    protected void loadDecorators(FacesContext context, Compiler compiler) {
        this.faceletsCompilerSupport.loadDecorators(context, compiler);
    }

    protected void loadLibraries(FacesContext context, Compiler compiler) {
        this.faceletsCompilerSupport.loadLibraries(context, compiler);
    }

    protected void loadOptions(FacesContext context, Compiler compiler) {
        this.faceletsCompilerSupport.loadOptions(context, compiler);
    }

    @Override
    protected void sendSourceNotFound(FacesContext context, String message) {
        try {
            context.responseComplete();
            context.getExternalContext().responseSendError(404, message);
        }
        catch (IOException ioe) {
            throw new FacesException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Facelet _getFacelet(FacesContext context, String viewId) throws IOException {
        FaceletFactory.setInstance(this.faceletFactory);
        try {
            Facelet facelet = this.faceletFactory.getFacelet(context, viewId);
            return facelet;
        }
        finally {
            FaceletFactory.setInstance(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Facelet _getViewMetadataFacelet(FacesContext context, String viewId) throws IOException {
        FaceletFactory.setInstance(this.faceletFactory);
        try {
            Facelet facelet = this.faceletFactory.getViewMetadataFacelet(context, viewId);
            return facelet;
        }
        finally {
            FaceletFactory.setInstance(null);
        }
    }

    private void _initializeContractMappings(ExternalContext context) {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(context);
        ArrayList<String> prefixWildcardKeys = new ArrayList<String>();
        HashMap<String, List<String>> contractMappings = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : runtimeConfig.getContractMappings().entrySet()) {
            String urlPattern = entry.getKey().trim();
            if (urlPattern.endsWith(ASTERISK)) {
                prefixWildcardKeys.add(urlPattern);
            }
            contractMappings.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        Collections.sort(prefixWildcardKeys, new FaceletsVDLUtils.KeyComparator());
        this._prefixWildcardKeys = prefixWildcardKeys;
        this._contractMappings = contractMappings;
    }

    private boolean _usePartialStateSavingOnThisView(String viewId) {
        return this.config.isPartialStateSaving() && (this.fullStateSavingViewIds == null || !this.fullStateSavingViewIds.contains(viewId));
    }

    @Override
    public List<String> calculateResourceLibraryContracts(FacesContext context, String viewId) {
        List<String> contracts = this._contractMappings.get(viewId);
        if (contracts == null) {
            for (int i = 0; i < this._prefixWildcardKeys.size(); ++i) {
                String prefix = this._prefixWildcardKeys.get(i);
                if (!FaceletsVDLUtils.matchPattern(viewId, prefix)) continue;
                contracts = this._contractMappings.get(prefix);
                break;
            }
        }
        return contracts;
    }

    public FaceletFactory getFaceletFactory() {
        return this.faceletFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UIComponent createComponent(FacesContext context, String taglibURI, String tagName, Map<String, Object> attributes) {
        Assert.notNull(context, "context");
        UIComponent createdComponent = null;
        try {
            Facelet componentFacelet;
            FaceletFactory.setInstance(this.faceletFactory);
            try {
                componentFacelet = this.faceletFactory.compileComponentFacelet(taglibURI, tagName, attributes);
            }
            finally {
                FaceletFactory.setInstance(null);
            }
            if (componentFacelet == null) {
                return null;
            }
            boolean requiresDynamicRefresh = false;
            boolean requiresFaceletDynamicRefresh = false;
            UIPanel tempParent = (UIPanel)context.getApplication().createComponent(context, "javax.faces.Panel", null);
            tempParent.setId(context.getViewRoot().createUniqueId(context, null));
            String baseKey = tempParent.getId();
            baseKey = baseKey.startsWith("j_id") ? baseKey.substring(4) : baseKey;
            try {
                tempParent.pushComponentToEL(context, tempParent);
                ((AbstractFacelet)componentFacelet).applyDynamicComponentHandler(context, tempParent, baseKey);
            }
            finally {
                tempParent.popComponentFromEL(context);
                FaceletCompositionContext fcc = FaceletCompositionContext.getCurrentInstance(context);
                if (fcc != null) {
                    requiresFaceletDynamicRefresh = true;
                } else if (FaceletViewDeclarationLanguageBase.isDynamicComponentNeedsRefresh(context)) {
                    FaceletViewDeclarationLanguageBase.activateDynamicComponentRefreshTransientBuild(context);
                    FaceletViewDeclarationLanguageBase.resetDynamicComponentNeedsRefreshFlag(context);
                    requiresDynamicRefresh = true;
                }
            }
            if (tempParent.getChildCount() > 1) {
                createdComponent = tempParent;
                tempParent.getAttributes().put(DYN_WRAPPER, baseKey);
                tempParent.subscribeToEvent(PostRestoreStateEvent.class, new RefreshDynamicComponentListener(taglibURI, tagName, attributes, baseKey));
                if (requiresFaceletDynamicRefresh) {
                    FaceletViewDeclarationLanguageBase.dynamicComponentNeedsRefresh(context);
                }
            } else if (tempParent.getChildCount() == 1) {
                createdComponent = tempParent.getChildren().get(0);
                boolean requiresRefresh = false;
                if (UIComponent.isCompositeComponent(createdComponent)) {
                    createdComponent.getAttributes().put(GEN_MARK_ID, createdComponent.getAttributes().get("oam.vf.MARK_ID"));
                    createdComponent.getAttributes().put("oam.vf.MARK_ID", null);
                    createdComponent.subscribeToEvent(PostAddToViewEvent.class, new CreateDynamicCompositeComponentListener(taglibURI, tagName, attributes, baseKey));
                    requiresRefresh = true;
                    if (requiresFaceletDynamicRefresh) {
                        FaceletViewDeclarationLanguageBase.dynamicComponentNeedsRefresh(context);
                    }
                } else if (createdComponent.getChildCount() > 0) {
                    createdComponent.getAttributes().put(GEN_MARK_ID, createdComponent.getAttributes().get("oam.vf.MARK_ID"));
                    createdComponent.getAttributes().put("oam.vf.MARK_ID", null);
                    requiresRefresh = true;
                    if (requiresFaceletDynamicRefresh) {
                        FaceletViewDeclarationLanguageBase.dynamicComponentNeedsRefresh(context);
                    }
                } else if (createdComponent.isTransient()) {
                    createdComponent = tempParent;
                    tempParent.getAttributes().put(DYN_WRAPPER, baseKey);
                    requiresRefresh = true;
                } else {
                    createdComponent.getAttributes().put("oam.vf.MARK_ID", null);
                }
                if (requiresRefresh) {
                    createdComponent.subscribeToEvent(PostRestoreStateEvent.class, new RefreshDynamicComponentListener(taglibURI, tagName, attributes, baseKey));
                }
                if (requiresDynamicRefresh) {
                    createdComponent.subscribeToEvent(DynamicComponentRefreshTransientBuildEvent.class, new RefreshDynamicComponentListener(taglibURI, tagName, attributes, baseKey));
                    createdComponent.getAttributes().put("oam.vf.DYN_COMP_REFRESH_FLAG", Boolean.TRUE);
                }
                if (requiresFaceletDynamicRefresh) {
                    createdComponent.subscribeToEvent(FaceletDynamicComponentRefreshTransientBuildEvent.class, new RefreshDynamicComponentListener(taglibURI, tagName, attributes, baseKey));
                }
            }
        }
        catch (IOException e) {
            throw new FacesException(e);
        }
        return createdComponent;
    }

    @Override
    public Stream<String> getViews(FacesContext facesContext, String path, int maxDepth, ViewVisitOption ... options) {
        Stream<String> stream = super.getViews(facesContext, path, maxDepth, options);
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(facesContext.getExternalContext());
        stream = stream.filter(f -> this.strategy.handles((String)f) && !FaceletsTemplateMappingUtils.matchTemplate(runtimeConfig, f));
        if (options != null && Arrays.binarySearch((Object[])options, (Object)ViewVisitOption.RETURN_AS_MINIMAL_IMPLICIT_OUTCOME) >= 0) {
            stream = stream.map(f -> this.strategy.getMinimalImplicitOutcome((String)f));
        }
        return stream;
    }

    private class FaceletViewMetadata
    extends ViewMetadataBase {
        public FaceletViewMetadata(String viewId) {
            super(viewId);
        }

        @Override
        public UIViewRoot createMetadataView(FacesContext context) {
            try {
                context.setProcessingEvents(false);
                context.getAttributes().put(FaceletViewDeclarationLanguage.BUILDING_VIEW_METADATA, Boolean.TRUE);
                UIViewRoot view = context.getApplication().getViewHandler().createView(context, this.getViewId());
                if (view != null) {
                    Facelet facelet = null;
                    try {
                        facelet = FaceletViewDeclarationLanguage.this._getViewMetadataFacelet(context, view.getViewId());
                    }
                    catch (FileNotFoundException e) {
                        FaceletViewDeclarationLanguage.this.sendSourceNotFound(context, this.getViewId());
                        UIViewRoot uIViewRoot = null;
                        context.getAttributes().remove(FaceletViewDeclarationLanguage.BUILDING_VIEW_METADATA);
                        context.setProcessingEvents(true);
                        return uIViewRoot;
                    }
                    facelet.apply(context, view);
                }
                UIViewRoot uIViewRoot = view;
                return uIViewRoot;
            }
            catch (IOException ioe) {
                throw new FacesException(ioe);
            }
            finally {
                context.getAttributes().remove(FaceletViewDeclarationLanguage.BUILDING_VIEW_METADATA);
                context.setProcessingEvents(true);
            }
        }
    }
}

