/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.application;

import jakarta.faces.application.Resource;
import jakarta.faces.application.ResourceVisitOption;
import jakarta.faces.application.ViewResource;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public abstract class ResourceHandler {
    public static final String LOCALE_PREFIX = "jakarta.faces.resource.localePrefix";
    public static final String RESOURCE_EXCLUDES_DEFAULT_VALUE = ".class .jsp .jspx .properties .xhtml .groovy";
    public static final String RESOURCE_EXCLUDES_PARAM_NAME = "jakarta.faces.RESOURCE_EXCLUDES";
    public static final String RESOURCE_IDENTIFIER = "/jakarta.faces.resource";
    public static final String RESOURCE_CONTRACT_XML = "jakarta.faces.contract.xml";
    public static final String WEBAPP_CONTRACTS_DIRECTORY_PARAM_NAME = "jakarta.faces.WEBAPP_CONTRACTS_DIRECTORY";
    public static final String WEBAPP_RESOURCES_DIRECTORY_PARAM_NAME = "jakarta.faces.WEBAPP_RESOURCES_DIRECTORY";
    public static final String JSF_SCRIPT_RESOURCE_NAME = "jsf.js";
    public static final String JSF_SCRIPT_LIBRARY_NAME = "jakarta.faces";
    private static final String MYFACES_JS_RESOURCE_NAME = "oamSubmit.js";
    private static final String MYFACES_JS_RESOURCE_NAME_UNCOMPRESSED = "oamSubmit-uncompressed.js";
    private static final String RENDERED_RESOURCES_SET = "org.apache.myfaces.RENDERED_RESOURCES_SET";
    private static final String MYFACES_LIBRARY_NAME = "org.apache.myfaces";
    private static final String RENDERED_MYFACES_JS = "org.apache.myfaces.RENDERED_MYFACES_JS";

    public abstract Resource createResource(String var1);

    public abstract Resource createResource(String var1, String var2);

    public abstract Resource createResource(String var1, String var2, String var3);

    public abstract String getRendererTypeForResourceName(String var1);

    public abstract void handleResourceRequest(FacesContext var1) throws IOException;

    public abstract boolean isResourceRequest(FacesContext var1);

    public abstract boolean libraryExists(String var1);

    public Resource createResourceFromId(String resourceId) {
        return null;
    }

    public ViewResource createViewResource(FacesContext context, String resourceName) {
        return context.getApplication().getResourceHandler().createResource(resourceName);
    }

    public boolean isResourceURL(String url) {
        if (url == null) {
            throw new NullPointerException();
        }
        return url.contains(RESOURCE_IDENTIFIER);
    }

    public Stream<String> getViewResources(FacesContext facesContext, String path, ResourceVisitOption ... options) {
        return this.getViewResources(facesContext, path, Integer.MAX_VALUE, options);
    }

    public Stream<String> getViewResources(FacesContext facesContext, String path, int maxDepth, ResourceVisitOption ... options) {
        return null;
    }

    public boolean isResourceRendered(FacesContext facesContext, String resourceName, String libraryName) {
        return ResourceHandler.getRenderedResources(facesContext).containsKey(libraryName != null ? libraryName + '/' + resourceName : resourceName);
    }

    public void markResourceRendered(FacesContext facesContext, String resourceName, String libraryName) {
        ResourceHandler.getRenderedResources(facesContext).put(libraryName != null ? libraryName + '/' + resourceName : resourceName, Boolean.TRUE);
        if (JSF_SCRIPT_LIBRARY_NAME.equals(libraryName) && JSF_SCRIPT_RESOURCE_NAME.equals(resourceName)) {
            ResourceHandler.getRenderedResources(facesContext).put("org.apache.myfaces/oamSubmit.js", Boolean.TRUE);
        }
    }

    private static Map<String, Boolean> getRenderedResources(FacesContext facesContext) {
        HashMap map = (HashMap)facesContext.getViewRoot().getTransientStateHelper().getTransient(RENDERED_RESOURCES_SET);
        if (map == null) {
            map = new HashMap();
            facesContext.getViewRoot().getTransientStateHelper().putTransient(RENDERED_RESOURCES_SET, map);
        }
        return map;
    }
}

