/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import jakarta.el.ELException;
import jakarta.faces.FacesException;
import jakarta.faces.view.facelets.ComponentConfig;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletException;
import jakarta.faces.view.facelets.FaceletHandler;
import jakarta.faces.view.facelets.Tag;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.myfaces.view.facelets.tag.TagHandlerFactory;
import org.apache.myfaces.view.facelets.tag.TagLibrary;

public class ComponentTagDeclarationLibrary
implements TagLibrary {
    private final Map<String, Map<String, TagHandlerFactory>> _factories = new HashMap<String, Map<String, TagHandlerFactory>>();

    @Override
    public boolean containsNamespace(String ns) {
        return this._factories.containsKey(ns);
    }

    @Override
    public boolean containsTagHandler(String ns, String localName) {
        if (this.containsNamespace(ns)) {
            Map<String, TagHandlerFactory> map = this._factories.get(ns);
            if (map == null) {
                return false;
            }
            return map.containsKey(localName);
        }
        return false;
    }

    @Override
    public TagHandler createTagHandler(String ns, String localName, TagConfig tag) throws FacesException {
        if (this.containsNamespace(ns)) {
            TagHandlerFactory f;
            Map<String, TagHandlerFactory> map = this._factories.get(ns);
            if (map == null) {
                map = new HashMap<String, TagHandlerFactory>();
                this._factories.put(ns, map);
            }
            if ((f = map.get(localName)) != null) {
                return f.createHandler(tag);
            }
        }
        return null;
    }

    @Override
    public boolean containsFunction(String ns, String name) {
        return false;
    }

    @Override
    public Method createFunction(String ns, String name) {
        return null;
    }

    public final void addComponent(String namespace, String name, String componentType, String rendererType) {
        Map<String, TagHandlerFactory> map = this._factories.get(namespace);
        if (map == null) {
            map = new HashMap<String, TagHandlerFactory>();
            this._factories.put(namespace, map);
        }
        map.put(name, new ComponentHandlerFactory(componentType, rendererType));
    }

    public final void addComponent(String namespace, String name, String componentType, String rendererType, Class<? extends TagHandler> handlerType) {
        Map<String, TagHandlerFactory> map = this._factories.get(namespace);
        if (map == null) {
            map = new HashMap<String, TagHandlerFactory>();
            this._factories.put(namespace, map);
        }
        map.put(name, new UserComponentHandlerFactory(componentType, rendererType, handlerType));
    }

    private static class UserComponentHandlerFactory
    implements TagHandlerFactory {
        private static final Class<?>[] CONS_SIG = new Class[]{ComponentConfig.class};
        protected final String componentType;
        protected final String renderType;
        protected final Class<? extends TagHandler> type;
        protected final Constructor<? extends TagHandler> constructor;

        public UserComponentHandlerFactory(String componentType, String renderType, Class<? extends TagHandler> type) {
            this.componentType = componentType;
            this.renderType = renderType;
            this.type = type;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (Exception e) {
                throw new FaceletException("Must have a Constructor that takes in a ComponentConfig", e);
            }
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                ComponentConfigWrapper ccfg = new ComponentConfigWrapper(cfg, this.componentType, this.renderType);
                return this.constructor.newInstance(ccfg);
            }
            catch (InvocationTargetException e) {
                throw new FaceletException(e.getCause().getMessage(), e.getCause().getCause());
            }
            catch (Exception e) {
                throw new FaceletException("Error Instantiating ComponentHandler: " + this.type.getName(), e);
            }
        }
    }

    private static class ComponentHandlerFactory
    implements TagHandlerFactory {
        protected final String componentType;
        protected final String renderType;

        public ComponentHandlerFactory(String componentType, String renderType) {
            this.componentType = componentType;
            this.renderType = renderType;
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            ComponentConfigWrapper ccfg = new ComponentConfigWrapper(cfg, this.componentType, this.renderType);
            return new ComponentHandler(ccfg);
        }
    }

    private static class ComponentConfigWrapper
    implements ComponentConfig {
        protected final TagConfig parent;
        protected final String componentType;
        protected final String rendererType;

        public ComponentConfigWrapper(TagConfig parent, String componentType, String rendererType) {
            this.parent = parent;
            this.componentType = componentType;
            this.rendererType = rendererType;
        }

        @Override
        public String getComponentType() {
            return this.componentType;
        }

        @Override
        public String getRendererType() {
            return this.rendererType;
        }

        @Override
        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        @Override
        public Tag getTag() {
            return this.parent.getTag();
        }

        @Override
        public String getTagId() {
            return this.parent.getTagId();
        }
    }
}

