/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import jakarta.faces.FacesException;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.view.facelets.Facelet;
import java.io.IOException;
import java.util.Map;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.view.facelets.AbstractFacelet;
import org.apache.myfaces.view.facelets.FaceletFactory;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguage;
import org.apache.myfaces.view.facelets.tag.faces.ComponentSupport;

public final class RefreshDynamicComponentListener
implements ComponentSystemEventListener,
StateHolder {
    private String taglibURI;
    private String tagName;
    private Map<String, Object> attributes;
    private String baseKey;

    public RefreshDynamicComponentListener(String taglibURI, String tagName, Map<String, Object> attributes, String baseKey) {
        this.taglibURI = taglibURI;
        this.tagName = tagName;
        this.attributes = attributes;
        this.baseKey = baseKey;
    }

    public RefreshDynamicComponentListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processEvent(ComponentSystemEvent event) {
        block19: {
            Facelet componentFacelet;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            FaceletViewDeclarationLanguage vdl = (FaceletViewDeclarationLanguage)facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(facesContext, facesContext.getViewRoot().getViewId());
            FaceletFactory faceletFactory = vdl.getFaceletFactory();
            FaceletFactory.setInstance(faceletFactory);
            try {
                componentFacelet = faceletFactory.compileComponentFacelet(this.taglibURI, this.tagName, this.attributes);
            }
            finally {
                FaceletFactory.setInstance(null);
            }
            try {
                UIComponent component = event.getComponent();
                facesContext.getAttributes().put("org.apache.myfaces.REFRESHING_TRANSIENT_BUILD", Boolean.TRUE);
                UIComponent parent = component.getParent();
                String facetName = null;
                if (parent.getFacetCount() > 0 && !parent.getChildren().contains(component)) {
                    facetName = ComponentSupport.findFacetNameByComponentInstance(parent, component);
                }
                try {
                    String markId;
                    if (facetName != null) {
                        parent.getAttributes().put("facelets.FACET_NAME", facetName);
                    }
                    if ((markId = (String)component.getAttributes().get("oam.vf.GEN_MARK_ID")) == null) {
                        ((AbstractFacelet)componentFacelet).applyDynamicComponentHandler(facesContext, component, this.baseKey);
                        break block19;
                    }
                    try {
                        component.getAttributes().put("oam.vf.MARK_ID", markId);
                        ((AbstractFacelet)componentFacelet).applyDynamicComponentHandler(facesContext, component.getParent(), this.baseKey);
                    }
                    finally {
                        component.getAttributes().put("oam.vf.MARK_ID", null);
                    }
                }
                finally {
                    if (facetName != null) {
                        parent.getAttributes().remove("facelets.FACET_NAME");
                    }
                }
            }
            catch (IOException e) {
                throw new FacesException(e);
            }
            finally {
                facesContext.getAttributes().remove("org.apache.myfaces.REFRESHING_TRANSIENT_BUILD");
            }
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(context);
        Integer tagId = runtimeConfig.getIdByNamespace().get(this.taglibURI);
        Object[] values = new Object[]{tagId != null ? tagId : (this.taglibURI.startsWith("jakarta.faces.composite") ? new Object[]{0, this.taglibURI.substring("jakarta.faces.composite".length())} : (this.taglibURI.startsWith("http://xmlns.jcp.org/jsf/composite/") ? new Object[]{1, this.taglibURI.substring("http://xmlns.jcp.org/jsf/composite/".length())} : (this.taglibURI.startsWith("http://java.sun.com/jsf/composite/") ? new Object[]{2, this.taglibURI.substring("http://java.sun.com/jsf/composite/".length())} : this.taglibURI))), this.tagName, this.attributes, this.baseKey};
        return values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        if (values[0] instanceof String) {
            this.taglibURI = (String)values[0];
        } else if (values[0] instanceof Integer) {
            RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(context);
            this.taglibURI = runtimeConfig.getNamespaceById().get((Integer)values[0]);
        } else if (values[0] instanceof Object[]) {
            String ns;
            Object[] def = (Object[])values[0];
            int index = (Integer)def[0];
            switch (index) {
                case 0: {
                    ns = "jakarta.faces.composite";
                    break;
                }
                case 1: {
                    ns = "http://xmlns.jcp.org/jsf/composite/";
                    break;
                }
                case 2: {
                    ns = "http://java.sun.com/jsf/composite/";
                    break;
                }
                default: {
                    ns = "";
                }
            }
            this.taglibURI = ns + (String)((Object[])values[0])[1];
        }
        this.tagName = (String)values[1];
        this.attributes = (Map)values[2];
        this.baseKey = (String)values[3];
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
    }
}

