/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component.html;

import jakarta.el.ValueExpression;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.http.Part;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.myfaces.core.api.shared.CommonHtmlAttributes;
import org.apache.myfaces.core.api.shared.CommonHtmlEvents;
import org.apache.myfaces.core.api.shared.MessageUtils;

public class HtmlInputFile
extends UIInput
implements ClientBehaviorHolder {
    public static final String COMPONENT_FAMILY = "jakarta.faces.Input";
    public static final String COMPONENT_TYPE = "jakarta.faces.HtmlInputFile";
    private static final Collection<String> CLIENT_EVENTS_LIST = Collections.unmodifiableCollection(Arrays.asList("select", "click", "dblclick", "keydown", "keypress", "keyup", "mousedown", "mousemove", "mouseout", "mouseover", "mouseup", "blur", "focus", "change", "valueChange"));

    @Override
    protected void validateValue(FacesContext context, Object convertedValue) {
        if (!this.isValid()) {
            return;
        }
        boolean isEmpty = HtmlInputFile.isEmptyValue(convertedValue);
        if (this.isRequired() && isEmpty) {
            if (this.getRequiredMessage() != null) {
                String requiredMessage = this.getRequiredMessage();
                context.addMessage(this.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, requiredMessage, requiredMessage));
            } else {
                MessageUtils.addErrorMessage(context, this, "jakarta.faces.component.UIInput.REQUIRED", new Object[]{MessageUtils.getLabel(context, this)});
            }
            this.setValid(false);
            return;
        }
        if (!isEmpty) {
            super.validateValue(context, convertedValue);
        }
    }

    private static boolean isEmptyValue(Object value) {
        if (value == null) {
            return true;
        }
        return value instanceof String ? ((String)value).trim().length() <= 0 : (value instanceof Collection ? ((Collection)value).isEmpty() : (value.getClass().isArray() ? Array.getLength(value) <= 0 : (value instanceof Map ? ((Map)value).isEmpty() : value instanceof Part && ((Part)value).getSize() <= 0L)));
    }

    public HtmlInputFile() {
        this.setRendererType("jakarta.faces.File");
    }

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    @Override
    public Collection<String> getEventNames() {
        return CLIENT_EVENTS_LIST;
    }

    @Override
    public void addClientBehavior(String eventName, ClientBehavior behavior) {
        super.addClientBehavior(eventName, behavior);
        CommonHtmlEvents.markEvent(this, eventName);
    }

    @Override
    public String getDefaultEventName() {
        return "valueChange";
    }

    public int getMaxlength() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.maxlength), Integer.MIN_VALUE);
    }

    public void setMaxlength(int maxlength) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.maxlength), maxlength);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 0x2000000000L);
    }

    public int getSize() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.size), Integer.MIN_VALUE);
    }

    public void setSize(int size) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.size), size);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 0x4000000000L);
    }

    public String getAutocomplete() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.autocomplete));
    }

    public void setAutocomplete(String autocomplete) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.autocomplete), autocomplete);
    }

    public String getAccept() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.accept));
    }

    public void setAccept(String accept) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.accept), accept);
    }

    public boolean isMultiple() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.multiple), false);
    }

    public void setMultiple(boolean multiple) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.multiple), multiple);
    }

    public String getAccesskey() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.accesskey));
    }

    public void setAccesskey(String accesskey) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.accesskey), accesskey);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 512L);
    }

    public String getOnselect() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onselect));
    }

    public void setOnselect(String onselect) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onselect), onselect);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 4096L);
    }

    public boolean isDisabled() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.disabled), false);
    }

    public void setDisabled(boolean disabled) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.disabled), disabled);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 64L);
    }

    public boolean isReadonly() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.readonly), false);
    }

    public void setReadonly(boolean readonly) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.readonly), readonly);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 256L);
    }

    public String getOnclick() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onclick));
    }

    public void setOnclick(String onclick) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onclick), onclick);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 8192L);
    }

    public String getOndblclick() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.ondblclick));
    }

    public void setOndblclick(String ondblclick) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.ondblclick), ondblclick);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 16384L);
    }

    public String getOnkeydown() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onkeydown));
    }

    public void setOnkeydown(String onkeydown) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onkeydown), onkeydown);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 0x200000L);
    }

    public String getOnkeypress() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onkeypress));
    }

    public void setOnkeypress(String onkeypress) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onkeypress), onkeypress);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 0x100000L);
    }

    public String getOnkeyup() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onkeyup));
    }

    public void setOnkeyup(String onkeyup) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onkeyup), onkeyup);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 0x400000L);
    }

    public String getOnmousedown() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onmousedown));
    }

    public void setOnmousedown(String onmousedown) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onmousedown), onmousedown);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 32768L);
    }

    public String getOnmousemove() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onmousemove));
    }

    public void setOnmousemove(String onmousemove) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onmousemove), onmousemove);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 262144L);
    }

    public String getOnmouseout() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onmouseout));
    }

    public void setOnmouseout(String onmouseout) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onmouseout), onmouseout);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 524288L);
    }

    public String getOnmouseover() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onmouseover));
    }

    public void setOnmouseover(String onmouseover) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onmouseover), onmouseover);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 131072L);
    }

    public String getOnmouseup() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onmouseup));
    }

    public void setOnmouseup(String onmouseup) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onmouseup), onmouseup);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 65536L);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style));
    }

    public void setStyle(String style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), style);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 1L);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass));
    }

    public void setStyleClass(String styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), styleClass);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 2L);
    }

    public String getRole() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.role));
    }

    public void setRole(String role) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.role), role);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 0x8000000000L);
    }

    public String getLabel() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.label));
    }

    public void setLabel(String label) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.label), label);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 0x2000000L);
    }

    public String getAlt() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.alt));
    }

    public void setAlt(String alt) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.alt), alt);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 1024L);
    }

    public String getDir() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dir));
    }

    public void setDir(String dir) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dir), dir);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 4L);
    }

    public String getLang() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.lang));
    }

    public void setLang(String lang) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.lang), lang);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 8L);
    }

    public String getTitle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.title));
    }

    public void setTitle(String title) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.title), title);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 16L);
    }

    public String getOnblur() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onblur));
    }

    public void setOnblur(String onblur) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onblur), onblur);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 0x1000000L);
    }

    public String getOnfocus() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onfocus));
    }

    public void setOnfocus(String onfocus) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onfocus), onfocus);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 0x800000L);
    }

    public String getTabindex() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tabindex));
    }

    public void setTabindex(String tabindex) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tabindex), tabindex);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 0x400000000L);
    }

    public String getOnchange() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onchange));
    }

    public void setOnchange(String onchange) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onchange), onchange);
        CommonHtmlAttributes.markAttribute((UIComponent)this, 2048L);
    }

    @Override
    public void setValueExpression(String name, ValueExpression expression) {
        super.setValueExpression(name, expression);
        CommonHtmlAttributes.markAttribute((UIComponent)this, name);
    }

    protected static enum PropertyKeys {
        maxlength,
        size,
        autocomplete,
        accept,
        multiple,
        accesskey,
        onselect,
        disabled,
        readonly,
        onclick,
        ondblclick,
        onkeydown,
        onkeypress,
        onkeyup,
        onmousedown,
        onmousemove,
        onmouseout,
        onmouseover,
        onmouseup,
        style,
        styleClass,
        role,
        label,
        alt,
        dir,
        lang,
        title,
        onblur,
        onfocus,
        tabindex,
        onchange;

    }
}

