/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.util.Map;
import org.apache.myfaces.spi.InjectionProvider;
import org.apache.myfaces.spi.impl.DefaultInjectionProviderFactory;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class InjectionProviderFactory {
    private static final String FACTORY_KEY = InjectionProviderFactory.class.getName();

    public static InjectionProviderFactory getInjectionProviderFactory() {
        return InjectionProviderFactory.getInjectionProviderFactory(FacesContext.getCurrentInstance().getExternalContext());
    }

    public static InjectionProviderFactory getInjectionProviderFactory(ExternalContext ctx) {
        Map applicationMap = ctx.getApplicationMap();
        InjectionProviderFactory instance = (InjectionProviderFactory)applicationMap.get(FACTORY_KEY);
        if (instance != null) {
            return instance;
        }
        instance = (InjectionProviderFactory)SpiUtils.build(ctx, InjectionProviderFactory.class, DefaultInjectionProviderFactory.class);
        if (instance != null) {
            applicationMap.put(FACTORY_KEY, instance);
        }
        return instance;
    }

    public static void setInjectionProviderFactory(InjectionProviderFactory instance) {
        FacesContext.getCurrentInstance().getExternalContext().getApplicationMap().put(FACTORY_KEY, instance);
    }

    public abstract InjectionProvider getInjectionProvider(ExternalContext var1);

    public abstract void release();
}

