/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import jakarta.el.MethodExpression;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.FacesContextWrapper;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.PhaseId;
import java.io.Serializable;

public class UIViewAction
extends UIComponentBase
implements ActionSource {
    public static final String COMPONENT_FAMILY = "jakarta.faces.ViewAction";
    public static final String COMPONENT_TYPE = "jakarta.faces.ViewAction";
    private static final String BROADCAST_PROCESSING_KEY = "oam.viewAction.broadcast";
    private static final String EVENT_COUNT_KEY = "oam.viewAction.eventCount";

    public UIViewAction() {
        this.setRendererType(null);
    }

    @Override
    public boolean isRendered() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.renderedAttr), true);
    }

    @Override
    public void setRendered(boolean condition) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.renderedAttr), condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        block12: {
            ActionListener defaultActionListener;
            super.broadcast(event);
            FacesContext context = this.getFacesContext();
            if (context.getResponseComplete()) {
                return;
            }
            UIComponent c = event.getComponent();
            UIViewRoot sourceViewRoot = null;
            do {
                if (!(c instanceof UIViewRoot)) continue;
                sourceViewRoot = (UIViewRoot)c;
                break;
            } while ((c = c.getParent()) != null);
            if (!context.getViewRoot().equals(sourceViewRoot)) {
                return;
            }
            if (!(event instanceof ActionEvent) || (defaultActionListener = context.getApplication().getActionListener()) == null) break block12;
            String viewIdBeforeAction = context.getViewRoot().getViewId();
            Boolean oldBroadcastProcessing = (Boolean)context.getAttributes().get(BROADCAST_PROCESSING_KEY);
            try {
                context.getAttributes().put(BROADCAST_PROCESSING_KEY, Boolean.TRUE);
                ViewActionFacesContextWrapper wrappedFacesContext = new ViewActionFacesContextWrapper(context);
                try {
                    wrappedFacesContext.setWrapperAsCurrentFacesContext();
                    if (event instanceof ViewActionEvent) {
                        ((ViewActionEvent)event).setFacesContext(wrappedFacesContext);
                    }
                    defaultActionListener.processAction((ActionEvent)event);
                    Integer count = (Integer)context.getAttributes().get(EVENT_COUNT_KEY);
                    count = count == null ? 0 : count - 1;
                    context.getAttributes().put(EVENT_COUNT_KEY, count);
                }
                finally {
                    wrappedFacesContext.restoreCurrentFacesContext();
                }
                context.getAttributes().put(BROADCAST_PROCESSING_KEY, oldBroadcastProcessing == null ? Boolean.FALSE : oldBroadcastProcessing);
            }
            catch (Throwable throwable) {
                context.getAttributes().put(BROADCAST_PROCESSING_KEY, oldBroadcastProcessing == null ? Boolean.FALSE : oldBroadcastProcessing);
                throw throwable;
            }
            if (context.getResponseComplete()) {
                return;
            }
            Integer count = (Integer)context.getAttributes().get(EVENT_COUNT_KEY);
            count = count == null ? 0 : count;
            String viewIdAfterAction = context.getViewRoot().getViewId();
            if (viewIdBeforeAction.equals(viewIdAfterAction) && count == 0) {
                context.renderResponse();
            }
        }
    }

    @Override
    public void decode(FacesContext context) {
        super.decode(context);
        if (context.isPostback() && !this.isOnPostback()) {
            return;
        }
        if (!this.isRendered()) {
            return;
        }
        ViewActionEvent evt = new ViewActionEvent(this);
        String phase = this.getPhase();
        PhaseId phaseId = phase != null ? PhaseId.phaseIdValueOf(phase) : (this.isImmediate() ? PhaseId.APPLY_REQUEST_VALUES : PhaseId.INVOKE_APPLICATION);
        evt.setPhaseId(phaseId);
        this.queueEvent(evt);
        Integer count = (Integer)context.getAttributes().get(EVENT_COUNT_KEY);
        count = count == null ? 1 : count + 1;
        context.getAttributes().put(EVENT_COUNT_KEY, count);
    }

    @Override
    public boolean isImmediate() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.immediate), Boolean.FALSE);
    }

    @Override
    public void setImmediate(boolean immediate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.immediate), immediate);
    }

    @Override
    public MethodExpression getActionExpression() {
        return (MethodExpression)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.actionExpression));
    }

    @Override
    public void setActionExpression(MethodExpression actionExpression) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.actionExpression), actionExpression);
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.addFacesListener(listener);
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        this.removeFacesListener(listener);
    }

    @Override
    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getFacesListeners(ActionListener.class);
    }

    public String getPhase() {
        return (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.phase));
    }

    public void setPhase(String phase) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.phase), phase);
    }

    public boolean isOnPostback() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onPostback), Boolean.FALSE);
    }

    public void setOnPostback(boolean onPostback) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onPostback), onPostback);
    }

    public static boolean isProcessingBroadcast(FacesContext context) {
        return Boolean.TRUE.equals(context.getAttributes().get(BROADCAST_PROCESSING_KEY));
    }

    @Override
    public String getFamily() {
        return "jakarta.faces.ViewAction";
    }

    static enum PropertyKeys {
        immediate,
        value,
        actionExpression,
        actionListener,
        phase,
        onPostback,
        renderedAttr("if");

        private String name;

        private PropertyKeys() {
        }

        private PropertyKeys(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name != null ? this.name : super.toString();
        }
    }

    private static class ViewActionFacesContextWrapper
    extends FacesContextWrapper {
        private FacesContext delegate;
        private boolean renderResponseCalled;

        public ViewActionFacesContextWrapper(FacesContext delegate) {
            this.delegate = delegate;
            this.renderResponseCalled = false;
        }

        @Override
        public void renderResponse() {
            this.renderResponseCalled = true;
        }

        public boolean isRenderResponseCalled() {
            return this.renderResponseCalled;
        }

        @Override
        public FacesContext getWrapped() {
            return this.delegate;
        }

        void setWrapperAsCurrentFacesContext() {
            ViewActionFacesContextWrapper.setCurrentInstance(this);
        }

        void restoreCurrentFacesContext() {
            ViewActionFacesContextWrapper.setCurrentInstance(this.delegate);
        }
    }

    private static class ViewActionEvent
    extends ActionEvent {
        private static final long serialVersionUID = 1L;
        private transient FacesContext facesContext;

        public ViewActionEvent(FacesContext facesContext, UIComponent uiComponent) {
            super(facesContext, uiComponent);
            this.facesContext = facesContext;
        }

        public ViewActionEvent(UIComponent uiComponent) {
            super(uiComponent);
        }

        @Override
        public FacesContext getFacesContext() {
            if (this.facesContext != null) {
                return this.facesContext;
            }
            return super.getFacesContext();
        }

        void setFacesContext(FacesContext facesContext) {
            this.facesContext = facesContext;
        }
    }
}

