/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.convert;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import org.apache.myfaces.core.api.shared.MessageUtils;
import org.apache.myfaces.core.api.shared.lang.Assert;

public class ShortConverter
implements Converter {
    public static final String CONVERTER_ID = "jakarta.faces.Short";
    public static final String STRING_ID = "jakarta.faces.converter.STRING";
    public static final String SHORT_ID = "jakarta.faces.converter.ShortConverter.SHORT";

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) {
        Assert.notNull(facesContext, "facesContext");
        Assert.notNull(uiComponent, "uiComponent");
        if (value == null || value.isBlank()) {
            return null;
        }
        try {
            return Short.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ConverterException(MessageUtils.getErrorMessage(facesContext, SHORT_ID, new Object[]{value, "21", MessageUtils.getLabel(facesContext, uiComponent)}), (Throwable)e);
        }
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) {
        Assert.notNull(facesContext, "facesContext");
        Assert.notNull(uiComponent, "uiComponent");
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        try {
            return Short.toString(((Number)value).shortValue());
        }
        catch (Exception e) {
            throw new ConverterException(MessageUtils.getErrorMessage(facesContext, STRING_ID, new Object[]{value, MessageUtils.getLabel(facesContext, uiComponent)}), (Throwable)e);
        }
    }
}

