/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.myfaces.extensions.validator.baseval.annotation.JoinValidation;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.metadata.extractor.DefaultComponentMetaDataExtractor;
import org.apache.myfaces.extensions.validator.core.property.DefaultPropertyInformation;
import org.apache.myfaces.extensions.validator.core.property.PropertyDetails;
import org.apache.myfaces.extensions.validator.core.property.PropertyInformation;
import org.apache.myfaces.extensions.validator.core.storage.MetaDataStorageFilter;
import org.apache.myfaces.extensions.validator.core.storage.PropertyStorage;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ClassUtils;
import org.apache.myfaces.extensions.validator.util.ExtValAnnotationUtils;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.ProxyUtils;
import org.apache.myfaces.extensions.validator.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class JoinValidationMetaDataStorageFilter
implements MetaDataStorageFilter {
    private static final String STATIC_SEPARATOR = ":";

    public void filter(PropertyInformation propertyInformation) {
        if (propertyInformation != null) {
            ArrayList<MetaDataEntry> result = new ArrayList<MetaDataEntry>();
            this.resolveJoinValidationMetaData(propertyInformation, result);
            propertyInformation.resetMetaDataEntries();
            this.setDefaultPropertyDetails(propertyInformation, result);
            if (this.containsJoinValidationConstraint(result)) {
                this.filter(propertyInformation);
            }
        }
    }

    private void resolveJoinValidationMetaData(PropertyInformation propertyInformation, List<MetaDataEntry> result) {
        for (MetaDataEntry metaDataEntry : propertyInformation.getMetaDataEntries()) {
            result.addAll(this.tryToTransformEntry(metaDataEntry));
        }
    }

    private void setDefaultPropertyDetails(PropertyInformation propertyInformation, List<MetaDataEntry> result) {
        for (MetaDataEntry metaDataEntry : result) {
            metaDataEntry.setProperty("property_details", propertyInformation.getInformation("property_details"));
            propertyInformation.addMetaDataEntry(metaDataEntry);
        }
    }

    private boolean containsJoinValidationConstraint(List<MetaDataEntry> result) {
        for (MetaDataEntry entry : result) {
            if (!(entry.getValue() instanceof JoinValidation)) continue;
            return true;
        }
        return false;
    }

    private List<MetaDataEntry> tryToTransformEntry(MetaDataEntry metaDataEntry) {
        ArrayList<MetaDataEntry> result = new ArrayList<MetaDataEntry>();
        if (metaDataEntry.getValue() instanceof JoinValidation) {
            JoinValidation annotation = (JoinValidation)metaDataEntry.getValue(JoinValidation.class);
            this.replaceMetaData(annotation, metaDataEntry, result);
        } else {
            result.add(metaDataEntry);
        }
        return result;
    }

    private void replaceMetaData(JoinValidation annotation, MetaDataEntry metaDataEntry, List<MetaDataEntry> result) {
        for (String target : annotation.value()) {
            this.tryToReplaceMetaDataOfTarget(target, metaDataEntry, result);
        }
    }

    private void tryToReplaceMetaDataOfTarget(String target, MetaDataEntry metaDataEntry, List<MetaDataEntry> result) {
        try {
            if (this.isStaticSyntax(target)) {
                this.addMetaData(result, this.extractStaticMetaData(target));
            } else {
                this.addMetaData(result, this.extractDynamicMetaData(metaDataEntry, target));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void addMetaData(List<MetaDataEntry> result, MetaDataEntry[] metaDataEntries) {
        Collections.addAll(result, metaDataEntries);
    }

    private boolean isStaticSyntax(String target) {
        return target.contains(STATIC_SEPARATOR);
    }

    private MetaDataEntry[] extractStaticMetaData(String target) {
        int separatorIndex = target.lastIndexOf(STATIC_SEPARATOR);
        Class targetClass = this.loadClass(target.substring(0, separatorIndex));
        String propertyName = target.substring(separatorIndex + 1);
        return new StaticSyntaxMetaDataExtractor().extract(targetClass, propertyName).getMetaDataEntries();
    }

    private Class loadClass(String className) {
        try {
            return ClassUtils.loadClassForName((String)className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private MetaDataEntry[] extractDynamicMetaData(MetaDataEntry metaDataEntry, String target) {
        PropertyDetails propertyDetails = ExtValUtils.createPropertyDetailsForNewTarget((MetaDataEntry)metaDataEntry, (String)target);
        Class targetClass = ProxyUtils.getUnproxiedClass(propertyDetails.getBaseObject().getClass());
        return new StaticSyntaxMetaDataExtractor().extract(targetClass, propertyDetails.getProperty()).getMetaDataEntries();
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return super.hashCode();
    }

    private class StaticSyntaxMetaDataExtractor
    extends DefaultComponentMetaDataExtractor {
        private StaticSyntaxMetaDataExtractor() {
        }

        public PropertyInformation extract(Class targetClass, String targetProperty) {
            DefaultPropertyInformation propertyInformation = new DefaultPropertyInformation();
            PropertyStorage storage = ReflectionUtils.getPropertyStorage();
            ExtValAnnotationUtils.addPropertyAccessAnnotations((PropertyStorage)storage, (Class)targetClass, (String)targetProperty, (PropertyInformation)propertyInformation);
            ExtValAnnotationUtils.addFieldAccessAnnotations((PropertyStorage)storage, (Class)targetClass, (String)targetProperty, (PropertyInformation)propertyInformation);
            return propertyInformation;
        }
    }
}

