/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.frameworkAdapter;

import org.apache.myfaces.orchestra.conversation.ConversationMessager;
import org.apache.myfaces.orchestra.lib.OrchestraException;
import org.apache.myfaces.orchestra.lib._ClassUtils;

/**
 * Utility methods for the internal use of Orchestra only.
 * 
 * @since 1.1
 */
public abstract class _FrameworkAdapterUtils
{
    public static ConversationMessager createConversationMessager(String className, Class dfltClass)
    throws OrchestraException
    {
        if (className == null)
        {
            return (ConversationMessager) _ClassUtils.newInstance(dfltClass);
        }

        // First try to find a bean of that name in the dependency-injection
        // framework.
        FrameworkAdapter fa = FrameworkAdapter.getCurrentInstance();
        Object instance = fa.getBean(className);
        if (instance instanceof ConversationMessager)
        {
            return (ConversationMessager) instance;
        }

        // Now resort to trying the value as a classname.
        return (ConversationMessager) _ClassUtils.newInstance(className);
    }

}
