/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.viewController;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.orchestra.annotation.AnnotationInfo;
import org.apache.myfaces.orchestra.annotation.AnnotationInfoManager;
import org.apache.myfaces.orchestra.conversation.ConversationManager;
import org.apache.myfaces.orchestra.conversation.annotations.ConversationRequire;
import org.apache.myfaces.orchestra.frameworkAdapter.FrameworkAdapter;
import org.apache.myfaces.orchestra.lib.OrchestraException;
import org.apache.myfaces.orchestra.viewController.AbstractViewControllerManager;

public abstract class AbstractAnnotationsViewControllerManager
extends AbstractViewControllerManager {
    private AnnotationInfoManager annotationInfoManager;

    public abstract void initManager();

    public void setAnnotationInfoManager(AnnotationInfoManager annotationInfoManager) {
        this.annotationInfoManager = annotationInfoManager;
    }

    public AnnotationInfoManager getAnnotationInfoManager() {
        return this.annotationInfoManager;
    }

    public void assertConversationState(String viewId) {
        String beanName = this.getViewControllerNameMapper().mapViewId(viewId);
        if (beanName == null) {
            return;
        }
        AnnotationInfo annotationInfo = this.annotationInfoManager.getAnnotationInfoByBeanName(beanName);
        if (annotationInfo == null) {
            return;
        }
        ConversationRequire conversationRequire = annotationInfo.getConversationRequire();
        if (conversationRequire == null) {
            return;
        }
        String[] entryPoints = conversationRequire.entryPointViewIds();
        if (entryPoints != null) {
            for (String ignoredView : entryPoints) {
                if (StringUtils.isEmpty((String)ignoredView) || !ignoredView.equals(viewId)) continue;
                return;
            }
        }
        ConversationManager manager = ConversationManager.getInstance();
        String[] conversationNames = conversationRequire.conversationNames();
        if (conversationNames != null) {
            for (String conversationName : conversationNames) {
                if (manager.hasConversation(conversationName)) continue;
                this.reportInactive(manager, conversationName, conversationRequire);
                return;
            }
        }
    }

    private void reportInactive(ConversationManager manager, String conversationName, ConversationRequire conversationRequire) {
        if (manager.getMessager() != null) {
            manager.getMessager().setConversationNotActive(conversationName);
        }
        if (!StringUtils.isEmpty((String)conversationRequire.redirect())) {
            try {
                FrameworkAdapter.getCurrentInstance().redirect(conversationRequire.redirect());
            }
            catch (IOException e) {
                throw new OrchestraException((Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((String)conversationRequire.navigationAction())) {
            try {
                String dst = conversationRequire.navigationAction();
                FrameworkAdapter.getCurrentInstance().invokeNavigation(dst);
            }
            catch (IOException e) {
                throw new OrchestraException((Throwable)e);
            }
        }
    }
}

