/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.config;

import java.io.IOException;
import java.net.URL;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.myfaces.test.mock.MockRenderKit;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ConfigParser {
    private static final String[] JSFRI_RESOURCES = new String[]{"/com/sun/faces/jsf-ri-runtime.xml"};
    private static final String[] MYFACES_RESOURCES = new String[]{"/org/apache/myfaces/resource/standard-faces-config.xml"};
    private static final String[] MYFACES_RESOURCES12 = new String[]{"/META-INF/standard-faces-config.xml"};
    private Digester digester = null;

    public URL[] getPlatformURLs() {
        URL[] urls = this.translate(JSFRI_RESOURCES);
        if (urls[0] == null && (urls = this.translate(MYFACES_RESOURCES12))[0] == null) {
            urls = this.translate(MYFACES_RESOURCES);
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(URL url) throws IOException, SAXException {
        Digester digester = this.digester();
        ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        Application application = factory.getApplication();
        digester.push((Object)application);
        try {
            digester.parse(url);
        }
        finally {
            digester.clear();
        }
    }

    public void parse(URL[] urls) throws IOException, SAXException {
        for (int i = 0; i < urls.length; ++i) {
            this.parse(urls[i]);
        }
    }

    private Digester digester() {
        if (this.digester == null) {
            this.digester = new Digester();
            this.digester.addRule("faces-config/component", (Rule)new ComponentRule());
            this.digester.addCallMethod("faces-config/component/component-type", "setComponentType", 0);
            this.digester.addCallMethod("faces-config/component/component-class", "setComponentClass", 0);
            this.digester.addRule("faces-config/converter", (Rule)new ConverterRule());
            this.digester.addCallMethod("faces-config/converter/converter-id", "setConverterId", 0);
            this.digester.addCallMethod("faces-config/converter/converter-class", "setConverterClass", 0);
            this.digester.addCallMethod("faces-config/converter/converter-for-class", "setConverterForClass", 0);
            this.digester.addRule("faces-config/render-kit", (Rule)new RenderKitRule());
            this.digester.addRule("faces-config/render-kit/render-kit-id", (Rule)new RenderKitIdRule());
            this.digester.addRule("faces-config/render-kit/renderer", (Rule)new RendererRule());
            this.digester.addCallMethod("faces-config/render-kit/renderer/component-family", "setComponentFamily", 0);
            this.digester.addCallMethod("faces-config/render-kit/renderer/renderer-class", "setRendererClass", 0);
            this.digester.addCallMethod("faces-config/render-kit/renderer/renderer-type", "setRendererType", 0);
            this.digester.addRule("faces-config/render-kit/client-behavior-renderer", (Rule)new ClientBehaviorRendererRule());
            this.digester.addCallMethod("faces-config/render-kit/client-behavior-renderer/client-behavior-renderer-type", "setClientBehaviorRendererType", 0);
            this.digester.addCallMethod("faces-config/render-kit/client-behavior-renderer/client-behavior-renderer-class", "setClientBehaviorRendererClass", 0);
            this.digester.addRule("faces-config/validator", (Rule)new ValidatorRule());
            this.digester.addCallMethod("faces-config/validator/validator-id", "setValidatorId", 0);
            this.digester.addCallMethod("faces-config/validator/validator-class", "setValidatorClass", 0);
            this.digester.addRule("faces-config/behavior", (Rule)new BehaviorRule());
            this.digester.addCallMethod("faces-config/behavior/behavior-id", "setBehaviorId", 0);
            this.digester.addCallMethod("faces-config/behavior/behavior-class", "setBehaviorClass", 0);
        }
        return this.digester;
    }

    private URL[] translate(String[] names) {
        URL[] results = new URL[names.length];
        for (int i = 0; i < names.length; ++i) {
            results[i] = this.getClass().getResource(names[i]);
        }
        return results;
    }

    private Class classForName(String type) throws ClassNotFoundException {
        try {
            return Class.forName(type, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ignore) {
            return Class.forName(type, false, this.getClass().getClassLoader());
        }
    }

    class BehaviorRule
    extends Rule {
        BehaviorRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            this.getDigester().push((Object)new BehaviorBean());
        }

        public void end(String namespace, String name) {
            BehaviorBean bean = (BehaviorBean)this.getDigester().pop();
            Application application = (Application)this.getDigester().peek();
            application.addBehavior(bean.getBehaviorId(), bean.getBehaviorClass());
        }
    }

    class BehaviorBean {
        private String behaviorClass;
        private String behaviorId;

        BehaviorBean() {
        }

        public String getBehaviorClass() {
            return this.behaviorClass;
        }

        public void setBehaviorClass(String behaviorClass) {
            this.behaviorClass = behaviorClass;
        }

        public String getBehaviorId() {
            return this.behaviorId;
        }

        public void setBehaviorId(String behaviorId) {
            this.behaviorId = behaviorId;
        }
    }

    class ClientBehaviorRendererRule
    extends Rule {
        ClientBehaviorRendererRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            this.getDigester().push((Object)new ClientBehaviorRendererBean());
        }

        public void end(String namespace, String name) {
            ClientBehaviorRendererBean bean = (ClientBehaviorRendererBean)this.getDigester().pop();
            RenderKit kit = (RenderKit)this.getDigester().peek();
            ClientBehaviorRenderer renderer = null;
            Class clazz = null;
            try {
                clazz = ConfigParser.this.classForName(bean.getClientBehaviorRendererClass());
                renderer = (ClientBehaviorRenderer)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Exception while trying to instantiate client behavior renderer class '" + bean.getClientBehaviorRendererClass() + "' : " + e.getMessage());
            }
            kit.addClientBehaviorRenderer(bean.getClientBehaviorRendererType(), renderer);
        }
    }

    class ClientBehaviorRendererBean {
        private String clientBehaviorRendererType;
        private String clientBehaviorRendererClass;

        ClientBehaviorRendererBean() {
        }

        public String getClientBehaviorRendererType() {
            return this.clientBehaviorRendererType;
        }

        public void setClientBehaviorRendererType(String clientBehaviorRendererType) {
            this.clientBehaviorRendererType = clientBehaviorRendererType;
        }

        public String getClientBehaviorRendererClass() {
            return this.clientBehaviorRendererClass;
        }

        public void setClientBehaviorRendererClass(String clientBehaviorRendererClass) {
            this.clientBehaviorRendererClass = clientBehaviorRendererClass;
        }
    }

    class ValidatorRule
    extends Rule {
        ValidatorRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            this.getDigester().push((Object)new ValidatorBean());
        }

        public void end(String namespace, String name) {
            ValidatorBean bean = (ValidatorBean)this.getDigester().pop();
            Application application = (Application)this.getDigester().peek();
            application.addValidator(bean.getValidatorId(), bean.getValidatorClass());
        }
    }

    class ValidatorBean {
        private String validatorClass;
        private String validatorId;

        ValidatorBean() {
        }

        public String getValidatorClass() {
            return this.validatorClass;
        }

        public void setValidatorClass(String validatorClass) {
            this.validatorClass = validatorClass;
        }

        public String getValidatorId() {
            return this.validatorId;
        }

        public void setValidatorId(String validatorId) {
            this.validatorId = validatorId;
        }
    }

    class RendererRule
    extends Rule {
        RendererRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            this.getDigester().push((Object)new RendererBean());
        }

        public void end(String namespace, String name) {
            RendererBean bean = (RendererBean)this.getDigester().pop();
            RenderKit kit = (RenderKit)this.getDigester().peek();
            Renderer renderer = null;
            Class clazz = null;
            try {
                clazz = ConfigParser.this.classForName(bean.getRendererClass());
                renderer = (Renderer)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Exception while trying to instantiate renderer class '" + bean.getRendererClass() + "' : " + e.getMessage());
            }
            kit.addRenderer(bean.getComponentFamily(), bean.getRendererType(), renderer);
        }
    }

    class RendererBean {
        private String componentFamily;
        private String rendererClass;
        private String rendererType;

        RendererBean() {
        }

        public String getComponentFamily() {
            return this.componentFamily;
        }

        public void setComponentFamily(String componentFamily) {
            this.componentFamily = componentFamily;
        }

        public String getRendererClass() {
            return this.rendererClass;
        }

        public void setRendererClass(String rendererClass) {
            this.rendererClass = rendererClass;
        }

        public String getRendererType() {
            return this.rendererType;
        }

        public void setRendererType(String rendererType) {
            this.rendererType = rendererType;
        }
    }

    class RenderKitIdRule
    extends Rule {
        RenderKitIdRule() {
        }

        public void body(String namespace, String name, String text) {
            String renderKitId = text.trim();
            RenderKitFactory factory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            RenderKit renderKit = factory.getRenderKit(null, renderKitId);
            if (renderKit == null) {
                renderKit = new MockRenderKit();
                factory.addRenderKit(renderKitId, renderKit);
            }
            this.getDigester().pop();
            this.getDigester().push((Object)renderKit);
        }
    }

    class RenderKitRule
    extends Rule {
        RenderKitRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            RenderKitFactory factory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            this.getDigester().push((Object)factory.getRenderKit(null, "HTML_BASIC"));
        }

        public void end(String namespace, String name) {
            this.getDigester().pop();
        }
    }

    class ConverterRule
    extends Rule {
        ConverterRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            this.getDigester().push((Object)new ConverterBean());
        }

        public void end(String namespace, String name) {
            ConverterBean bean = (ConverterBean)this.getDigester().pop();
            Application application = (Application)this.getDigester().peek();
            if (bean.getConverterId() != null) {
                application.addConverter(bean.getConverterId(), bean.getConverterClass());
            } else {
                Class clazz = null;
                try {
                    clazz = ConfigParser.this.classForName(bean.getConverterForClass());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("java.lang.ClassNotFoundException: " + bean.getConverterForClass());
                }
                application.addConverter(clazz, bean.getConverterClass());
            }
        }
    }

    class ConverterBean {
        private String converterClass;
        private String converterForClass;
        private String converterId;

        ConverterBean() {
        }

        public String getConverterClass() {
            return this.converterClass;
        }

        public void setConverterClass(String converterClass) {
            this.converterClass = converterClass;
        }

        public String getConverterForClass() {
            return this.converterForClass;
        }

        public void setConverterForClass(String converterForClass) {
            this.converterForClass = converterForClass;
        }

        public String getConverterId() {
            return this.converterId;
        }

        public void setConverterId(String converterId) {
            this.converterId = converterId;
        }
    }

    class ComponentRule
    extends Rule {
        ComponentRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) {
            this.getDigester().push((Object)new ComponentBean());
        }

        public void end(String namespace, String name) {
            ComponentBean bean = (ComponentBean)this.getDigester().pop();
            Application application = (Application)this.getDigester().peek();
            application.addComponent(bean.getComponentType(), bean.getComponentClass());
        }
    }

    class ComponentBean {
        private String componentClass;
        private String componentType;

        ComponentBean() {
        }

        public String getComponentClass() {
            return this.componentClass;
        }

        public void setComponentClass(String componentClass) {
            this.componentClass = componentClass;
        }

        public String getComponentType() {
            return this.componentType;
        }

        public void setComponentType(String componentType) {
            this.componentType = componentType;
        }
    }
}

