/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.SupportsAccessKey;
import org.apache.myfaces.tobago.component.UIButton;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.component.AbstractUIForm;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.CommandRendererBase;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.Command;
import org.apache.myfaces.tobago.renderkit.html.CommandMap;
import org.apache.myfaces.tobago.renderkit.html.JsonUtils;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ButtonRenderer
extends CommandRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(ButtonRenderer.class);

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UIButton button = (UIButton)component;
        String clientId = button.getClientId(facesContext);
        boolean disabled = button.isDisabled();
        LabelWithAccessKey label = new LabelWithAccessKey((SupportsAccessKey)button);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("type", "button", false);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)button);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)button);
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        writer.writeAttribute("disabled", disabled);
        if (!disabled) {
            Integer tabIndex;
            CommandMap map = new CommandMap(new Command(facesContext, (AbstractUICommand)button));
            writer.writeAttribute("data-tobago-commands", JsonUtils.encode(map), true);
            writer.writeAttribute("href", "#", false);
            if (label.getAccessKey() != null) {
                writer.writeAttribute("accesskey", Character.toString(label.getAccessKey().charValue()), false);
                AccessKeyLogger.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey(), (String)clientId);
            }
            if ((tabIndex = button.getTabIndex()) != null) {
                writer.writeAttribute("tabindex", tabIndex.intValue());
            }
        }
        Style style = new Style(facesContext, (LayoutBase)button);
        writer.writeStyleAttribute(style);
        writer.writeClassAttribute(Classes.create((UIComponent)button));
        if (((UIButton)component).isDefaultCommand()) {
            AbstractUIForm form = (AbstractUIForm)ComponentUtils.findAncestor((UIComponent)component, AbstractUIForm.class);
            writer.writeAttribute("data-tobago-default", form.getClientId(facesContext), false);
        }
        writer.flush();
        String image = (String)button.getAttributes().get("image");
        if (image != null) {
            if (!ResourceManagerUtils.isAbsoluteResource((String)image)) {
                image = this.getImageWithPath(facesContext, image, disabled);
            }
            writer.startElement("img", null);
            writer.writeAttribute("src", image, true);
            String tip = button.getTip();
            writer.writeAttribute("alt", tip != null ? tip : "", true);
            writer.endElement("img");
        }
        if (label.getLabel() != null) {
            writer.startElement("span", null);
            HtmlRendererUtils.writeLabelWithAccessKey(writer, label);
            writer.endElement("span");
        }
        writer.endElement("button");
    }

    public Measure getPreferredWidth(FacesContext facesContext, Configurable component) {
        boolean image;
        if (!(component instanceof UIButton)) {
            return Measure.valueOf((int)100);
        }
        UIButton button = (UIButton)component;
        Measure width = Measure.ZERO;
        boolean bl = image = button.getImage() != null;
        if (image) {
            width = this.getResourceManager().getThemeMeasure(facesContext, (Configurable)button, "imageWidth");
        }
        LabelWithAccessKey label = new LabelWithAccessKey((SupportsAccessKey)button);
        width = width.add(RenderUtils.calculateStringWidth(facesContext, (UIComponent)button, label.getLabel()));
        Measure padding = this.getResourceManager().getThemeMeasure(facesContext, (Configurable)button, "paddingWidth");
        width = width.add(padding.multiply(image && label.getLabel() != null ? 3 : 2));
        return width;
    }
}

