/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.RegexValidator;
import javax.faces.validator.Validator;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIInput;
import org.apache.myfaces.tobago.internal.component.AbstractUITextarea;
import org.apache.myfaces.tobago.internal.renderkit.renderer.DecorationPositionRendererBase;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.sanitizer.SanitizeMode;
import org.apache.myfaces.tobago.sanitizer.Sanitizer;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TextareaRenderer<T extends AbstractUITextarea>
extends DecorationPositionRendererBase<T> {
    @Override
    protected boolean isOutputOnly(T component) {
        return ((AbstractUIInput)component).isDisabled() || ((AbstractUIInput)component).isReadonly();
    }

    @Override
    public HtmlElements getComponentTag() {
        return HtmlElements.TOBAGO_TEXTAREA;
    }

    @Override
    protected void setSubmittedValue(FacesContext facesContext, EditableValueHolder component, String newValue) {
        String value = newValue;
        AbstractUITextarea textarea = (AbstractUITextarea)component;
        if (ComponentUtils.getDataAttribute((UIComponent)textarea, "html-editor") != null && SanitizeMode.auto == textarea.getSanitize()) {
            Sanitizer sanitizer = TobagoConfig.getInstance(facesContext).getSanitizer();
            value = sanitizer.sanitize(newValue);
        }
        if (TobagoConfig.getInstance(facesContext).isDecodeLineFeed()) {
            value = value.replace("\r\n", "\n");
        }
        super.setSubmittedValue(facesContext, (EditableValueHolder)textarea, value);
    }

    @Override
    public void encodeBeginField(FacesContext facesContext, T component) throws IOException {
        String currentValue;
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        String clientId = component.getClientId(facesContext);
        String fieldId = ((AbstractUIInput)component).getFieldId(facesContext);
        Integer rows = ((AbstractUITextarea)component).getRows();
        boolean readonly = ((AbstractUIInput)component).isReadonly();
        boolean disabled = ((AbstractUIInput)component).isDisabled();
        Markup markup = component.getMarkup() != null ? component.getMarkup() : Markup.NULL;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.TEXTAREA, (UIComponent)component);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(fieldId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.ROWS, rows);
        writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, component.isRequired());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, ((AbstractUIInput)component).getTabIndex());
        writer.writeAttribute(HtmlAttributes.AUTOCOMPLETE, component.getAutocompleteString(), true);
        if (component.getAccessKey() != null) {
            writer.writeAttribute(HtmlAttributes.ACCESSKEY, Character.toString(component.getAccessKey().charValue()), false);
            AccessKeyLogger.addAccessKey(facesContext, component.getAccessKey(), clientId);
        }
        writer.writeClassAttribute(BootstrapClass.validationColor(ComponentUtils.getMaximumSeverity(component)), BootstrapClass.FORM_CONTROL, component.getCustomClass(), markup.contains(Markup.LARGE) ? BootstrapClass.FORM_CONTROL_LG : null, markup.contains(Markup.SMALL) ? BootstrapClass.FORM_CONTROL_SM : null, markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null);
        int maxLength = 0;
        int minLength = 0;
        String pattern = null;
        for (Validator validator : component.getValidators()) {
            if (validator instanceof LengthValidator) {
                LengthValidator lengthValidator = (LengthValidator)validator;
                maxLength = lengthValidator.getMaximum();
                minLength = lengthValidator.getMinimum();
                continue;
            }
            if (!(validator instanceof RegexValidator)) continue;
            RegexValidator regexValidator = (RegexValidator)validator;
            pattern = regexValidator.getPattern();
        }
        if (maxLength > 0) {
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MAXLENGTH, maxLength);
        }
        if (minLength > 0) {
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MINLENGTH, minLength);
        }
        if (pattern != null) {
            writer.writeAttribute(HtmlAttributes.PATTERN, pattern, true);
        }
        TextareaRenderer.renderFocus(clientId, ((AbstractUIInput)component).isFocus(), ((AbstractUIInput)component).isError(), facesContext, writer);
        String placeholder = ((AbstractUITextarea)component).getPlaceholder();
        if (!disabled && !readonly && StringUtils.isNotBlank(placeholder)) {
            writer.writeAttribute(HtmlAttributes.PLACEHOLDER, placeholder, true);
        }
        if ((currentValue = this.getCurrentValue(facesContext, component)) != null) {
            if (ComponentUtils.getDataAttribute(component, "html-editor") != null && SanitizeMode.auto == ((AbstractUITextarea)component).getSanitize()) {
                Sanitizer sanitizer = TobagoConfig.getInstance(facesContext).getSanitizer();
                currentValue = sanitizer.sanitize(currentValue);
            }
            if (currentValue.startsWith("\r\n")) {
                currentValue = "\r\n" + currentValue;
            } else if (currentValue.startsWith("\n")) {
                currentValue = "\n" + currentValue;
            } else if (currentValue.startsWith("\r")) {
                currentValue = "\r" + currentValue;
            }
            writer.writeText(currentValue);
        }
        writer.endElement(HtmlElements.TEXTAREA);
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)component);
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, T component) throws IOException {
    }

    @Override
    protected String getFieldId(FacesContext facesContext, T component) {
        return ((AbstractUIInput)component).getFieldId(facesContext);
    }
}

