/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.facelets;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributeException;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TagHandler;
import java.io.IOException;

public class ConverterHandler
extends TagHandler {
    private final TagAttribute converterId;
    private final TagAttribute binding = this.getAttribute("binding");

    public ConverterHandler(TagConfig config) {
        super(config);
        this.converterId = this.getAttribute("type");
    }

    public void apply(FaceletContext faceletContext, UIComponent parent) throws IOException, ELException {
        if (parent instanceof ValueHolder) {
            if (ComponentHandler.isNew((UIComponent)parent)) {
                ValueHolder valueHolder = (ValueHolder)parent;
                Converter converter = null;
                ValueExpression valueExpression = null;
                if (this.binding != null) {
                    valueExpression = this.binding.getValueExpression(faceletContext, Converter.class);
                    converter = (Converter)valueExpression.getValue((ELContext)faceletContext);
                }
                if (converter == null) {
                    try {
                        converter = FacesContext.getCurrentInstance().getApplication().createConverter((String)this.converterId.getValueExpression(faceletContext, String.class).getValue((ELContext)faceletContext));
                    }
                    catch (Exception e) {
                        throw new TagAttributeException(this.tag, this.converterId, e.getCause());
                    }
                    if (valueExpression != null) {
                        valueExpression.setValue((ELContext)faceletContext, (Object)converter);
                    }
                }
                if (converter != null) {
                    valueHolder.setConverter(converter);
                }
            }
        } else {
            throw new TagException(this.tag, "Parent is not of type ValueHolder, type is: " + parent);
        }
    }
}

