/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.encode;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.image.encode.OctreeNode;
import org.apache.myfaces.trinidadinternal.image.painter.ImageLoader;

class OctreeQuantizer {
    private static final int _MAX_COLORS = 255;
    private int _colors;
    private OctreeNode[] _listHead;
    private OctreeNode[] _listEnd;
    private int _maxDepth = 8;
    private OctreeNode _root = new OctreeNode(this);
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(OctreeQuantizer.class);

    public OctreeQuantizer(Image im) {
        this();
        ImageLoader il = new ImageLoader(im);
        il.start();
        if (!il.waitFor()) {
            throw new IllegalArgumentException(_LOG.getMessage("PROBLEM_LOADING"));
        }
        int width = im.getWidth(il);
        int height = im.getHeight(il);
        int[] pixels = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(im.getSource(), 0, 0, width, height, pixels, 0, width);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            throw new IllegalArgumentException(_LOG.getMessage("GRABBING_PIXELS"));
        }
        if ((grabber.getStatus() & 0x80) != 0) {
            throw new IllegalArgumentException(_LOG.getMessage("ERROR_FETCHING_IMAGE", new Object[]{pixels.length, width, height}));
        }
        for (int i = 0; i < pixels.length; ++i) {
            this.addColor(pixels[i]);
        }
    }

    public static void mapColors(int[] pixels) {
        int i;
        OctreeQuantizer o = new OctreeQuantizer();
        for (i = 0; i < pixels.length; ++i) {
            o.addColor(pixels[i]);
        }
        for (i = 0; i < pixels.length; ++i) {
            pixels[i] = o.mapColor(pixels[i]);
        }
    }

    public void addColor(int rgb) {
        this._root.addColor(rgb);
    }

    public int mapColor(int rgb) {
        return this._root.mapColor(rgb);
    }

    OctreeNode _getListHead(int i) {
        return this._listHead[i];
    }

    int _getMaxDepth() {
        return this._maxDepth;
    }

    void _incColors() {
        if (++this._colors > 255) {
            this._reduce();
        }
    }

    void _setListHead(int i, OctreeNode n) {
        this._listHead[i] = n;
        this._listEnd[i] = n;
    }

    void _setListEnd(int i, OctreeNode n) {
        this._listEnd[i]._setNext(n);
        this._listEnd[i] = n;
    }

    private OctreeQuantizer() {
        this._listHead = new OctreeNode[8];
        this._listEnd = new OctreeNode[8];
    }

    private OctreeNode _pickNode() {
        for (int i = this._maxDepth - 2; i >= 0; --i) {
            OctreeNode p = null;
            OctreeNode saveNode = null;
            OctreeNode savePrev = null;
            for (OctreeNode n = this._getListHead(i); n != null; n = n._getNext()) {
                if (n._getChildren() > 1 && (saveNode == null || n._getChildren() < saveNode._getChildren())) {
                    saveNode = n;
                    savePrev = p;
                }
                p = n;
            }
            if (saveNode != null) {
                if (savePrev == null) {
                    this._listHead[i] = saveNode._getNext();
                } else {
                    OctreeNode nextNode = saveNode._getNext();
                    if (nextNode == null) {
                        this._listEnd[i] = savePrev;
                    }
                    savePrev._setNext(nextNode);
                }
                return saveNode;
            }
            --this._maxDepth;
        }
        return null;
    }

    private void _reduce() {
        OctreeNode n = this._pickNode();
        n._setMaxLevel(n._getLevel());
        n._computeColor();
        this._colors -= n._getChildren() - 1;
        n._setChildren(0);
    }
}

