/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.UIXCollection;
import org.apache.myfaces.trinidad.component.UIXTable;
import org.apache.myfaces.trinidad.component.core.data.CoreTable;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ShowDetailRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.SpecialColumnRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;

public class DetailColumnRenderer
extends SpecialColumnRenderer {
    private final CoreRenderer _detailRenderer = new Detail();

    @Override
    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
        if (tContext.getRenderStage().getStage() == 0) {
            tContext.setExplicitHeaderIDMode(true);
            int physicalIndex = tContext.getColumnData().getPhysicalColumnIndex();
            tContext.setDetailColumnIndex(physicalIndex);
        }
        super.encodeAll(context, rc, component, bean);
    }

    @Override
    protected String getHeaderText(UIComponent component, FacesBean bean) {
        RenderingContext arc = RenderingContext.getCurrentInstance();
        return arc.getTranslatedString("af_table.DETAIL_COLUMN_HEADER");
    }

    @Override
    protected boolean getNoWrap(UIComponent component, FacesBean bean) {
        return true;
    }

    @Override
    protected void renderKids(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent column) throws IOException {
        this.delegateRenderer(context, rc, tContext.getTable(), this.getFacesBean(tContext.getTable()), this._detailRenderer);
    }

    private static class Detail
    extends ShowDetailRenderer {
        public Detail() {
            super(CoreTable.TYPE);
        }

        @Override
        protected void renderAllAttributes(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) {
        }

        @Override
        protected void renderPromptStart(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
            component = ((UIXTable)component).getDetailStamp();
            super.renderPromptStart(context, rc, component, bean);
        }

        @Override
        protected String getValueParameter(UIComponent component) {
            UIXCollection cb = (UIXCollection)component;
            int rowIndex = cb.getRowIndex();
            return IntegerUtils.getString((int)rowIndex);
        }

        @Override
        protected boolean isTableDetailDisclosure() {
            return true;
        }

        @Override
        protected boolean getDisclosed(UIComponent component, FacesBean bean) {
            TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
            UIXTable table = (UIXTable)tContext.getCollectionComponent();
            return table.getDisclosedRowKeys().isContained();
        }

        @Override
        protected String getLinkId(String rootId, boolean disclosed) {
            return Detail._getDetailLinkId(TableRenderingContext.getCurrentInstance());
        }

        protected String getClientId(FacesContext context, UIComponent component) {
            TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
            return tContext.getTableId();
        }

        private static String _getDetailLinkId(TableRenderingContext tContext) {
            String tableId = tContext.getTableId();
            if (tableId == null) {
                return null;
            }
            int currentRow = tContext.getCollectionComponent().getRowIndex();
            String currentRowString = IntegerUtils.getString((int)currentRow);
            StringBuffer buffer = new StringBuffer(tableId.length() + currentRowString.length() + 2);
            buffer.append(tableId);
            buffer.append("dd");
            buffer.append(currentRowString);
            return buffer.toString();
        }
    }
}

