/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.xml;

import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.expl.ExpressionContext;
import org.apache.myfaces.trinidadinternal.share.expl.PrefixMapper;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;

public final class NamespaceURI {
    private final String _ns;
    private final String _name;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(NamespaceURI.class);

    public NamespaceURI(String namespace, String name) {
        this._ns = namespace.intern();
        this._name = name;
    }

    public String getNamespace() {
        return this._ns;
    }

    public String getName() {
        return this._name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NamespaceURI) {
            NamespaceURI ns = (NamespaceURI)obj;
            return ns._ns.equals(this._ns) && ns._name.equals(this._name);
        }
        return false;
    }

    public int hashCode() {
        return this._ns.hashCode() + this._name.hashCode();
    }

    public static NamespaceURI create(ExpressionContext context, String qname, String defaultURI) {
        String name;
        String uri;
        boolean isAlias;
        PrefixMapper pmapper = context.getPrefixMapper();
        int doubleColonIndex = qname.indexOf("::");
        int colonIndex = qname.indexOf(58);
        boolean bl = isAlias = qname.indexOf(":alias") > -1;
        if (colonIndex > 0 && colonIndex != doubleColonIndex && !isAlias) {
            String prefix = qname.substring(0, colonIndex);
            uri = pmapper.getNamespaceURI(prefix);
            if (uri == null) {
                throw new IllegalArgumentException(_LOG.getMessage("UNDECLARED_PREFIX", (Object)prefix));
            }
            name = qname.substring(colonIndex + 1);
        } else {
            name = qname;
            uri = defaultURI;
        }
        return new NamespaceURI(uri, name);
    }

    @Deprecated
    public static NamespaceURI create(ParseContext context, String qname, String defaultURI) {
        try {
            return NamespaceURI.create(context.getExpressionContext(), qname, defaultURI);
        }
        catch (RuntimeException e) {
            _LOG.severe((Throwable)e);
            return null;
        }
    }
}

