/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package javax.faces.component.html;

import javax.faces.component.UIComponent;
import javax.faces.el.ValueBinding;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;


// Generated from class javax.faces.component.html._HtmlInputText.
//
// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.
public class HtmlInputText extends javax.faces.component.UIInput
{

    static public final String COMPONENT_TYPE =
        "javax.faces.HtmlInputText";


    public HtmlInputText()
    {
        setRendererType("javax.faces.Text");
    }

    

    // Property: maxlength
    private int _maxlength;
    private boolean _maxlengthSet;
    
    public int getMaxlength()
    {
        if (_maxlengthSet)
        {
            return _maxlength;
        }
        ValueBinding vb = getValueBinding("maxlength");
        if (vb != null)
        {
            return ((Integer) vb.getValue(getFacesContext())).intValue();
        }
        return Integer.MIN_VALUE; 
    }

    public void setMaxlength(int maxlength)
    {
        this._maxlength = maxlength;
        this._maxlengthSet = true;        
    }
    // Property: size
    private int _size;
    private boolean _sizeSet;
    
    public int getSize()
    {
        if (_sizeSet)
        {
            return _size;
        }
        ValueBinding vb = getValueBinding("size");
        if (vb != null)
        {
            return ((Integer) vb.getValue(getFacesContext())).intValue();
        }
        return Integer.MIN_VALUE; 
    }

    public void setSize(int size)
    {
        this._size = size;
        this._sizeSet = true;        
    }
    // Property: style
    private String _style;
    public String getStyle()
    {
        if (_style != null)
        {
            return _style;
        }
        ValueBinding vb = getValueBinding("style");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setStyle(String style)
    {
        this._style = style;
    }
    // Property: styleClass
    private String _styleClass;
    public String getStyleClass()
    {
        if (_styleClass != null)
        {
            return _styleClass;
        }
        ValueBinding vb = getValueBinding("styleClass");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setStyleClass(String styleClass)
    {
        this._styleClass = styleClass;
    }
    // Property: alt
    private String _alt;
    public String getAlt()
    {
        if (_alt != null)
        {
            return _alt;
        }
        ValueBinding vb = getValueBinding("alt");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setAlt(String alt)
    {
        this._alt = alt;
    }
    // Property: tabindex
    private String _tabindex;
    public String getTabindex()
    {
        if (_tabindex != null)
        {
            return _tabindex;
        }
        ValueBinding vb = getValueBinding("tabindex");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setTabindex(String tabindex)
    {
        this._tabindex = tabindex;
    }
    // Property: onblur
    private String _onblur;
    public String getOnblur()
    {
        if (_onblur != null)
        {
            return _onblur;
        }
        ValueBinding vb = getValueBinding("onblur");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setOnblur(String onblur)
    {
        this._onblur = onblur;
    }
    // Property: onfocus
    private String _onfocus;
    public String getOnfocus()
    {
        if (_onfocus != null)
        {
            return _onfocus;
        }
        ValueBinding vb = getValueBinding("onfocus");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setOnfocus(String onfocus)
    {
        this._onfocus = onfocus;
    }
    // Property: accesskey
    private String _accesskey;
    public String getAccesskey()
    {
        if (_accesskey != null)
        {
            return _accesskey;
        }
        ValueBinding vb = getValueBinding("accesskey");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setAccesskey(String accesskey)
    {
        this._accesskey = accesskey;
    }
    // Property: onclick
    private String _onclick;
    public String getOnclick()
    {
        if (_onclick != null)
        {
            return _onclick;
        }
        ValueBinding vb = getValueBinding("onclick");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setOnclick(String onclick)
    {
        this._onclick = onclick;
    }
    // Property: ondblclick
    private String _ondblclick;
    public String getOndblclick()
    {
        if (_ondblclick != null)
        {
            return _ondblclick;
        }
        ValueBinding vb = getValueBinding("ondblclick");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setOndblclick(String ondblclick)
    {
        this._ondblclick = ondblclick;
    }
    // Property: onkeydown
    private String _onkeydown;
    public String getOnkeydown()
    {
        if (_onkeydown != null)
        {
            return _onkeydown;
        }
        ValueBinding vb = getValueBinding("onkeydown");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setOnkeydown(String onkeydown)
    {
        this._onkeydown = onkeydown;
    }
    // Property: onkeypress
    private String _onkeypress;
    public String getOnkeypress()
    {
        if (_onkeypress != null)
        {
            return _onkeypress;
        }
        ValueBinding vb = getValueBinding("onkeypress");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setOnkeypress(String onkeypress)
    {
        this._onkeypress = onkeypress;
    }
    // Property: onkeyup
    private String _onkeyup;
    public String getOnkeyup()
    {
        if (_onkeyup != null)
        {
            return _onkeyup;
        }
        ValueBinding vb = getValueBinding("onkeyup");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setOnkeyup(String onkeyup)
    {
        this._onkeyup = onkeyup;
    }
    // Property: onmousedown
    private String _onmousedown;
    public String getOnmousedown()
    {
        if (_onmousedown != null)
        {
            return _onmousedown;
        }
        ValueBinding vb = getValueBinding("onmousedown");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setOnmousedown(String onmousedown)
    {
        this._onmousedown = onmousedown;
    }
    // Property: onmousemove
    private String _onmousemove;
    public String getOnmousemove()
    {
        if (_onmousemove != null)
        {
            return _onmousemove;
        }
        ValueBinding vb = getValueBinding("onmousemove");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setOnmousemove(String onmousemove)
    {
        this._onmousemove = onmousemove;
    }
    // Property: onmouseout
    private String _onmouseout;
    public String getOnmouseout()
    {
        if (_onmouseout != null)
        {
            return _onmouseout;
        }
        ValueBinding vb = getValueBinding("onmouseout");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setOnmouseout(String onmouseout)
    {
        this._onmouseout = onmouseout;
    }
    // Property: onmouseover
    private String _onmouseover;
    public String getOnmouseover()
    {
        if (_onmouseover != null)
        {
            return _onmouseover;
        }
        ValueBinding vb = getValueBinding("onmouseover");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setOnmouseover(String onmouseover)
    {
        this._onmouseover = onmouseover;
    }
    // Property: onmouseup
    private String _onmouseup;
    public String getOnmouseup()
    {
        if (_onmouseup != null)
        {
            return _onmouseup;
        }
        ValueBinding vb = getValueBinding("onmouseup");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setOnmouseup(String onmouseup)
    {
        this._onmouseup = onmouseup;
    }
    // Property: onchange
    private String _onchange;
    public String getOnchange()
    {
        if (_onchange != null)
        {
            return _onchange;
        }
        ValueBinding vb = getValueBinding("onchange");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setOnchange(String onchange)
    {
        this._onchange = onchange;
    }
    // Property: onselect
    private String _onselect;
    public String getOnselect()
    {
        if (_onselect != null)
        {
            return _onselect;
        }
        ValueBinding vb = getValueBinding("onselect");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setOnselect(String onselect)
    {
        this._onselect = onselect;
    }
    // Property: dir
    private String _dir;
    public String getDir()
    {
        if (_dir != null)
        {
            return _dir;
        }
        ValueBinding vb = getValueBinding("dir");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setDir(String dir)
    {
        this._dir = dir;
    }
    // Property: lang
    private String _lang;
    public String getLang()
    {
        if (_lang != null)
        {
            return _lang;
        }
        ValueBinding vb = getValueBinding("lang");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setLang(String lang)
    {
        this._lang = lang;
    }
    // Property: title
    private String _title;
    public String getTitle()
    {
        if (_title != null)
        {
            return _title;
        }
        ValueBinding vb = getValueBinding("title");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setTitle(String title)
    {
        this._title = title;
    }
    // Property: disabled
    private boolean _disabled;
    private boolean _disabledSet;
    
    public boolean isDisabled()
    {
        if (_disabledSet)
        {
            return _disabled;
        }
        ValueBinding vb = getValueBinding("disabled");
        if (vb != null)
        {
            return ((Boolean) vb.getValue(getFacesContext())).booleanValue();
        }
        return false; 
    }

    public void setDisabled(boolean disabled)
    {
        this._disabled = disabled;
        this._disabledSet = true;        
    }
    // Property: readonly
    private boolean _readonly;
    private boolean _readonlySet;
    
    public boolean isReadonly()
    {
        if (_readonlySet)
        {
            return _readonly;
        }
        ValueBinding vb = getValueBinding("readonly");
        if (vb != null)
        {
            return ((Boolean) vb.getValue(getFacesContext())).booleanValue();
        }
        return false; 
    }

    public void setReadonly(boolean readonly)
    {
        this._readonly = readonly;
        this._readonlySet = true;        
    }

    public Object saveState(FacesContext facesContext)
    {
        Object[] values = new Object[31];
        values[0] = super.saveState(facesContext);
        values[1] = new Integer(_maxlength);
        values[2] = Boolean.valueOf(_maxlengthSet);
        values[3] = new Integer(_size);
        values[4] = Boolean.valueOf(_sizeSet);
        values[5] = _style;
        values[6] = _styleClass;
        values[7] = _alt;
        values[8] = _tabindex;
        values[9] = _onblur;
        values[10] = _onfocus;
        values[11] = _accesskey;
        values[12] = _onclick;
        values[13] = _ondblclick;
        values[14] = _onkeydown;
        values[15] = _onkeypress;
        values[16] = _onkeyup;
        values[17] = _onmousedown;
        values[18] = _onmousemove;
        values[19] = _onmouseout;
        values[20] = _onmouseover;
        values[21] = _onmouseup;
        values[22] = _onchange;
        values[23] = _onselect;
        values[24] = _dir;
        values[25] = _lang;
        values[26] = _title;
        values[27] = Boolean.valueOf(_disabled);
        values[28] = Boolean.valueOf(_disabledSet);
        values[29] = Boolean.valueOf(_readonly);
        values[30] = Boolean.valueOf(_readonlySet);
        return values; 
    }

    public void restoreState(FacesContext facesContext, Object state)
    {
        Object[] values = (Object[])state;
        super.restoreState(facesContext,values[0]);
        _maxlength = ((Integer) values[1]).intValue();
        _maxlengthSet = ((Boolean) values[2]).booleanValue();
        _size = ((Integer) values[3]).intValue();
        _sizeSet = ((Boolean) values[4]).booleanValue();
        _style = (java.lang.String) values[5];
        _styleClass = (java.lang.String) values[6];
        _alt = (java.lang.String) values[7];
        _tabindex = (java.lang.String) values[8];
        _onblur = (java.lang.String) values[9];
        _onfocus = (java.lang.String) values[10];
        _accesskey = (java.lang.String) values[11];
        _onclick = (java.lang.String) values[12];
        _ondblclick = (java.lang.String) values[13];
        _onkeydown = (java.lang.String) values[14];
        _onkeypress = (java.lang.String) values[15];
        _onkeyup = (java.lang.String) values[16];
        _onmousedown = (java.lang.String) values[17];
        _onmousemove = (java.lang.String) values[18];
        _onmouseout = (java.lang.String) values[19];
        _onmouseover = (java.lang.String) values[20];
        _onmouseup = (java.lang.String) values[21];
        _onchange = (java.lang.String) values[22];
        _onselect = (java.lang.String) values[23];
        _dir = (java.lang.String) values[24];
        _lang = (java.lang.String) values[25];
        _title = (java.lang.String) values[26];
        _disabled = ((Boolean) values[27]).booleanValue();
        _disabledSet = ((Boolean) values[28]).booleanValue();
        _readonly = ((Boolean) values[29]).booleanValue();
        _readonlySet = ((Boolean) values[30]).booleanValue();
    }
}
