/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package javax.faces.component;

import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;


// Generated from class javax.faces.component._UIMessage.
//
// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.
public class UIMessage extends javax.faces.component.UIComponentBase
{

    static public final String COMPONENT_FAMILY =
        "javax.faces.Message";
    static public final String COMPONENT_TYPE =
        "javax.faces.Message";


    public UIMessage()
    {
        setRendererType("javax.faces.Message");
    }

    @Override    
    public String getFamily()
    {
        return COMPONENT_FAMILY;
    }
    

    // Property: for
    private String _for;
    
    public String getFor()
    {
        if (_for != null)
        {
            return _for;
        }
        ValueExpression vb = getValueExpression("for");
        if (vb != null)
        {
            return (String) vb.getValue(getFacesContext().getELContext());
        }
        return null;
    }

    public void setFor(String forParam)
    {
        this._for = forParam;
    }
    // Property: showDetail
    private boolean _showDetail;
    
    private boolean _showDetailSet;
    
    public boolean isShowDetail()
    {
        if (_showDetailSet)
        {
            return _showDetail;
        }
        ValueExpression vb = getValueExpression("showDetail");
        if (vb != null)
        {
            return ((Boolean) vb.getValue(getFacesContext().getELContext())).booleanValue();
        }
        return true; 
    }

    public void setShowDetail(boolean showDetail)
    {
        this._showDetail = showDetail;
        this._showDetailSet = true;        
    }
    // Property: showSummary
    private boolean _showSummary;
    
    private boolean _showSummarySet;
    
    public boolean isShowSummary()
    {
        if (_showSummarySet)
        {
            return _showSummary;
        }
        ValueExpression vb = getValueExpression("showSummary");
        if (vb != null)
        {
            return ((Boolean) vb.getValue(getFacesContext().getELContext())).booleanValue();
        }
        return false; 
    }

    public void setShowSummary(boolean showSummary)
    {
        this._showSummary = showSummary;
        this._showSummarySet = true;        
    }

    @Override
    public Object saveState(FacesContext facesContext)
    {
        Object[] values = new Object[6];
        values[0] = super.saveState(facesContext);
        values[1] = _for;
        values[2] = Boolean.valueOf(_showDetail);
        values[3] = Boolean.valueOf(_showDetailSet);
        values[4] = Boolean.valueOf(_showSummary);
        values[5] = Boolean.valueOf(_showSummarySet);
        return values; 
    }

    @Override
    public void restoreState(FacesContext facesContext, Object state)
    {
        Object[] values = (Object[])state;
        super.restoreState(facesContext,values[0]);
        _for = (java.lang.String) values[1];
        _showDetail = ((Boolean) values[2]).booleanValue();
        _showDetailSet = ((Boolean) values[3]).booleanValue();
        _showSummary = ((Boolean) values[4]).booleanValue();
        _showSummarySet = ((Boolean) values[5]).booleanValue();
    }
}
