/* Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

package org.apache.myfaces.portlet.faces.application;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.el.ELContextListener;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;

import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ReferenceSyntaxException;

import javax.portlet.faces.BridgeUtil;
import javax.portlet.faces.annotation.ExcludeFromManagedRequestScope;
import javax.portlet.faces.annotation.PortletNamingContainer;
import javax.portlet.faces.component.PortletNamingContainerUIViewRoot;


public class PortletApplicationImpl extends Application
{
  private Application mWrapped;
  
  public PortletApplicationImpl(Application app)
  {
    mWrapped = app;
  }
  
  // The following concrete methods were added for JSF 1.2.  They supply default 
  // implementations that throw UnsupportedOperationException.  
  // This allows old Application implementations to still work.
  public void addELResolver(ELResolver resolver) {
      mWrapped.addELResolver(resolver);
  }
  
  public ELResolver getELResolver() {
      return mWrapped.getELResolver();
  }
  
  public ResourceBundle getResourceBundle(FacesContext ctx, String name) 
          throws FacesException, NullPointerException {
      return mWrapped.getResourceBundle(ctx, name);
  }
  
  public UIComponent createComponent(ValueExpression componentExpression,
                                     FacesContext facesContext,
                                     String componentType) 
          throws FacesException, NullPointerException {
      return mWrapped.createComponent(componentExpression, facesContext, componentType);
  }

  public ExpressionFactory getExpressionFactory() {
      return mWrapped.getExpressionFactory();
  }
  
  public void addELContextListener(ELContextListener listener) {
      mWrapped.addELContextListener(listener);
  }
  
  public void removeELContextListener(ELContextListener listener) {
      mWrapped.removeELContextListener(listener);
  }
  
  public ELContextListener[] getELContextListeners() {
      return mWrapped.getELContextListeners();
  }
  
  public Object evaluateExpressionGet(FacesContext context,
                                      String expression,
                                      Class expectedType)
           throws ELException {
      return mWrapped.evaluateExpressionGet(context, expression, expectedType);
  }
  
  public javax.faces.event.ActionListener getActionListener()
  {
    return mWrapped.getActionListener();
  }

  public void setActionListener(javax.faces.event.ActionListener listener)
  {
    mWrapped.setActionListener(listener);
  }

  public Locale getDefaultLocale()
  {
    return mWrapped.getDefaultLocale();
  }

  public void setDefaultLocale(Locale locale)
  {
    mWrapped.setDefaultLocale(locale);
  }

  public String getDefaultRenderKitId()
  {
    return mWrapped.getDefaultRenderKitId();
  }

  public void setDefaultRenderKitId(String renderKitId)
  {
    mWrapped.setDefaultRenderKitId(renderKitId);
  }

  public String getMessageBundle()
  {
    return mWrapped.getMessageBundle();
  }

  public void setMessageBundle(String bundle)
  {
    mWrapped.setMessageBundle(bundle);
  }

  /**
   * Return the NavigationHandler object which is responsible for mapping from
   * a logical (viewid, fromAction, outcome) to the URL of a view to be rendered.
   */
  public javax.faces.application.NavigationHandler getNavigationHandler()
  {
    return mWrapped.getNavigationHandler();
  }

  public void setNavigationHandler(javax.faces.application.NavigationHandler handler)
  {
    mWrapped.setNavigationHandler(handler);
  }

  /**
   * Get the object used by the VariableResolver to read and write named properties
   * on java beans, Arrays, Lists and Maps. This object is used by the ValueBinding
   * implementation, and during the process of configuring "managed bean" properties.
   *
   * @deprecated
   */
  public javax.faces.el.PropertyResolver getPropertyResolver()
  {
    return mWrapped.getPropertyResolver();
  }

  /**
   * @deprecated
   */
  public void setPropertyResolver(javax.faces.el.PropertyResolver resolver)
  {
    mWrapped.setPropertyResolver(resolver);
  }

  /**
   * Get the object used to resolve expressions of form "#{...}".
   *
   * @deprecated
   */
  public javax.faces.el.VariableResolver getVariableResolver()
  {
    return mWrapped.getVariableResolver();
  }

  /**
   * @deprecated
   */
  public void setVariableResolver(javax.faces.el.VariableResolver resolver)
  {
    mWrapped.setVariableResolver(resolver);
  }
  
  public javax.faces.application.ViewHandler getViewHandler()
  {
    return mWrapped.getViewHandler();
  }

  public void setViewHandler(javax.faces.application.ViewHandler handler)
  {
    mWrapped.setViewHandler(handler);
  }

  public javax.faces.application.StateManager getStateManager()
  {
    return mWrapped.getStateManager();
  }

  public void setStateManager(javax.faces.application.StateManager manager)
  {
    mWrapped.setStateManager(manager);
  }

  /**
   * Define a new mapping from a logical "component type" to an actual java class name.
   * This controls what type is created when method createComponent of this class is
   * called.
   * <p>
   * Param componentClass must be the fully-qualified class name of some class
   * extending the UIComponent class. The class must have a default constructor,
   * as instances of it will be created using Class.newInstance.
   * <p> 
   * It is permitted to override a previously defined mapping, ie to call this
   * method multiple times with the same componentType string. The createComponent
   * method will simply use the last defined mapping.
   */
  public void addComponent(String componentType,
                                    String componentClass)
  {
    mWrapped.addComponent(componentType, componentClass);
  }

  
  /**
   * Create a new UIComponent subclass, using the mappings defined by previous
   * calls to the addComponent method of this class.
   * <p>
   * @throws FacesException if there is no mapping defined for the specified
   * componentType, or if an instance of the specified type could not be
   * created for any reason.
   */
  public javax.faces.component.UIComponent createComponent(String componentType)
          throws FacesException
  {
    UIComponent component = mWrapped.createComponent(componentType);
    if (BridgeUtil.isPortletRequest() &&
        component.getClass() == UIViewRoot.class &&
        UIViewRoot.class.getAnnotation(PortletNamingContainer.class) == null
       )
    {
      // replace with our own UIViewRoot
      component = new PortletNamingContainerUIViewRoot();
    }
    return component;
  }

  /**
   * Create an object which has an associating "binding" expression tying the component
   * to a user property.
   * <p>
   * First the specified value-binding is evaluated; if it returns a non-null value then
   * the component "already exists" and so the resulting value is simply returned.
   * <p>
   * Otherwise a new UIComponent instance is created using the specified componentType,
   * and the new object stored via the provided value-binding before being returned.
   *
   * @deprecated
   */
  public javax.faces.component.UIComponent createComponent(
          javax.faces.el.ValueBinding componentBinding,
          javax.faces.context.FacesContext context,
          String componentType)
          throws FacesException
  {
    return mWrapped.createComponent(componentBinding, context, componentType);
  }
  
  public Iterator<String> getComponentTypes()
  {
    return mWrapped.getComponentTypes();
  }

  public void addConverter(String converterId,
                                    String converterClass)
  {
    mWrapped.addConverter(converterId, converterClass);
  }

  public void addConverter(Class targetClass,
                                    String converterClass)
  {
    mWrapped.addConverter(targetClass, converterClass);
  }

  public javax.faces.convert.Converter createConverter(String converterId)
  {
    return mWrapped.createConverter(converterId);
  }

  public javax.faces.convert.Converter createConverter(Class targetClass)
  {
    return mWrapped.createConverter(targetClass);
  }

  public Iterator<String> getConverterIds()
  {
    return mWrapped.getConverterIds();
  }

  public Iterator<Class> getConverterTypes()
  {
    return mWrapped.getConverterTypes();
  }

  /**
   * Create an object which can be used to invoke an arbitrary method via an
   * EL expression at a later time. This is similar to createValueBinding 
   * except that it can invoke an arbitrary method (with parameters) rather
   * than just get/set a javabean property.
   * <p>
   * This is used to invoke ActionListener method, and ValueChangeListener
   * methods.
   *
   * @deprecated
   */
  public javax.faces.el.MethodBinding createMethodBinding(
          String ref, Class[] params)
          throws ReferenceSyntaxException
  {
    return mWrapped.createMethodBinding(ref, params);
  }

  public Iterator<Locale> getSupportedLocales()
  {
    return mWrapped.getSupportedLocales();
  }

  public void setSupportedLocales(Collection<Locale> locales)
  {
    mWrapped.setSupportedLocales(locales);
  }

  public void addValidator(String validatorId,
                                    String validatorClass)
  {
    mWrapped.addValidator(validatorId, validatorClass);
  }

  public javax.faces.validator.Validator createValidator(String validatorId)
          throws FacesException
  {
    return mWrapped.createValidator(validatorId);
  }

  public Iterator<String> getValidatorIds()
  {
    return mWrapped.getValidatorIds();
  }

  /**
   * Create an object which can be used to invoke an arbitrary method via an
   * EL expression at a later time. This is similar to createValueBinding 
   * except that it can invoke an arbitrary method (with parameters) rather
   * than just get/set a javabean property.
   * <p>
   * This is used to invoke ActionListener method, and ValueChangeListener
   * methods.
   *
   * @deprecated
   */
  public javax.faces.el.ValueBinding createValueBinding(String ref)
          throws ReferenceSyntaxException
  {
    return mWrapped.createValueBinding(ref);
  }
  
}