/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.api;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectGenerator;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class J2SEProjectBuilder {
    private static final Logger LOG = Logger.getLogger(J2SEProjectBuilder.class.getName());
    private static final String DEFAULT_PLATFORM_ID = "default_platform";
    private final File projectDirectory;
    private final String name;
    private final Collection<File> sourceRoots;
    private final Collection<File> testRoots;
    private final Collection<Library> compileLibraries;
    private final Collection<Library> runtimeLibraries;
    private final StringBuilder jvmArgs;
    private boolean hasDefaultRoots;
    private boolean skipTests;
    private SpecificationVersion defaultSourceLevel;
    private String mainClass;
    private String manifest;
    private String librariesDefinition;
    private String buildXmlName;
    private String distFolder;
    private String mainClassTemplate;
    private JavaPlatform platform;
    private static final String loggerName = "org.netbeans.ui.metrics.j2se";
    private static final String loggerKey = "USG_PROJECT_CREATE_J2SE";

    public J2SEProjectBuilder(@NonNull File projectDirectory, @NonNull String name) {
        Parameters.notNull("projectDirectory", projectDirectory);
        Parameters.notNull("name", name);
        this.projectDirectory = projectDirectory;
        this.name = name;
        this.sourceRoots = new ArrayList<File>();
        this.testRoots = new ArrayList<File>();
        this.jvmArgs = new StringBuilder();
        this.compileLibraries = new ArrayList<Library>();
        this.runtimeLibraries = new ArrayList<Library>();
        this.platform = JavaPlatformManager.getDefault().getDefaultPlatform();
    }

    public J2SEProjectBuilder addDefaultSourceRoots() {
        this.hasDefaultRoots = true;
        return this;
    }

    public J2SEProjectBuilder skipTests(boolean skipTests) {
        this.skipTests = skipTests;
        return this;
    }

    public J2SEProjectBuilder addSourceRoots(File ... sourceRoots) {
        Parameters.notNull("sourceRoots", sourceRoots);
        this.sourceRoots.addAll(Arrays.asList(sourceRoots));
        return this;
    }

    public J2SEProjectBuilder addTestRoots(File ... testRoots) {
        Parameters.notNull("testRoots", testRoots);
        this.testRoots.addAll(Arrays.asList(testRoots));
        return this;
    }

    public J2SEProjectBuilder addCompileLibraries(Library ... libraries) {
        Parameters.notNull("libraries", libraries);
        this.compileLibraries.addAll(Arrays.asList(libraries));
        return this;
    }

    public J2SEProjectBuilder addRuntimeLibraries(Library ... libraries) {
        Parameters.notNull("libraries", libraries);
        this.runtimeLibraries.addAll(Arrays.asList(libraries));
        return this;
    }

    public J2SEProjectBuilder setMainClass(@NullAllowed String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public J2SEProjectBuilder setManifest(@NullAllowed String manifest) {
        this.manifest = manifest;
        return this;
    }

    public J2SEProjectBuilder setLibrariesDefinitionFile(@NullAllowed String librariesDefinition) {
        this.librariesDefinition = librariesDefinition;
        return this;
    }

    public J2SEProjectBuilder setSourceLevel(@NullAllowed SpecificationVersion sourceLevel) {
        if (sourceLevel != null && SourceLevelQuery.MINIMAL_SOURCE_LEVEL.compareTo(sourceLevel) > 0) {
            throw new IllegalArgumentException(String.format("Source level less than %s is unsupported.", SourceLevelQuery.MINIMAL_SOURCE_LEVEL));
        }
        this.defaultSourceLevel = sourceLevel;
        return this;
    }

    public J2SEProjectBuilder setBuildXmlName(@NullAllowed String name) {
        this.buildXmlName = name;
        return this;
    }

    @NonNull
    public J2SEProjectBuilder setDistFolder(@NullAllowed String distFolderName) {
        this.distFolder = distFolderName;
        return this;
    }

    public J2SEProjectBuilder setMainClassTemplate(@NullAllowed String mainClassTemplatePath) {
        this.mainClassTemplate = mainClassTemplatePath;
        return this;
    }

    public J2SEProjectBuilder addJVMArguments(@NonNull String jvmArgs) {
        Parameters.notNull("jvmArgs", jvmArgs);
        if (this.jvmArgs.length() != 0) {
            this.jvmArgs.append(' ');
        }
        this.jvmArgs.append(jvmArgs);
        return this;
    }

    public J2SEProjectBuilder setJavaPlatform(@NonNull JavaPlatform platform) {
        Parameters.notNull("platform", platform);
        if (platform.getProperties().get("platform.ant.name") == null) {
            throw new IllegalArgumentException("Invalid platform, the platform has no platform.ant.name");
        }
        this.platform = platform;
        return this;
    }

    public AntProjectHelper build() throws IOException {
        FileObject dirFO = FileUtil.createFolder(this.projectDirectory);
        final AntProjectHelper[] h = new AntProjectHelper[1];
        FileObject[] srcFolder = new FileObject[1];
        dirFO.getFileSystem().runAtomicAction(() -> {
            SpecificationVersion sourceLevel = this.getSourceLevel();
            h[0] = J2SEProjectBuilder.createProject(dirFO, this.name, sourceLevel, this.hasDefaultRoots ? "src" : null, this.hasDefaultRoots ? "test" : null, this.skipTests, this.buildXmlName, this.distFolder, this.mainClass, this.manifest, this.manifest == null, this.librariesDefinition, this.jvmArgs.toString(), this.toClassPathElements(this.compileLibraries, new String[0]), this.toClassPathElements(this.runtimeLibraries, J2SEProjectUtil.ref("javac.classpath", false), J2SEProjectUtil.ref("build.classes.dir", true)), this.platform.getProperties().get("platform.ant.name"));
            final J2SEProject p = (J2SEProject)ProjectManager.getDefault().findProject(dirFO);
            ProjectManager.getDefault().saveProject(p);
            final ReferenceHelper refHelper = p.getReferenceHelper();
            try {
                ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        J2SEProjectBuilder.registerRoots(h[0], refHelper, J2SEProjectBuilder.this.sourceRoots, false);
                        J2SEProjectBuilder.registerRoots(h[0], refHelper, J2SEProjectBuilder.this.testRoots, true);
                        ProjectManager.getDefault().saveProject(p);
                        ArrayList<? extends Library> libsToCopy = new ArrayList<Library>();
                        libsToCopy.addAll(J2SEProjectBuilder.getMandatoryLibraries(J2SEProjectBuilder.this.skipTests));
                        libsToCopy.addAll(J2SEProjectBuilder.this.compileLibraries);
                        libsToCopy.addAll(J2SEProjectBuilder.this.runtimeLibraries);
                        J2SEProjectBuilder.copyRequiredLibraries(h[0], refHelper, libsToCopy);
                        ProjectUtils.getSources(p).getSourceGroups("java");
                        return null;
                    }
                });
            }
            catch (MutexException ex) {
                Exceptions.printStackTrace(ex.getException());
            }
            if (this.hasDefaultRoots) {
                srcFolder[0] = dirFO.createFolder("src");
                if (!this.skipTests) {
                    dirFO.createFolder("test");
                }
            } else if (!this.sourceRoots.isEmpty()) {
                srcFolder[0] = FileUtil.toFileObject(this.sourceRoots.iterator().next());
            }
        });
        if (this.mainClass != null && srcFolder[0] != null) {
            J2SEProjectBuilder.createMainClass(this.mainClass, srcFolder[0], this.mainClassTemplate);
        }
        return h[0];
    }

    public static void createDefaultModuleProperties(@NonNull EditableProperties ep, boolean hasUnitTests) {
        if (ep.getProperty("javac.modulepath") == null) {
            ep.setProperty("javac.modulepath", new String[0]);
        }
        if (ep.getProperty("javac.processormodulepath") == null) {
            ep.setProperty("javac.processormodulepath", new String[0]);
        }
        if (ep.getProperty("run.modulepath") == null) {
            ep.setProperty("run.modulepath", new String[]{J2SEProjectUtil.ref("javac.modulepath", true)});
        }
        if (ep.getProperty("debug.modulepath") == null) {
            ep.setProperty("debug.modulepath", new String[]{J2SEProjectUtil.ref("run.modulepath", true)});
        }
        if (ep.getProperty("javac.test.modulepath") == null) {
            ep.setProperty("javac.test.modulepath", new String[]{J2SEProjectUtil.ref("javac.modulepath", true)});
        }
        if (ep.getProperty("run.test.modulepath") == null) {
            ep.setProperty("run.test.modulepath", new String[]{J2SEProjectUtil.ref("javac.test.modulepath", true)});
        }
        if (ep.getProperty("debug.test.modulepath") == null) {
            ep.setProperty("debug.test.modulepath", new String[]{J2SEProjectUtil.ref("run.test.modulepath", true)});
        }
    }

    private static AntProjectHelper createProject(FileObject dirFO, String name, SpecificationVersion sourceLevel, String srcRoot, String testRoot, boolean skipTests, String buildXmlName, String distFolder, String mainClass, String manifestFile, boolean isLibrary, String librariesDefinition, String jvmArgs, String[] compileClassPath, String[] runtimeClassPath, @NonNull String platformId) throws IOException {
        String[] stringArray;
        String antName = PropertyUtils.getUsablePropertyName(name);
        AntProjectHelper h = ProjectGenerator.createProject(dirFO, "org.netbeans.modules.java.j2seproject", librariesDefinition);
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "name");
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        if (!DEFAULT_PLATFORM_ID.equals(platformId)) {
            Element platformEl = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "explicit-platform");
            SpecificationVersion jdk13 = new SpecificationVersion("1.3");
            boolean supportsExplicitSource = jdk13.compareTo(sourceLevel) < 0;
            platformEl.setAttribute("explicit-source-supported", Boolean.toString(supportsExplicitSource));
            data.appendChild(platformEl);
        }
        Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "source-roots");
        if (srcRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
            root.setAttribute("id", "src.dir");
            sourceRoots.appendChild(root);
            ep.setProperty("src.dir", srcRoot);
        }
        data.appendChild(sourceRoots);
        Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "test-roots");
        if (testRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
            root.setAttribute("id", "test.src.dir");
            testRoots.appendChild(root);
            ep.setProperty("test.src.dir", testRoot);
        }
        data.appendChild(testRoots);
        h.putPrimaryConfigurationData(data, true);
        ep.setProperty("annotation.processing.enabled", "true");
        ep.setProperty("annotation.processing.enabled.in.editor", "false");
        ep.setProperty("annotation.processing.run.all.processors", "true");
        ep.setProperty("annotation.processing.processors.list", "");
        ep.setProperty("annotation.processing.source.output", "${build.generated.sources.dir}/ap-source-output");
        ep.setProperty("annotation.processing.processor.options", "");
        ep.setProperty("dist.dir", distFolder != null ? distFolder : "dist");
        ep.setComment("dist.dir", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, "COMMENT_dist.dir")}, false);
        ep.setProperty("dist.jar", "${dist.dir}/" + antName + ".jar");
        ep.setProperty("javac.classpath", compileClassPath);
        ep.setProperty("javac.processorpath", new String[]{J2SEProjectUtil.ref("javac.classpath", true)});
        ep.setProperty("javac.test.processorpath", new String[]{J2SEProjectUtil.ref("javac.test.classpath", true)});
        ep.setProperty("build.sysclasspath", "ignore");
        ep.setComment("build.sysclasspath", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, "COMMENT_build.sysclasspath")}, false);
        ep.setProperty("run.classpath", runtimeClassPath);
        ep.setProperty("debug.classpath", new String[]{J2SEProjectUtil.ref("run.classpath", true)});
        ep.setComment("debug.classpath", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, "COMMENT_debug.transport"), "#debug.transport=dt_socket"}, false);
        ep.setProperty("jar.compress", "false");
        if (mainClass != null) {
            ep.setProperty("main.class", mainClass);
        } else if (!isLibrary) {
            ep.setProperty("main.class", "");
        }
        ep.setProperty("javac.compilerargs", "");
        ep.setComment("javac.compilerargs", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, "COMMENT_javac.compilerargs")}, false);
        ep.setProperty("javac.source", sourceLevel.toString());
        ep.setProperty("javac.target", sourceLevel.toString());
        ep.setProperty("javac.deprecation", "false");
        if (skipTests) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = J2SEProjectUtil.ref("javac.classpath", false);
            stringArray = stringArray2;
            stringArray2[1] = J2SEProjectUtil.ref("build.classes.dir", true);
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = J2SEProjectUtil.ref("javac.classpath", false);
            stringArray3[1] = J2SEProjectUtil.ref("build.classes.dir", false);
            stringArray3[2] = J2SEProjectUtil.ref("libs.junit.classpath", false);
            stringArray = stringArray3;
            stringArray3[3] = J2SEProjectUtil.ref("libs.junit_4.classpath", true);
        }
        ep.setProperty("javac.test.classpath", stringArray);
        ep.setProperty("run.test.classpath", new String[]{J2SEProjectUtil.ref("javac.test.classpath", false), J2SEProjectUtil.ref("build.test.classes.dir", true)});
        ep.setProperty("debug.test.classpath", new String[]{J2SEProjectUtil.ref("run.test.classpath", true)});
        ep.setProperty("build.generated.dir", "${build.dir}/generated");
        ep.setProperty("meta.inf.dir", "${src.dir}/META-INF");
        ep.setProperty("build.dir", "build");
        ep.setComment("build.dir", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, "COMMENT_build.dir")}, false);
        ep.setProperty("build.classes.dir", "${build.dir}/classes");
        ep.setProperty("build.generated.sources.dir", "${build.dir}/generated-sources");
        ep.setProperty("build.test.classes.dir", "${build.dir}/test/classes");
        ep.setProperty("build.test.results.dir", "${build.dir}/test/results");
        ep.setProperty("build.classes.excludes", "**/*.java,**/*.form");
        ep.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        ep.setProperty("platform.active", platformId);
        ep.setProperty("run.jvmargs", jvmArgs);
        ep.setComment("run.jvmargs", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, "COMMENT_run.jvmargs"), "# " + NbBundle.getMessage(J2SEProjectGenerator.class, "COMMENT_run.jvmargs_2"), "# " + NbBundle.getMessage(J2SEProjectGenerator.class, "COMMENT_run.jvmargs_3")}, false);
        ep.setProperty("javadoc.private", "false");
        ep.setProperty("javadoc.notree", "false");
        ep.setProperty("javadoc.use", "true");
        ep.setProperty("javadoc.nonavbar", "false");
        ep.setProperty("javadoc.noindex", "false");
        ep.setProperty("javadoc.splitindex", "true");
        ep.setProperty("javadoc.html5", "false");
        ep.setProperty("javadoc.author", "false");
        ep.setProperty("javadoc.version", "false");
        ep.setProperty("javadoc.windowtitle", "");
        ep.setProperty("javadoc.encoding", "${source.encoding}");
        ep.setProperty("javadoc.additionalparam", "");
        Charset enc = FileEncodingQuery.getDefaultEncoding();
        ep.setProperty("source.encoding", enc.name());
        if (manifestFile != null) {
            ep.setProperty("manifest.file", manifestFile);
        }
        if (buildXmlName != null) {
            ep.put("buildfile", buildXmlName);
        }
        ep.setProperty("mkdist.disabled", isLibrary ? "true" : "false");
        ep.setProperty("dist.archive.excludes", "");
        ep.setComment("dist.archive.excludes", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, "COMMENT_dist.archive.excludes")}, false);
        ep.setProperty("javac.external.vm", "true");
        J2SEProjectBuilder.createDefaultModuleProperties(ep, !skipTests);
        ep.setProperty("dist.jlink.dir", "${dist.dir}/jlink");
        ep.setProperty("dist.jlink.output", "${dist.jlink.dir}/" + antName);
        ep.setProperty("jlink.additionalmodules", "");
        ep.setComment("jlink.additionalmodules", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, "COMMENT_jlink.additionalmodules")}, false);
        ep.setProperty("jlink.additionalparam", "");
        ep.setComment("jlink.additionalparam", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, "COMMENT_jlink.additionalparam")}, false);
        ep.setProperty("jlink.launcher", "true");
        ep.setProperty("jlink.launcher.name", antName);
        h.putProperties("nbproject/project.properties", ep);
        ep = h.getProperties("nbproject/private/private.properties");
        ep.setProperty("compile.on.save", "true");
        h.putProperties("nbproject/private/private.properties", ep);
        J2SEProjectBuilder.logUsage();
        return h;
    }

    private static void registerRoots(AntProjectHelper helper, ReferenceHelper refHelper, Collection<? extends File> sourceFolders, boolean tests) {
        if (sourceFolders.isEmpty()) {
            return;
        }
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", tests ? "test-roots" : "source-roots");
        assert (nl.getLength() == 1);
        Element sourceRoots = (Element)nl.item(0);
        boolean first = true;
        for (File file : sourceFolders) {
            String name;
            if (first) {
                name = "src";
                first = false;
            } else {
                name = file.getName();
            }
            String propName = (tests ? "test." : "") + name + ".dir";
            int rootIndex = 1;
            EditableProperties props = helper.getProperties("nbproject/project.properties");
            while (props.containsKey(propName)) {
                propName = (tests ? "test." : "") + name + ++rootIndex + ".dir";
            }
            String srcReference = refHelper.createForeignFileReference(file, "java");
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
            root.setAttribute("id", propName);
            sourceRoots.appendChild(root);
            props = helper.getProperties("nbproject/project.properties");
            props.put(propName, srcReference);
            helper.putProperties("nbproject/project.properties", props);
        }
        helper.putPrimaryConfigurationData(data, true);
    }

    private static void logUsage() {
        LogRecord logRecord = new LogRecord(Level.INFO, loggerKey);
        logRecord.setLoggerName(loggerName);
        Logger.getLogger(loggerName).log(logRecord);
    }

    private SpecificationVersion getSourceLevel() {
        if (this.defaultSourceLevel != null) {
            return this.defaultSourceLevel;
        }
        SpecificationVersion v = this.platform.getSpecification().getVersion();
        return v;
    }

    private String[] toClassPathElements(@NonNull Collection<? extends Library> libraries, String ... additionalEntries) {
        String[] result = new String[libraries.size() + additionalEntries.length];
        Iterator<? extends Library> it = libraries.iterator();
        int i = 0;
        while (it.hasNext()) {
            Library lib = it.next();
            result[i] = "${libs." + lib.getName() + ".classpath}" + (it.hasNext() || additionalEntries.length != 0 ? ":" : "");
            ++i;
        }
        System.arraycopy(additionalEntries, 0, result, libraries.size(), additionalEntries.length);
        return result;
    }

    private static void createMainClass(@NonNull String mainClassName, @NonNull FileObject srcFolder, @NullAllowed String mainClassTemplate) throws IOException {
        DataFolder pDf;
        DataObject res;
        FileObject mainTemplate;
        String pName;
        String mName;
        int lastDotIdx = mainClassName.lastIndexOf(46);
        if (lastDotIdx == -1) {
            mName = mainClassName.trim();
            pName = null;
        } else {
            mName = mainClassName.substring(lastDotIdx + 1).trim();
            pName = mainClassName.substring(0, lastDotIdx).trim();
        }
        if (mName.length() == 0) {
            return;
        }
        if (mainClassTemplate == null) {
            mainClassTemplate = "Templates/Classes/Main.java";
        }
        if ((mainTemplate = FileUtil.getConfigFile(mainClassTemplate)) == null) {
            LOG.log(Level.WARNING, "Template {0} not found!", mainClassTemplate);
            return;
        }
        DataObject mt = DataObject.find(mainTemplate);
        FileObject pkgFolder = srcFolder;
        if (pName != null) {
            String fName = pName.replace('.', '/');
            pkgFolder = FileUtil.createFolder(srcFolder, fName);
        }
        if ((res = mt.createFromTemplate(pDf = DataFolder.findFolder(pkgFolder), mName)) == null || !res.isValid()) {
            LOG.log(Level.WARNING, "Template {0} created an invalid DataObject in folder {1}!", new Object[]{mainClassTemplate, FileUtil.getFileDisplayName(pkgFolder)});
        }
    }

    private static void copyRequiredLibraries(AntProjectHelper h, ReferenceHelper rh, Collection<? extends Library> libraries) throws IOException {
        if (!h.isSharableProject()) {
            return;
        }
        for (Library library : libraries) {
            String libName = library.getName();
            if (rh.getProjectLibraryManager().getLibrary(libName) != null || LibraryManager.getDefault().getLibrary(libName) == null) continue;
            rh.copyLibrary(LibraryManager.getDefault().getLibrary(libName));
        }
    }

    private static Collection<? extends Library> getMandatoryLibraries(boolean skipTests) {
        String[] stringArray;
        ArrayList<Library> result = new ArrayList<Library>();
        LibraryManager manager = LibraryManager.getDefault();
        if (skipTests) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "CopyLibs";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "junit";
            stringArray3[1] = "junit_4";
            stringArray = stringArray3;
            stringArray3[2] = "CopyLibs";
        }
        for (String mandatoryLib : stringArray) {
            Library lib = manager.getLibrary(mandatoryLib);
            if (lib == null) continue;
            result.add(lib);
        }
        return result;
    }
}

