/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.util.HashSet;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

final class OnShowingHandler
implements LookupListener,
Runnable {
    private final Set<String> onShowing = new HashSet<String>();
    private final Lookup lkpShowing;
    private final WindowManager wm;
    private Lookup.Result<Runnable> resShow;

    OnShowingHandler(Lookup lkp, WindowManager wm) {
        this.lkpShowing = lkp;
        this.wm = wm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() {
        for (Lookup.Item<Runnable> item : this.onShowing().allItems()) {
            Set<String> set = this.onShowing;
            synchronized (set) {
                Runnable r;
                if (this.onShowing.add(item.getId()) && (r = item.getInstance()) != null) {
                    this.wm.invokeWhenUIReady(r);
                }
            }
        }
    }

    private synchronized Lookup.Result<Runnable> onShowing() {
        if (this.resShow == null) {
            Lookup lkp = this.lkpShowing != null ? this.lkpShowing : Lookups.forPath("Modules/UIReady");
            this.resShow = lkp.lookupResult(Runnable.class);
            this.resShow.addLookupListener(this);
        }
        return this.resShow;
    }

    @Override
    public void resultChanged(LookupEvent ev) {
        this.initialize();
    }

    @Override
    public void run() {
        this.initialize();
    }
}

