/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.source.util;

import jpt.sun.source.tree.AnnotatedTypeTree;
import jpt.sun.source.tree.AnnotationTree;
import jpt.sun.source.tree.ArrayAccessTree;
import jpt.sun.source.tree.ArrayTypeTree;
import jpt.sun.source.tree.AssertTree;
import jpt.sun.source.tree.AssignmentTree;
import jpt.sun.source.tree.BinaryTree;
import jpt.sun.source.tree.BindingPatternTree;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.BreakTree;
import jpt.sun.source.tree.CaseTree;
import jpt.sun.source.tree.CatchTree;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.source.tree.CompoundAssignmentTree;
import jpt.sun.source.tree.ConditionalExpressionTree;
import jpt.sun.source.tree.ContinueTree;
import jpt.sun.source.tree.DefaultCaseLabelTree;
import jpt.sun.source.tree.DoWhileLoopTree;
import jpt.sun.source.tree.EmptyStatementTree;
import jpt.sun.source.tree.EnhancedForLoopTree;
import jpt.sun.source.tree.ErroneousTree;
import jpt.sun.source.tree.ExportsTree;
import jpt.sun.source.tree.ExpressionStatementTree;
import jpt.sun.source.tree.ForLoopTree;
import jpt.sun.source.tree.GuardedPatternTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.IfTree;
import jpt.sun.source.tree.ImportTree;
import jpt.sun.source.tree.InstanceOfTree;
import jpt.sun.source.tree.IntersectionTypeTree;
import jpt.sun.source.tree.LabeledStatementTree;
import jpt.sun.source.tree.LambdaExpressionTree;
import jpt.sun.source.tree.LiteralTree;
import jpt.sun.source.tree.MemberReferenceTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.ModifiersTree;
import jpt.sun.source.tree.ModuleTree;
import jpt.sun.source.tree.NewArrayTree;
import jpt.sun.source.tree.NewClassTree;
import jpt.sun.source.tree.OpensTree;
import jpt.sun.source.tree.PackageTree;
import jpt.sun.source.tree.ParameterizedTypeTree;
import jpt.sun.source.tree.ParenthesizedPatternTree;
import jpt.sun.source.tree.ParenthesizedTree;
import jpt.sun.source.tree.PrimitiveTypeTree;
import jpt.sun.source.tree.ProvidesTree;
import jpt.sun.source.tree.RequiresTree;
import jpt.sun.source.tree.ReturnTree;
import jpt.sun.source.tree.SwitchExpressionTree;
import jpt.sun.source.tree.SwitchTree;
import jpt.sun.source.tree.SynchronizedTree;
import jpt.sun.source.tree.ThrowTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.TreeVisitor;
import jpt.sun.source.tree.TryTree;
import jpt.sun.source.tree.TypeCastTree;
import jpt.sun.source.tree.TypeParameterTree;
import jpt.sun.source.tree.UnaryTree;
import jpt.sun.source.tree.UnionTypeTree;
import jpt.sun.source.tree.UsesTree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.tree.WhileLoopTree;
import jpt.sun.source.tree.WildcardTree;
import jpt.sun.source.tree.YieldTree;

public class TreeScanner<R, P>
implements TreeVisitor<R, P> {
    public R scan(Tree tree, P p) {
        return tree == null ? null : (R)tree.accept(this, p);
    }

    private R scanAndReduce(Tree node, P p, R r) {
        return this.reduce(this.scan(node, p), r);
    }

    public R scan(Iterable<? extends Tree> nodes, P p) {
        R r = null;
        if (nodes != null) {
            boolean first = true;
            for (Tree tree : nodes) {
                r = (R)(first ? this.scan(tree, p) : this.scanAndReduce(tree, p, r));
                first = false;
            }
        }
        return r;
    }

    private R scanAndReduce(Iterable<? extends Tree> nodes, P p, R r) {
        return this.reduce(this.scan(nodes, p), r);
    }

    public R reduce(R r1, R r2) {
        return r1;
    }

    @Override
    public R visitCompilationUnit(CompilationUnitTree node, P p) {
        R r = this.scan(node.getPackage(), p);
        r = this.scanAndReduce(node.getImports(), p, r);
        r = this.scanAndReduce(node.getTypeDecls(), p, r);
        r = this.scanAndReduce(node.getModule(), p, r);
        return r;
    }

    @Override
    public R visitPackage(PackageTree node, P p) {
        R r = this.scan(node.getAnnotations(), p);
        r = this.scanAndReduce(node.getPackageName(), p, r);
        return r;
    }

    @Override
    public R visitImport(ImportTree node, P p) {
        return this.scan(node.getQualifiedIdentifier(), p);
    }

    @Override
    public R visitClass(ClassTree node, P p) {
        R r = this.scan(node.getModifiers(), p);
        r = this.scanAndReduce(node.getTypeParameters(), p, r);
        r = this.scanAndReduce(node.getExtendsClause(), p, r);
        r = this.scanAndReduce(node.getImplementsClause(), p, r);
        r = this.scanAndReduce(node.getPermitsClause(), p, r);
        r = this.scanAndReduce(node.getMembers(), p, r);
        return r;
    }

    @Override
    public R visitMethod(MethodTree node, P p) {
        R r = this.scan(node.getModifiers(), p);
        r = this.scanAndReduce(node.getReturnType(), p, r);
        r = this.scanAndReduce(node.getTypeParameters(), p, r);
        r = this.scanAndReduce(node.getParameters(), p, r);
        r = this.scanAndReduce(node.getReceiverParameter(), p, r);
        r = this.scanAndReduce(node.getThrows(), p, r);
        r = this.scanAndReduce(node.getBody(), p, r);
        r = this.scanAndReduce(node.getDefaultValue(), p, r);
        return r;
    }

    @Override
    public R visitVariable(VariableTree node, P p) {
        R r = this.scan(node.getModifiers(), p);
        r = this.scanAndReduce(node.getType(), p, r);
        r = this.scanAndReduce(node.getNameExpression(), p, r);
        r = this.scanAndReduce(node.getInitializer(), p, r);
        return r;
    }

    @Override
    public R visitEmptyStatement(EmptyStatementTree node, P p) {
        return null;
    }

    @Override
    public R visitBlock(BlockTree node, P p) {
        return this.scan(node.getStatements(), p);
    }

    @Override
    public R visitDoWhileLoop(DoWhileLoopTree node, P p) {
        R r = this.scan(node.getStatement(), p);
        r = this.scanAndReduce(node.getCondition(), p, r);
        return r;
    }

    @Override
    public R visitWhileLoop(WhileLoopTree node, P p) {
        R r = this.scan(node.getCondition(), p);
        r = this.scanAndReduce(node.getStatement(), p, r);
        return r;
    }

    @Override
    public R visitForLoop(ForLoopTree node, P p) {
        R r = this.scan(node.getInitializer(), p);
        r = this.scanAndReduce(node.getCondition(), p, r);
        r = this.scanAndReduce(node.getUpdate(), p, r);
        r = this.scanAndReduce(node.getStatement(), p, r);
        return r;
    }

    @Override
    public R visitEnhancedForLoop(EnhancedForLoopTree node, P p) {
        R r = this.scan(node.getVariable(), p);
        r = this.scanAndReduce(node.getExpression(), p, r);
        r = this.scanAndReduce(node.getStatement(), p, r);
        return r;
    }

    @Override
    public R visitLabeledStatement(LabeledStatementTree node, P p) {
        return this.scan(node.getStatement(), p);
    }

    @Override
    public R visitSwitch(SwitchTree node, P p) {
        R r = this.scan(node.getExpression(), p);
        r = this.scanAndReduce(node.getCases(), p, r);
        return r;
    }

    @Override
    public R visitSwitchExpression(SwitchExpressionTree node, P p) {
        R r = this.scan(node.getExpression(), p);
        r = this.scanAndReduce(node.getCases(), p, r);
        return r;
    }

    @Override
    public R visitCase(CaseTree node, P p) {
        R r = this.scan(node.getExpressions(), p);
        r = node.getCaseKind() == CaseTree.CaseKind.RULE ? this.scanAndReduce(node.getBody(), p, r) : this.scanAndReduce(node.getStatements(), p, r);
        return r;
    }

    @Override
    public R visitSynchronized(SynchronizedTree node, P p) {
        R r = this.scan(node.getExpression(), p);
        r = this.scanAndReduce(node.getBlock(), p, r);
        return r;
    }

    @Override
    public R visitTry(TryTree node, P p) {
        R r = this.scan(node.getResources(), p);
        r = this.scanAndReduce(node.getBlock(), p, r);
        r = this.scanAndReduce(node.getCatches(), p, r);
        r = this.scanAndReduce(node.getFinallyBlock(), p, r);
        return r;
    }

    @Override
    public R visitCatch(CatchTree node, P p) {
        R r = this.scan(node.getParameter(), p);
        r = this.scanAndReduce(node.getBlock(), p, r);
        return r;
    }

    @Override
    public R visitConditionalExpression(ConditionalExpressionTree node, P p) {
        R r = this.scan(node.getCondition(), p);
        r = this.scanAndReduce(node.getTrueExpression(), p, r);
        r = this.scanAndReduce(node.getFalseExpression(), p, r);
        return r;
    }

    @Override
    public R visitIf(IfTree node, P p) {
        R r = this.scan(node.getCondition(), p);
        r = this.scanAndReduce(node.getThenStatement(), p, r);
        r = this.scanAndReduce(node.getElseStatement(), p, r);
        return r;
    }

    @Override
    public R visitExpressionStatement(ExpressionStatementTree node, P p) {
        return this.scan(node.getExpression(), p);
    }

    @Override
    public R visitBreak(BreakTree node, P p) {
        return null;
    }

    @Override
    public R visitContinue(ContinueTree node, P p) {
        return null;
    }

    @Override
    public R visitReturn(ReturnTree node, P p) {
        return this.scan(node.getExpression(), p);
    }

    @Override
    public R visitThrow(ThrowTree node, P p) {
        return this.scan(node.getExpression(), p);
    }

    @Override
    public R visitAssert(AssertTree node, P p) {
        R r = this.scan(node.getCondition(), p);
        r = this.scanAndReduce(node.getDetail(), p, r);
        return r;
    }

    @Override
    public R visitMethodInvocation(MethodInvocationTree node, P p) {
        R r = this.scan(node.getTypeArguments(), p);
        r = this.scanAndReduce(node.getMethodSelect(), p, r);
        r = this.scanAndReduce(node.getArguments(), p, r);
        return r;
    }

    @Override
    public R visitNewClass(NewClassTree node, P p) {
        R r = this.scan(node.getEnclosingExpression(), p);
        r = this.scanAndReduce(node.getIdentifier(), p, r);
        r = this.scanAndReduce(node.getTypeArguments(), p, r);
        r = this.scanAndReduce(node.getArguments(), p, r);
        r = this.scanAndReduce(node.getClassBody(), p, r);
        return r;
    }

    @Override
    public R visitNewArray(NewArrayTree node, P p) {
        R r = this.scan(node.getType(), p);
        r = this.scanAndReduce(node.getDimensions(), p, r);
        r = this.scanAndReduce(node.getInitializers(), p, r);
        r = this.scanAndReduce(node.getAnnotations(), p, r);
        for (Iterable iterable : node.getDimAnnotations()) {
            r = this.scanAndReduce(iterable, p, r);
        }
        return r;
    }

    @Override
    public R visitLambdaExpression(LambdaExpressionTree node, P p) {
        R r = this.scan(node.getParameters(), p);
        r = this.scanAndReduce(node.getBody(), p, r);
        return r;
    }

    @Override
    public R visitParenthesized(ParenthesizedTree node, P p) {
        return this.scan(node.getExpression(), p);
    }

    @Override
    public R visitAssignment(AssignmentTree node, P p) {
        R r = this.scan(node.getVariable(), p);
        r = this.scanAndReduce(node.getExpression(), p, r);
        return r;
    }

    @Override
    public R visitCompoundAssignment(CompoundAssignmentTree node, P p) {
        R r = this.scan(node.getVariable(), p);
        r = this.scanAndReduce(node.getExpression(), p, r);
        return r;
    }

    @Override
    public R visitUnary(UnaryTree node, P p) {
        return this.scan(node.getExpression(), p);
    }

    @Override
    public R visitBinary(BinaryTree node, P p) {
        R r = this.scan(node.getLeftOperand(), p);
        r = this.scanAndReduce(node.getRightOperand(), p, r);
        return r;
    }

    @Override
    public R visitTypeCast(TypeCastTree node, P p) {
        R r = this.scan(node.getType(), p);
        r = this.scanAndReduce(node.getExpression(), p, r);
        return r;
    }

    @Override
    public R visitInstanceOf(InstanceOfTree node, P p) {
        R r = this.scan(node.getExpression(), p);
        r = node.getPattern() != null ? this.scanAndReduce(node.getPattern(), p, r) : this.scanAndReduce(node.getType(), p, r);
        return r;
    }

    @Override
    public R visitBindingPattern(BindingPatternTree node, P p) {
        return this.scan(node.getVariable(), p);
    }

    @Override
    public R visitDefaultCaseLabel(DefaultCaseLabelTree node, P p) {
        return null;
    }

    @Override
    public R visitArrayAccess(ArrayAccessTree node, P p) {
        R r = this.scan(node.getExpression(), p);
        r = this.scanAndReduce(node.getIndex(), p, r);
        return r;
    }

    @Override
    public R visitMemberSelect(MemberSelectTree node, P p) {
        return this.scan(node.getExpression(), p);
    }

    @Override
    public R visitParenthesizedPattern(ParenthesizedPatternTree node, P p) {
        return this.scan(node.getPattern(), p);
    }

    @Override
    public R visitGuardedPattern(GuardedPatternTree node, P p) {
        R r = this.scan(node.getPattern(), p);
        return this.scanAndReduce(node.getExpression(), p, r);
    }

    @Override
    public R visitMemberReference(MemberReferenceTree node, P p) {
        R r = this.scan(node.getQualifierExpression(), p);
        r = this.scanAndReduce(node.getTypeArguments(), p, r);
        return r;
    }

    @Override
    public R visitIdentifier(IdentifierTree node, P p) {
        return null;
    }

    @Override
    public R visitLiteral(LiteralTree node, P p) {
        return null;
    }

    @Override
    public R visitPrimitiveType(PrimitiveTypeTree node, P p) {
        return null;
    }

    @Override
    public R visitArrayType(ArrayTypeTree node, P p) {
        return this.scan(node.getType(), p);
    }

    @Override
    public R visitParameterizedType(ParameterizedTypeTree node, P p) {
        R r = this.scan(node.getType(), p);
        r = this.scanAndReduce(node.getTypeArguments(), p, r);
        return r;
    }

    @Override
    public R visitUnionType(UnionTypeTree node, P p) {
        return this.scan(node.getTypeAlternatives(), p);
    }

    @Override
    public R visitIntersectionType(IntersectionTypeTree node, P p) {
        return this.scan(node.getBounds(), p);
    }

    @Override
    public R visitTypeParameter(TypeParameterTree node, P p) {
        R r = this.scan(node.getAnnotations(), p);
        r = this.scanAndReduce(node.getBounds(), p, r);
        return r;
    }

    @Override
    public R visitWildcard(WildcardTree node, P p) {
        return this.scan(node.getBound(), p);
    }

    @Override
    public R visitModifiers(ModifiersTree node, P p) {
        return this.scan(node.getAnnotations(), p);
    }

    @Override
    public R visitAnnotation(AnnotationTree node, P p) {
        R r = this.scan(node.getAnnotationType(), p);
        r = this.scanAndReduce(node.getArguments(), p, r);
        return r;
    }

    @Override
    public R visitAnnotatedType(AnnotatedTypeTree node, P p) {
        R r = this.scan(node.getAnnotations(), p);
        r = this.scanAndReduce(node.getUnderlyingType(), p, r);
        return r;
    }

    @Override
    public R visitModule(ModuleTree node, P p) {
        R r = this.scan(node.getAnnotations(), p);
        r = this.scanAndReduce(node.getName(), p, r);
        r = this.scanAndReduce(node.getDirectives(), p, r);
        return r;
    }

    @Override
    public R visitExports(ExportsTree node, P p) {
        R r = this.scan(node.getPackageName(), p);
        r = this.scanAndReduce(node.getModuleNames(), p, r);
        return r;
    }

    @Override
    public R visitOpens(OpensTree node, P p) {
        R r = this.scan(node.getPackageName(), p);
        r = this.scanAndReduce(node.getModuleNames(), p, r);
        return r;
    }

    @Override
    public R visitProvides(ProvidesTree node, P p) {
        R r = this.scan(node.getServiceName(), p);
        r = this.scanAndReduce(node.getImplementationNames(), p, r);
        return r;
    }

    @Override
    public R visitRequires(RequiresTree node, P p) {
        return this.scan(node.getModuleName(), p);
    }

    @Override
    public R visitUses(UsesTree node, P p) {
        return this.scan(node.getServiceName(), p);
    }

    @Override
    public R visitOther(Tree node, P p) {
        return null;
    }

    @Override
    public R visitErroneous(ErroneousTree node, P p) {
        return null;
    }

    @Override
    public R visitYield(YieldTree node, P p) {
        return this.scan(node.getValue(), p);
    }
}

